/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.omemo.AbstractOmemoMessageListener;
import org.jivesoftware.smackx.omemo.AbstractTwoUsersOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoMessage;
import org.jivesoftware.smackx.omemo.element.OmemoBundleElement_VAxolotl;
import org.jivesoftware.smackx.omemo.listener.OmemoMessageListener;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.Jid;

@SpecificationReference(document="XEP-0384", version="0.3.0")
public class MessageEncryptionIntegrationTest
extends AbstractTwoUsersOmemoIntegrationTest {
    public MessageEncryptionIntegrationTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, TestNotPossibleException {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void messageTest() throws Exception {
        OmemoBundleElement_VAxolotl b2;
        OmemoBundleElement_VAxolotl a1 = this.alice.getOmemoService().getOmemoStoreBackend().packOmemoBundle(this.alice.getOwnDevice());
        OmemoBundleElement_VAxolotl b1 = this.bob.getOmemoService().getOmemoStoreBackend().packOmemoBundle(this.bob.getOwnDevice());
        String body1 = "One is greater than zero (for small values of zero).";
        AbstractOmemoMessageListener.PreKeyMessageListener listener1 = new AbstractOmemoMessageListener.PreKeyMessageListener("One is greater than zero (for small values of zero).");
        this.bob.addOmemoMessageListener((OmemoMessageListener)listener1);
        OmemoMessage.Sent e1 = this.alice.encrypt(this.bob.getOwnJid(), "One is greater than zero (for small values of zero).");
        XMPPConnection alicesConnection = this.alice.getConnection();
        MessageBuilder messageBuilder = alicesConnection.getStanzaFactory().buildMessageStanza();
        alicesConnection.sendStanza((Stanza)e1.buildMessage(messageBuilder, (Jid)this.bob.getOwnJid()));
        listener1.getSyncPoint().waitForResult(10000L);
        this.bob.removeOmemoMessageListener((OmemoMessageListener)listener1);
        OmemoBundleElement_VAxolotl a1_ = this.alice.getOmemoService().getOmemoStoreBackend().packOmemoBundle(this.alice.getOwnDevice());
        OmemoManager omemoManager = this.bob;
        synchronized (omemoManager) {
            b2 = this.bob.getOmemoService().getOmemoStoreBackend().packOmemoBundle(this.bob.getOwnDevice());
        }
        Assertions.assertEquals((Object)a1, (Object)a1_, (String)"Alice sent bob a preKeyMessage, so her bundle MUST still be the same.");
        Assertions.assertNotEquals((Object)b1, (Object)b2, (String)"Bob just received a preKeyMessage from alice, so his bundle must have changed.");
        String body3 = "The german words for 'leek' and 'wimp' are the same.";
        AbstractOmemoMessageListener.MessageListener listener3 = new AbstractOmemoMessageListener.MessageListener("The german words for 'leek' and 'wimp' are the same.");
        this.alice.addOmemoMessageListener((OmemoMessageListener)listener3);
        OmemoMessage.Sent e3 = this.bob.encrypt(this.alice.getOwnJid(), "The german words for 'leek' and 'wimp' are the same.");
        XMPPConnection bobsConnection = this.bob.getConnection();
        messageBuilder = bobsConnection.getStanzaFactory().buildMessageStanza();
        bobsConnection.sendStanza((Stanza)e3.buildMessage(messageBuilder, (Jid)this.alice.getOwnJid()));
        listener3.getSyncPoint().waitForResult(10000L);
        this.alice.removeOmemoMessageListener((OmemoMessageListener)listener3);
        OmemoBundleElement_VAxolotl a1__ = this.alice.getOmemoService().getOmemoStoreBackend().packOmemoBundle(this.alice.getOwnDevice());
        OmemoBundleElement_VAxolotl b2_ = this.bob.getOmemoService().getOmemoStoreBackend().packOmemoBundle(this.bob.getOwnDevice());
        Assertions.assertEquals((Object)a1_, (Object)a1__, (String)"Since alice initiated the session with bob, at no time he sent a preKeyMessage, so her bundle MUST still be the same.");
        Assertions.assertEquals((Object)b2, (Object)b2_, (String)"Bob changed his bundle earlier, but at this point his bundle must be equal to after the first change.");
    }
}

