/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.IOException;
import java.util.List;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.mam.MamManager;
import org.jivesoftware.smackx.mam.element.MamPrefsIQ;
import org.jivesoftware.smackx.omemo.AbstractTwoUsersOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoMessage;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.util.MessageOrOmemoMessage;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.Jid;

@SpecificationReference(document="XEP-0384", version="0.3.0")
public class OmemoMamDecryptionTest
extends AbstractTwoUsersOmemoIntegrationTest {
    public OmemoMamDecryptionTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, TestNotPossibleException {
        super(environment);
        MamManager bobsMamManager = MamManager.getInstanceFor((XMPPConnection)this.conTwo);
        if (!bobsMamManager.isSupported()) {
            throw new TestNotPossibleException("Test is not possible, because MAM is not supported on the server.");
        }
    }

    @SmackIntegrationTest
    public void mamDecryptionTest() throws XMPPException.XMPPErrorException, SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, CryptoFailedException, UndecidedOmemoIdentityException, IOException {
        MamManager bobsMamManager = MamManager.getInstanceFor((XMPPConnection)this.bob.getConnection());
        bobsMamManager.enableMamForAllMessages();
        bobsMamManager.setDefaultBehavior(MamPrefsIQ.DefaultBehavior.always);
        this.bob.stopStanzaAndPEPListeners();
        String body = "This message will be stored in MAM!";
        OmemoMessage.Sent encrypted = this.alice.encrypt(this.bob.getOwnJid(), body);
        XMPPConnection alicesConnection = this.alice.getConnection();
        MessageBuilder messageBuilder = alicesConnection.getStanzaFactory().buildMessageStanza();
        alicesConnection.sendStanza((Stanza)encrypted.buildMessage(messageBuilder, (Jid)this.bob.getOwnJid()));
        MamManager.MamQuery query = bobsMamManager.queryArchive(MamManager.MamQueryArgs.builder().limitResultsToJid((Jid)this.alice.getOwnJid()).build());
        Assertions.assertEquals((int)1, (int)query.getMessageCount(), (String)("Unexpected message count in MAM query result of " + String.valueOf(this.bob.getConnection().getUser())));
        List decryptedMamQuery = this.bob.decryptMamQueryResult(query);
        Assertions.assertEquals((int)1, (int)decryptedMamQuery.size(), (String)("Unexpected decrypted message count in MAM query result of " + String.valueOf(this.bob.getConnection().getUser())));
        Assertions.assertEquals((Object)body, (Object)((MessageOrOmemoMessage)decryptedMamQuery.get(decryptedMamQuery.size() - 1)).getOmemoMessage().getBody(), (String)"Expected decrypted body of message retrieved via a MAM query to be equal to the original body that was sent (but it was not).");
    }
}

