/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.ConnectionConfigurationBuilderApplier;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.SmackIntegrationTestFramework;
import org.igniterealtime.smack.inttest.XmppConnectionDescriptor;
import org.igniterealtime.smack.inttest.debugger.SinttestDebugger;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.compression.CompressionModuleDescriptor;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.MultiMap;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.websocket.java11.Java11WebSocketFactory;
import org.jivesoftware.smack.websocket.okhttp.OkHttpWebSocketFactory;
import org.jivesoftware.smackx.admin.ServiceAdministrationManager;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.stringprep.XmppStringprepException;

public class XmppConnectionManager {
    private static final Logger LOGGER = Logger.getLogger(XmppConnectionManager.class.getName());
    private static final XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> DEFAULT_CONNECTION_DESCRIPTOR;
    private static final Map<String, XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>>> NICKNAME_CONNECTION_DESCRIPTORS;
    private static final MultiMap<Class<? extends AbstractXMPPConnection>, XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>>> CONNECTION_DESCRIPTORS;
    private final XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> defaultConnectionDescriptor;
    private final Map<String, XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>>> nicknameConnectionDescriptors;
    private final MultiMap<Class<? extends AbstractXMPPConnection>, XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>>> connectionDescriptors;
    private final SmackIntegrationTestFramework sinttestFramework;
    private final Configuration sinttestConfiguration;
    private final String testRunId;
    private final AbstractXMPPConnection accountRegistrationConnection;
    private final ServiceAdministrationManager adminManager;
    private final AccountManager accountManager;
    AbstractXMPPConnection conOne;
    AbstractXMPPConnection conTwo;
    AbstractXMPPConnection conThree;
    private final MultiMap<XmppConnectionDescriptor<?, ?, ?>, AbstractXMPPConnection> connectionPool = new MultiMap();
    private final Map<AbstractXMPPConnection, XmppConnectionDescriptor<?, ?, ?>> connections = new ConcurrentHashMap();
    private static final String USERNAME_PREFIX = "smack-inttest";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addConnectionDescriptor(XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> connectionDescriptor) {
        boolean alreadyExisted;
        String nickname = connectionDescriptor.getNickname();
        Class<? extends AbstractXMPPConnection> connectionClass = connectionDescriptor.getConnectionClass();
        MultiMap<Class<? extends AbstractXMPPConnection>, XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>>> multiMap = CONNECTION_DESCRIPTORS;
        synchronized (multiMap) {
            alreadyExisted = XmppConnectionManager.removeConnectionDescriptor(nickname);
            CONNECTION_DESCRIPTORS.put(connectionClass, connectionDescriptor);
            NICKNAME_CONNECTION_DESCRIPTORS.put(connectionDescriptor.getNickname(), connectionDescriptor);
        }
        return alreadyExisted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeConnectionDescriptor(String nickname) {
        MultiMap<Class<? extends AbstractXMPPConnection>, XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>>> multiMap = CONNECTION_DESCRIPTORS;
        synchronized (multiMap) {
            XmppConnectionDescriptor<AbstractXMPPConnection, ConnectionConfiguration, ConnectionConfiguration.Builder<?, ?>> connectionDescriptor = NICKNAME_CONNECTION_DESCRIPTORS.remove(nickname);
            if (connectionDescriptor == null) {
                return false;
            }
            boolean removed = CONNECTION_DESCRIPTORS.removeOne(connectionDescriptor.getConnectionClass(), connectionDescriptor);
            assert (removed);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmppConnectionManager(SmackIntegrationTestFramework sinttestFramework) throws SmackException, IOException, XMPPException, InterruptedException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        MultiMap<Class<? extends AbstractXMPPConnection>, XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>>> multiMap = CONNECTION_DESCRIPTORS;
        synchronized (multiMap) {
            this.connectionDescriptors = CONNECTION_DESCRIPTORS.clone();
            this.nicknameConnectionDescriptors = new HashMap(NICKNAME_CONNECTION_DESCRIPTORS);
        }
        this.sinttestFramework = sinttestFramework;
        this.sinttestConfiguration = sinttestFramework.config;
        this.testRunId = sinttestFramework.testRunResult.testRunId;
        String configuredDefaultConnectionNickname = this.sinttestConfiguration.defaultConnectionNickname;
        if (configuredDefaultConnectionNickname != null) {
            this.defaultConnectionDescriptor = this.nicknameConnectionDescriptors.get(configuredDefaultConnectionNickname);
            if (this.defaultConnectionDescriptor == null) {
                throw new IllegalArgumentException("Could not find a connection descriptor for connection nickname '" + configuredDefaultConnectionNickname + "'");
            }
        } else {
            this.defaultConnectionDescriptor = DEFAULT_CONNECTION_DESCRIPTOR;
        }
        switch (this.sinttestConfiguration.accountRegistration) {
            case serviceAdministration: 
            case inBandRegistration: {
                this.accountRegistrationConnection = this.defaultConnectionDescriptor.construct(this.sinttestConfiguration);
                this.accountRegistrationConnection.connect();
                if (this.sinttestConfiguration.accountRegistration == Configuration.AccountRegistration.inBandRegistration) {
                    this.adminManager = null;
                    this.accountManager = AccountManager.getInstance((XMPPConnection)this.accountRegistrationConnection);
                    break;
                }
                this.accountRegistrationConnection.login((CharSequence)this.sinttestConfiguration.adminAccountUsername, this.sinttestConfiguration.adminAccountPassword);
                this.adminManager = ServiceAdministrationManager.getInstanceFor((XMPPConnection)this.accountRegistrationConnection);
                this.accountManager = null;
                break;
            }
            case disabled: {
                this.accountRegistrationConnection = null;
                this.adminManager = null;
                this.accountManager = null;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    SmackIntegrationTestEnvironment prepareEnvironment() throws KeyManagementException, NoSuchAlgorithmException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SmackException, IOException, XMPPException, InterruptedException {
        this.prepareMainConnections();
        return new SmackIntegrationTestEnvironment(this.conOne, this.conTwo, this.conThree, this.sinttestFramework.testRunResult.testRunId, this.sinttestConfiguration, this);
    }

    private void prepareMainConnections() throws KeyManagementException, NoSuchAlgorithmException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SmackException, IOException, XMPPException, InterruptedException {
        int mainAccountCount = SmackIntegrationTestFramework.AccountNum.values().length;
        ArrayList<AbstractXMPPConnection> connections = new ArrayList<AbstractXMPPConnection>(mainAccountCount);
        for (SmackIntegrationTestFramework.AccountNum mainAccountNum : SmackIntegrationTestFramework.AccountNum.values()) {
            AbstractXMPPConnection mainConnection = this.getConnectedMainConnectionFor(mainAccountNum);
            connections.add(mainConnection);
        }
        this.conOne = (AbstractXMPPConnection)connections.get(0);
        this.conTwo = (AbstractXMPPConnection)connections.get(1);
        this.conThree = (AbstractXMPPConnection)connections.get(2);
    }

    public XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> getDefaultConnectionDescriptor() {
        return this.defaultConnectionDescriptor;
    }

    public Collection<XmppConnectionDescriptor<? extends AbstractXMPPConnection, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>>> getConnectionDescriptors() {
        return Collections.unmodifiableCollection(this.nicknameConnectionDescriptors.values());
    }

    public <C extends AbstractXMPPConnection> XmppConnectionDescriptor<C, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> getConnectionDescriptorFor(Class<C> connectionClass) {
        return (XmppConnectionDescriptor)this.connectionDescriptors.getFirst(connectionClass);
    }

    void disconnectAndCleanup() throws InterruptedException {
        int successfullyDeletedAccountsCount = 0;
        for (AbstractXMPPConnection connection : this.connections.keySet()) {
            Localpart usernameAsLocalpart;
            if (this.sinttestConfiguration.accountRegistration == Configuration.AccountRegistration.inBandRegistration) {
                AccountManager accountManager = AccountManager.getInstance((XMPPConnection)connection);
                try {
                    accountManager.deleteAccount();
                    ++successfullyDeletedAccountsCount;
                }
                catch (SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                    LOGGER.log(Level.WARNING, "Could not delete dynamically registered account", e);
                }
            }
            connection.disconnect();
            if (this.sinttestConfiguration.accountRegistration != Configuration.AccountRegistration.serviceAdministration) continue;
            String username = connection.getConfiguration().getUsername().toString();
            try {
                usernameAsLocalpart = Localpart.from((String)username);
            }
            catch (XmppStringprepException e) {
                throw new AssertionError((Object)e);
            }
            EntityBareJid connectionAddress = JidCreate.entityBareFrom((Localpart)usernameAsLocalpart, (DomainBareJid)this.sinttestConfiguration.service);
            try {
                this.adminManager.deleteUser(connectionAddress);
                ++successfullyDeletedAccountsCount;
            }
            catch (SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Could not delete dynamically registered account", e);
            }
        }
        if (this.sinttestConfiguration.isAccountRegistrationPossible()) {
            int unsuccessfullyDeletedAccountsCount = this.connections.size() - successfullyDeletedAccountsCount;
            if (unsuccessfullyDeletedAccountsCount == 0) {
                LOGGER.info("Successfully deleted all created accounts \u2714");
            } else {
                LOGGER.warning("Could not delete all created accounts, " + unsuccessfullyDeletedAccountsCount + " remaining");
            }
        }
        this.connections.clear();
        if (this.accountRegistrationConnection != null) {
            this.accountRegistrationConnection.disconnect();
        }
    }

    private AbstractXMPPConnection getConnectedMainConnectionFor(SmackIntegrationTestFramework.AccountNum accountNum) throws SmackException, IOException, XMPPException, InterruptedException, KeyManagementException, NoSuchAlgorithmException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String finalAccountPassword;
        String middlefix;
        String accountPassword;
        String accountUsername;
        switch (accountNum) {
            case One: {
                accountUsername = this.sinttestConfiguration.accountOneUsername;
                accountPassword = this.sinttestConfiguration.accountOnePassword;
                middlefix = "one";
                break;
            }
            case Two: {
                accountUsername = this.sinttestConfiguration.accountTwoUsername;
                accountPassword = this.sinttestConfiguration.accountTwoPassword;
                middlefix = "two";
                break;
            }
            case Three: {
                accountUsername = this.sinttestConfiguration.accountThreeUsername;
                accountPassword = this.sinttestConfiguration.accountThreePassword;
                middlefix = "three";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        String finalAccountUsername = StringUtils.isNullOrEmpty((CharSequence)accountUsername) ? "smack-inttest-" + middlefix + "-" + this.testRunId : accountUsername;
        String string = finalAccountPassword = StringUtils.isNullOrEmpty((CharSequence)accountPassword) ? StringUtils.insecureRandomString((int)16) : accountPassword;
        if (this.sinttestConfiguration.isAccountRegistrationPossible()) {
            this.registerAccount(finalAccountUsername, finalAccountPassword);
        }
        ArrayList<ConnectionConfigurationBuilderApplier> connectionConfigurationAppliers = new ArrayList<ConnectionConfigurationBuilderApplier>();
        connectionConfigurationAppliers.add(builder -> {
            try {
                builder.setUsernameAndPassword((CharSequence)finalAccountUsername, finalAccountPassword).setResource((CharSequence)(middlefix + "-" + this.testRunId));
            }
            catch (XmppStringprepException e) {
                throw new IllegalArgumentException(e);
            }
        });
        SinttestDebugger sinttestDebugger = this.sinttestFramework.sinttestDebugger;
        if (sinttestDebugger != null) {
            ConnectionConfigurationBuilderApplier applier = sinttestDebugger.getConnectionConfigurationBuilderApplier();
            connectionConfigurationAppliers.add(applier);
        }
        AbstractXMPPConnection mainConnection = this.defaultConnectionDescriptor.construct(this.sinttestConfiguration, connectionConfigurationAppliers);
        this.connections.put(mainConnection, this.defaultConnectionDescriptor);
        mainConnection.connect();
        mainConnection.login();
        return mainConnection;
    }

    private void registerAccount(String username, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, XmppStringprepException {
        if (this.accountRegistrationConnection == null) {
            throw new IllegalStateException("Account registration not configured");
        }
        switch (this.sinttestConfiguration.accountRegistration) {
            case serviceAdministration: {
                EntityBareJid userJid = JidCreate.entityBareFrom((Localpart)Localpart.from((String)username), (DomainBareJid)this.accountRegistrationConnection.getXMPPServiceDomain());
                this.adminManager.addUser(userJid, password);
                break;
            }
            case inBandRegistration: {
                if (!this.accountManager.supportsAccountCreation()) {
                    throw new UnsupportedOperationException("Account creation/registration is not supported");
                }
                Set requiredAttributes = this.accountManager.getAccountAttributes();
                if (requiredAttributes.size() > 4) {
                    throw new IllegalStateException("Unknown required attributes");
                }
                HashMap<String, String> additionalAttributes = new HashMap<String, String>();
                additionalAttributes.put("name", "Smack Integration Test");
                additionalAttributes.put("email", "flow@igniterealtime.org");
                Localpart usernameLocalpart = Localpart.from((String)username);
                this.accountManager.createAccount(usernameLocalpart, password, additionalAttributes);
                break;
            }
            case disabled: {
                throw new IllegalStateException("Account creation no possible");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <C extends AbstractXMPPConnection> List<C> constructConnectedConnections(XmppConnectionDescriptor<C, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> connectionDescriptor, int count) throws InterruptedException, SmackException, IOException, XMPPException {
        ArrayList<Object> connections = new ArrayList<Object>(count);
        MultiMap<XmppConnectionDescriptor<?, ?, ?>, AbstractXMPPConnection> multiMap = this.connectionPool;
        synchronized (multiMap) {
            List pooledConnections = this.connectionPool.getAll(connectionDescriptor);
            while (count > 0 && !pooledConnections.isEmpty()) {
                AbstractXMPPConnection connection = (AbstractXMPPConnection)pooledConnections.remove(pooledConnections.size() - 1);
                connections.add(connection);
                --count;
            }
        }
        for (int i = 0; i < count; ++i) {
            C connection = this.constructConnectedConnection(connectionDescriptor);
            connections.add(connection);
        }
        return connections;
    }

    private <C extends AbstractXMPPConnection> C constructConnectedConnection(XmppConnectionDescriptor<C, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> connectionDescriptor) throws InterruptedException, SmackException, IOException, XMPPException {
        C connection = this.constructConnection(connectionDescriptor, null);
        connection.connect();
        connection.login();
        return connection;
    }

    AbstractXMPPConnection constructConnection() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.constructConnection(this.defaultConnectionDescriptor);
    }

    AbstractXMPPConnection constructConnectedConnection() throws InterruptedException, SmackException, IOException, XMPPException {
        return this.constructConnectedConnection(this.defaultConnectionDescriptor);
    }

    <C extends AbstractXMPPConnection> C constructConnection(XmppConnectionDescriptor<C, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> connectionDescriptor) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.constructConnection(connectionDescriptor, null);
    }

    private <C extends AbstractXMPPConnection> C constructConnection(XmppConnectionDescriptor<C, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> connectionDescriptor, Collection<ConnectionConfigurationBuilderApplier> customConnectionConfigurationAppliers) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        String username = "sinttest-" + this.testRunId + "-" + (this.connections.size() + 1);
        String password = StringUtils.randomString((int)24);
        return this.constructConnection(username, password, connectionDescriptor, customConnectionConfigurationAppliers);
    }

    private <C extends AbstractXMPPConnection> C constructConnection(String username, String password, XmppConnectionDescriptor<C, ? extends ConnectionConfiguration, ? extends ConnectionConfiguration.Builder<?, ?>> connectionDescriptor, Collection<ConnectionConfigurationBuilderApplier> customConnectionConfigurationAppliers) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        C connection;
        try {
            this.registerAccount(username, password);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException(e);
        }
        if (customConnectionConfigurationAppliers == null) {
            customConnectionConfigurationAppliers = new ArrayList<ConnectionConfigurationBuilderApplier>();
        }
        ConnectionConfigurationBuilderApplier usernameAndPasswordApplier = configurationBuilder -> configurationBuilder.setUsernameAndPassword((CharSequence)username, password);
        customConnectionConfigurationAppliers.add(usernameAndPasswordApplier);
        SinttestDebugger sinttestDebugger = this.sinttestFramework.sinttestDebugger;
        if (sinttestDebugger != null) {
            ConnectionConfigurationBuilderApplier applier = sinttestDebugger.getConnectionConfigurationBuilderApplier();
            customConnectionConfigurationAppliers.add(applier);
        }
        try {
            connection = connectionDescriptor.construct(this.sinttestConfiguration, customConnectionConfigurationAppliers);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        this.connections.put((AbstractXMPPConnection)connection, connectionDescriptor);
        return connection;
    }

    void recycle(Collection<? extends AbstractXMPPConnection> connections) {
        for (AbstractXMPPConnection abstractXMPPConnection : connections) {
            this.recycle(abstractXMPPConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycle(AbstractXMPPConnection connection) {
        Class<?> connectionClass = connection.getClass();
        if (!this.connectionDescriptors.containsKey(connectionClass)) {
            throw new IllegalStateException("Attempt to recycle unknown connection of class '" + String.valueOf(connectionClass) + "'");
        }
        if (connection.isAuthenticated()) {
            XmppConnectionDescriptor<?, ?, ?> connectionDescriptor = this.connections.get(connection);
            if (connectionDescriptor == null) {
                throw new IllegalStateException("Attempt to recycle unknown connection: " + String.valueOf(connection));
            }
            MultiMap<XmppConnectionDescriptor<?, ?, ?>, AbstractXMPPConnection> multiMap = this.connectionPool;
            synchronized (multiMap) {
                this.connectionPool.put(connectionDescriptor, (Object)connection);
            }
        } else {
            connection.disconnect();
        }
    }

    static {
        NICKNAME_CONNECTION_DESCRIPTORS = new HashMap();
        CONNECTION_DESCRIPTORS = new MultiMap();
        try {
            DEFAULT_CONNECTION_DESCRIPTOR = XmppConnectionDescriptor.buildWith(XMPPTCPConnection.class, XMPPTCPConnectionConfiguration.class).withNickname("tcp").build();
            XmppConnectionManager.addConnectionDescriptor(DEFAULT_CONNECTION_DESCRIPTOR);
            XmppConnectionManager.addConnectionDescriptor(XmppConnectionDescriptor.buildWith(ModularXmppClientToServerConnection.class, ModularXmppClientToServerConnectionConfiguration.class).withNickname("modular").build());
            XmppConnectionManager.addConnectionDescriptor(XmppConnectionDescriptor.buildWith(ModularXmppClientToServerConnection.class, ModularXmppClientToServerConnectionConfiguration.class, ModularXmppClientToServerConnectionConfiguration.Builder.class).withNickname("modular-nocompress").applyExtraConfiguration(cb -> cb.removeModule(CompressionModuleDescriptor.class)).build());
            XmppConnectionManager.addConnectionDescriptor(XmppConnectionDescriptor.buildWebsocketDescriptor("modular-websocket-okhttp", OkHttpWebSocketFactory.class));
            XmppConnectionManager.addConnectionDescriptor(XmppConnectionDescriptor.buildWebsocketDescriptor("modular-websocket-java11", Java11WebSocketFactory.class));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }
}

