/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest.debugger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.igniterealtime.smack.inttest.FailedTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestFramework;
import org.igniterealtime.smack.inttest.debugger.SinttestDebugger;
import org.igniterealtime.smack.inttest.util.ResultSyncPoint;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SimpleAbstractDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.util.ExceptionUtil;

public class StandardSinttestDebugger
implements SinttestDebugger {
    protected static final Logger LOGGER = Logger.getLogger(StandardSinttestDebugger.class.getName());
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
    private final Object currentWriterLock = new Object();
    private Writer currentWriter;
    private Path currentTestMethodDirectory;
    private final Path basePath;
    private final Writer completeWriter;
    private final Writer outsideTestWriter;
    private final Writer testsWriter;
    private final boolean console;

    public StandardSinttestDebugger(ZonedDateTime restRunStart, String testRunId, String options) {
        String tmpdir = System.getProperty("java.io.tmpdir");
        if ("/tmp".equals(tmpdir)) {
            tmpdir = "/var/tmp";
        }
        Path basePath = Paths.get(tmpdir, "sinttest-" + System.getProperty("user.name"), DATE_TIME_FORMATTER.format(restRunStart) + "-" + testRunId);
        boolean console = true;
        if (options != null) {
            block24: for (String keyValue : options.split(",")) {
                String[] keyValueArray = keyValue.split("=");
                if (keyValueArray.length != 2) {
                    throw new IllegalArgumentException("Illegal key/value string: " + keyValue);
                }
                String key = keyValueArray[0];
                String value = keyValueArray[1];
                switch (key) {
                    case "console": {
                        switch (value) {
                            case "on": {
                                console = true;
                                continue block24;
                            }
                            case "off": {
                                console = false;
                                continue block24;
                            }
                        }
                        throw new IllegalArgumentException("Invalid argument console=" + value + ", only off/on are allowed");
                    }
                    case "dir": {
                        switch (value) {
                            case "off": {
                                basePath = null;
                                continue block24;
                            }
                        }
                        basePath = Path.of(value, new String[0]);
                        continue block24;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown key: " + key);
                    }
                }
            }
        }
        if (basePath != null) {
            this.basePath = basePath;
            Path completeLogFile = this.basePath.resolve("completeLog");
            Path outsideTestLogFile = this.basePath.resolve("outsideTestLog");
            Path testsFile = this.basePath.resolve("tests");
            try {
                StandardSinttestDebugger.mkdirs(this.basePath);
                this.completeWriter = Files.newBufferedWriter(completeLogFile, new OpenOption[0]);
                this.outsideTestWriter = this.currentWriter = Files.newBufferedWriter(outsideTestLogFile, new OpenOption[0]);
                this.testsWriter = Files.newBufferedWriter(testsFile, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.basePath = null;
            this.completeWriter = null;
            this.outsideTestWriter = null;
            this.testsWriter = null;
        }
        this.console = console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSink(String logMessage) {
        if (this.basePath != null) {
            try {
                Object object = this.currentWriterLock;
                synchronized (object) {
                    this.currentWriter.append(logMessage).append('\n');
                }
                this.completeWriter.append(logMessage).append('\n');
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, String.valueOf(e) + " while appending log message", e);
            }
        }
        if (this.console) {
            System.out.println(logMessage);
        }
    }

    @Override
    public SmackDebuggerFactory getSmackDebuggerFactory() {
        return c -> new StandardSinttestSmackDebugger(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTestClassConstruction(Constructor<? extends AbstractSmackIntTest> constructor) throws IOException {
        if (this.basePath == null) {
            return;
        }
        Path testClassDirectory = this.basePath.resolve(constructor.getDeclaringClass().getSimpleName());
        StandardSinttestDebugger.mkdirs(testClassDirectory);
        Path logFile = testClassDirectory.resolve("log");
        BufferedWriter newWriter = Files.newBufferedWriter(logFile, new OpenOption[0]);
        Object object = this.currentWriterLock;
        synchronized (object) {
            this.currentWriter = newWriter;
        }
        this.completeWriter.append("Constructing: " + String.valueOf(constructor.getDeclaringClass()) + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTestStart(SmackIntegrationTestFramework.ConcreteTest test, ZonedDateTime startTime) throws IOException {
        if (this.basePath == null) {
            return;
        }
        Method testMethod = test.getMethod();
        Path testClassDirectory = this.basePath.resolve(testMethod.getDeclaringClass().getSimpleName());
        StringBuilder testName = new StringBuilder(testMethod.getName());
        for (String subdescription : test.getSubdescriptons()) {
            testName.append('-').append(subdescription);
        }
        this.currentTestMethodDirectory = testClassDirectory.resolve(testName.toString());
        StandardSinttestDebugger.mkdirs(this.currentTestMethodDirectory);
        Path logFile = this.currentTestMethodDirectory.resolve("log");
        BufferedWriter newWriter = Files.newBufferedWriter(logFile, new OpenOption[0]);
        Object object = this.currentWriterLock;
        synchronized (object) {
            this.currentWriter = newWriter;
        }
        this.completeWriter.append("START: " + String.valueOf(test) + "\n");
        this.testsWriter.append(test.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTestEnd(Throwable throwable) throws IOException {
        Writer oldWriter;
        if (this.basePath == null) {
            return;
        }
        Object object = this.currentWriterLock;
        synchronized (object) {
            oldWriter = this.currentWriter;
            this.currentWriter = this.outsideTestWriter;
        }
        if (oldWriter != null) {
            oldWriter.close();
        }
        if (throwable == null) {
            this.testsWriter.append(" \u2713");
        } else {
            this.testsWriter.append(" \u2717 [FAILED: ").append(throwable.getClass().getSimpleName()).append(']');
        }
        this.testsWriter.append('\n');
    }

    private Path createTestMarkerFile(String name) throws IOException {
        if (this.currentTestMethodDirectory == null) {
            return null;
        }
        Path failedMarker = this.currentTestMethodDirectory.resolve(name);
        return Files.createFile(failedMarker, new FileAttribute[0]);
    }

    @Override
    public void onTestSuccess(SmackIntegrationTestFramework.ConcreteTest test, ZonedDateTime endTime) throws IOException {
        this.logSink("TEST SUCCESSFUL: " + String.valueOf(test));
        this.createTestMarkerFile("successful");
        this.onTestEnd(null);
    }

    @Override
    public void onTestFailure(SmackIntegrationTestFramework.ConcreteTest test, ZonedDateTime endTime, Throwable throwable) throws IOException {
        String stacktrace = ExceptionUtil.getStackTrace((Throwable)throwable);
        this.logSink("TEST FAILED: " + String.valueOf(test) + "\n" + stacktrace);
        Path markerFile = this.createTestMarkerFile("failed");
        if (markerFile != null) {
            Files.writeString(markerFile, (CharSequence)stacktrace, new OpenOption[0]);
        }
        if (this.currentTestMethodDirectory != null && throwable instanceof ResultSyncPoint.ResultSyncPointTimeoutException) {
            ResultSyncPoint.ResultSyncPointTimeoutException resultSyncPointTimeoutException = (ResultSyncPoint.ResultSyncPointTimeoutException)throwable;
            String threadDump = resultSyncPointTimeoutException.getThreadDump();
            Path threadDumpFile = this.currentTestMethodDirectory.resolve("thread-dump");
            Files.writeString(threadDumpFile, (CharSequence)threadDump, new OpenOption[0]);
            this.logSink("Wrote thread dump to file://" + String.valueOf(threadDumpFile));
        }
        this.onTestEnd(throwable);
    }

    @Override
    public void onSinttestFinished(SmackIntegrationTestFramework.TestRunResult testRunResult) throws IOException {
        if (this.basePath == null) {
            return;
        }
        this.outsideTestWriter.close();
        this.completeWriter.close();
        this.testsWriter.close();
        Path failedTestsFile = this.basePath.resolve("tests-failed");
        try (BufferedWriter failedTestsWriter = Files.newBufferedWriter(failedTestsFile, new OpenOption[0]);){
            for (FailedTest failed : testRunResult.getFailedTests()) {
                failedTestsWriter.append(failed.concreteTest.toString()).append(" \u2717 [FAILED: ").append(failed.failureReason.getClass().getSimpleName()).append("]\n");
            }
        }
        LOGGER.info("Test data file://" + String.valueOf(this.basePath));
    }

    private static void mkdirs(Path path) throws IOException {
        File dir = path.toFile();
        if (dir.exists()) {
            return;
        }
        boolean created = dir.mkdirs();
        if (!created) {
            throw new IOException("Could not create directory " + String.valueOf(path));
        }
    }

    private class StandardSinttestSmackDebugger
    extends SimpleAbstractDebugger {
        StandardSinttestSmackDebugger(XMPPConnection connection) {
            super(connection);
        }

        protected void logSink(String logMessage) {
            StandardSinttestDebugger.this.logSink(logMessage);
        }
    }
}

