/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest.util;

import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.util.ThreadDumpUtil;
import org.jivesoftware.smack.util.Objects;

public class ResultSyncPoint<R, E extends Exception> {
    private R result;
    private E exception;

    public R waitForResult(long timeout) throws E, InterruptedException, ResultSyncPointTimeoutException {
        return this.waitForResult(timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R waitForResult(long timeout, String timeoutMessage) throws E, InterruptedException, ResultSyncPointTimeoutException {
        ResultSyncPoint resultSyncPoint = this;
        synchronized (resultSyncPoint) {
            long now;
            if (this.result != null) {
                return this.result;
            }
            if (this.exception != null) {
                throw this.exception;
            }
            long deadline = System.currentTimeMillis() + timeout;
            while (this.result == null && this.exception == null && (now = System.currentTimeMillis()) < deadline) {
                this.wait(deadline - now);
            }
        }
        if (this.result != null) {
            return this.result;
        }
        if (this.exception != null) {
            throw this.exception;
        }
        String message = "Timeout after " + timeout + "ms";
        if (timeoutMessage != null) {
            message = message + ": " + timeoutMessage;
        }
        throw new ResultSyncPointTimeoutException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(R result) {
        ResultSyncPoint resultSyncPoint = this;
        synchronized (resultSyncPoint) {
            this.result = Objects.requireNonNull(result);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(E exception) {
        ResultSyncPoint resultSyncPoint = this;
        synchronized (resultSyncPoint) {
            this.exception = (Exception)Objects.requireNonNull(exception);
            this.notifyAll();
        }
    }

    public static class ResultSyncPointTimeoutException
    extends TimeoutException {
        private static final long serialVersionUID = 1L;
        private final String threadDump = ThreadDumpUtil.threadDump();

        public ResultSyncPointTimeoutException(String message) {
            super(message);
        }

        public String getThreadDump() {
            return this.threadDump;
        }
    }
}

