/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;

@SpecificationReference(document="XEP-0096", version="1.3.1")
public class FileTransferIntegrationTest
extends AbstractSmackIntegrationTest {
    private static final int MAX_FT_DURATION = 360;
    private final FileTransferManager ftManagerOne;
    private final FileTransferManager ftManagerTwo;
    private static final byte[] dataToSend = StringUtils.insecureRandomString((int)20480).getBytes(StandardCharsets.UTF_8);

    public FileTransferIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.ftManagerOne = FileTransferManager.getInstanceFor((XMPPConnection)this.conOne);
        this.ftManagerTwo = FileTransferManager.getInstanceFor((XMPPConnection)this.conTwo);
    }

    @SmackIntegrationTest
    public void fileTransferTest() throws Exception {
        this.genericfileTransferTest();
    }

    @SmackIntegrationTest
    public void ibbFileTransferTest() throws Exception {
        FileTransferNegotiator.IBB_ONLY = true;
        this.genericfileTransferTest();
        FileTransferNegotiator.IBB_ONLY = false;
    }

    private void genericfileTransferTest() throws Exception {
        final SimpleResultSyncPoint resultSyncPoint = new SimpleResultSyncPoint();
        FileTransferListener receiveListener = new FileTransferListener(){

            public void fileTransferRequest(FileTransferRequest request) {
                IncomingFileTransfer ift = request.accept();
                try {
                    int nRead;
                    InputStream is = ift.receiveFile();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while ((nRead = is.read(buf, 0, buf.length)) != -1) {
                        os.write(buf, 0, nRead);
                    }
                    os.flush();
                    byte[] dataReceived = os.toByteArray();
                    if (Arrays.equals(dataToSend, dataReceived)) {
                        resultSyncPoint.signal();
                    } else {
                        resultSyncPoint.signal(new Exception("Received data does not match"));
                    }
                }
                catch (IOException | InterruptedException | SmackException | XMPPException.XMPPErrorException e) {
                    resultSyncPoint.signal(e);
                }
            }
        };
        this.ftManagerTwo.addFileTransferListener(receiveListener);
        OutgoingFileTransfer oft = this.ftManagerOne.createOutgoingFileTransfer(this.conTwo.getUser());
        oft.sendStream((InputStream)new ByteArrayInputStream(dataToSend), "hello.txt", (long)dataToSend.length, "A greeting");
        int duration = 0;
        while (!oft.isDone()) {
            FileTransfer.Status status = oft.getStatus();
            switch (status) {
                case error: {
                    FileTransfer.Error error = oft.getError();
                    Exception exception = oft.getException();
                    throw new Exception("FileTransfer error: " + String.valueOf(error), exception);
                }
            }
            LOGGER.info("FileTransfer status: " + String.valueOf(oft.getStatus()) + ". Progress: " + oft.getProgress());
            Thread.sleep(1000L);
            if (++duration <= 360) continue;
            throw new Exception("Max duration reached");
        }
        FileTransferIntegrationTest.assertResult(resultSyncPoint, 360000L, "Expected data to be transferred successfully from " + String.valueOf(this.conOne.getUser()) + " to " + String.valueOf(this.conTwo.getUser()) + " (but it did not).");
        this.ftManagerTwo.removeFileTransferListener(receiveListener);
    }
}

