/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.List;
import java.util.logging.Level;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MucConfigFormManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public abstract class AbstractMultiUserChatIntegrationTest
extends AbstractSmackIntegrationTest {
    final String randomString = StringUtils.insecureRandomString((int)6);
    final MultiUserChatManager mucManagerOne;
    final MultiUserChatManager mucManagerTwo;
    final MultiUserChatManager mucManagerThree;
    final DomainBareJid mucService;
    final Resourcepart nicknameOne = Resourcepart.from((String)("one-" + this.randomString));
    final Resourcepart nicknameTwo = Resourcepart.from((String)("two-" + this.randomString));
    final Resourcepart nicknameThree = Resourcepart.from((String)("three-" + this.randomString));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractMultiUserChatIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, XmppStringprepException {
        super(environment);
        this.mucManagerOne = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conOne);
        this.mucManagerTwo = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conTwo);
        this.mucManagerThree = MultiUserChatManager.getInstanceFor((XMPPConnection)this.conThree);
        List services = this.mucManagerOne.getMucServiceDomains();
        if (services.isEmpty()) {
            throw new TestNotPossibleException("No MUC (XEP-0045) service found");
        }
        DomainBareJid needle = null;
        for (DomainBareJid service : services) {
            MultiUserChat multiUserChat = null;
            try {
                String roomNameLocal = String.join((CharSequence)"-", "smack-inttest-abstract", this.testRunId, StringUtils.insecureRandomString((int)6));
                EntityBareJid mucAddress = JidCreate.entityBareFrom((Localpart)Localpart.from((String)roomNameLocal), (Domainpart)service.getDomain());
                multiUserChat = this.mucManagerOne.getMultiUserChat(mucAddress);
                AbstractMultiUserChatIntegrationTest.createMuc(multiUserChat, this.nicknameOne);
                needle = service;
                AbstractMultiUserChatIntegrationTest.tryDestroy(multiUserChat);
                break;
            }
            catch (XMPPException.XMPPErrorException e) {
                AbstractMultiUserChatIntegrationTest.mucCreationDisallowedOrThrow(e);
                LOGGER.log(Level.FINER, "MUC service " + String.valueOf(service) + " does not allow MUC creation", e);
            }
            finally {
                AbstractMultiUserChatIntegrationTest.tryDestroy(multiUserChat);
            }
        }
        if (needle == null) {
            throw new TestNotPossibleException("No MUC (XEP-0045) service found that allows test users to createa new room. Considered MUC services: " + String.valueOf(services));
        }
        this.mucService = needle;
    }

    static void mucCreationDisallowedOrThrow(XMPPException.XMPPErrorException e) throws XMPPException.XMPPErrorException {
        StanzaError.Condition condition = e.getStanzaError().getCondition();
        if (condition == StanzaError.Condition.not_allowed) {
            return;
        }
        throw e;
    }

    public EntityBareJid getRandomRoom(String prefix) throws XmppStringprepException {
        String roomNameLocal = String.join((CharSequence)"-", "sinttest", prefix, this.testRunId, StringUtils.insecureRandomString((int)3));
        return JidCreate.entityBareFrom((Localpart)Localpart.from((String)roomNameLocal), (Domainpart)this.mucService.getDomain());
    }

    static void tryDestroy(MultiUserChat muc) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (muc == null) {
            return;
        }
        muc.destroy("test fixture teardown", null);
    }

    static void createMuc(MultiUserChat muc, Resourcepart resourceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException {
        muc.create(resourceName).makeInstant();
    }

    @Deprecated
    static void createMuc(MultiUserChat muc, String nickname) throws XmppStringprepException, MultiUserChatException.MucAlreadyJoinedException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, SmackException.NoResponseException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        AbstractMultiUserChatIntegrationTest.createMuc(muc, Resourcepart.from((String)nickname));
    }

    static void createMuc(MultiUserChat muc, Resourcepart nickname, MucConfigFormManager.MucConfigApplier applier) throws MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        muc.create(nickname);
        AbstractMultiUserChatIntegrationTest.modifyMuc(muc, applier);
    }

    static void modifyMuc(MultiUserChat muc, MucConfigFormManager.MucConfigApplier applier) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        MucConfigFormManager configManager = muc.getConfigFormManager();
        try {
            configManager.applyAndSubmit(applier);
        }
        catch (MultiUserChatException.MucConfigurationNotSupportedException e) {
            throw new TestNotPossibleException("Unable to modify MUC room: " + e.getMessage(), e);
        }
    }

    static void createMembersOnlyMuc(MultiUserChat muc, Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.MucConfigurationNotSupportedException, MultiUserChatException.NotAMucServiceException, TestNotPossibleException {
        AbstractMultiUserChatIntegrationTest.createMuc(muc, nickname, a -> a.makeMembersOnly());
    }

    static void createModeratedMuc(MultiUserChat muc, Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, MultiUserChatException.MucConfigurationNotSupportedException, TestNotPossibleException {
        AbstractMultiUserChatIntegrationTest.createMuc(muc, nickname, a -> a.makeModerated());
    }

    static void createHiddenMuc(MultiUserChat muc, Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, XmppStringprepException, MultiUserChatException.MucConfigurationNotSupportedException, TestNotPossibleException {
        AbstractMultiUserChatIntegrationTest.createMuc(muc, nickname, a -> a.makeHidden());
    }

    static void createMucNonAnonymous(MultiUserChat muc, Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, TestNotPossibleException {
        AbstractMultiUserChatIntegrationTest.createMuc(muc, nickname, a -> a.setWhoisAllowedBy(MucConfigFormManager.WhoisAllowedBy.anyone));
    }

    static void createMucSemiAnonymous(MultiUserChat muc, Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, TestNotPossibleException {
        AbstractMultiUserChatIntegrationTest.createMuc(muc, nickname, a -> a.setWhoisAllowedBy(MucConfigFormManager.WhoisAllowedBy.moderators));
    }

    static void setMucPasswordProtected(MultiUserChat muc, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, TestNotPossibleException {
        AbstractMultiUserChatIntegrationTest.modifyMuc(muc, a -> a.setAndEnablePassword(password));
    }

    static void setMaxUsers(MultiUserChat muc, int maxUsers) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException, TestNotPossibleException {
        AbstractMultiUserChatIntegrationTest.modifyMuc(muc, a -> a.setMaxUsers(maxUsers));
    }
}

