/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.MultiResultSyncPoint;
import org.igniterealtime.smack.inttest.util.ResultSyncPoint;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.PresenceListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.sm.predicates.ForEveryMessage;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.AbstractMultiUserChatIntegrationTest;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

@SpecificationReference(document="XEP-0045", version="1.34.6")
public class MultiUserChatOccupantIntegrationTest
extends AbstractMultiUserChatIntegrationTest {
    public MultiUserChatOccupantIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException, XmppStringprepException {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.1 & 7.2.2", quote="\u00a7 7.1 The order of events involved in joining a room needs to be consistent so that clients can know which events to expect when. After a client sends presence to join a room, the MUC service MUST send it events in the following order: 1. In-room presence from other occupants 2. In-room presence from the joining entity itself (so-called \"self-presence\") 3. Room history (if any) 4. The room subject [...]\u00a7 7.2.2 This self-presence MUST NOT be sent to the new occupant until the room has sent the presence of all other occupants to the new occupant ... The service MUST first send the complete list of the existing occupants to the new occupant and only then send the new occupant's own presence to the new occupant")
    public void mucJoinEventOrderingTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("eventordering");
        String mucSubject = "Subject smack-inttest-eventordering " + this.randomString;
        String mucMessage = "Message smack-inttest-eventordering " + this.randomString;
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        ResultSyncPoint subjectResultSyncPoint = new ResultSyncPoint();
        ArrayList results = new ArrayList();
        StanzaListener stanzaListener = stanza -> {
            Message message;
            String subject;
            results.add(stanza);
            if (stanza instanceof Message && (subject = (message = (Message)stanza).getSubject()) != null) {
                subjectResultSyncPoint.signal(subject);
            }
        };
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            mucAsSeenByOne.changeSubject(mucSubject);
            SimpleResultSyncPoint messageReflectionSyncPoint = new SimpleResultSyncPoint();
            mucAsSeenByOne.addMessageListener(message -> {
                String body = message.getBody();
                if (body == null) {
                    return;
                }
                if (body.equals(mucMessage)) {
                    messageReflectionSyncPoint.signal();
                }
            });
            mucAsSeenByOne.sendMessage(mucMessage);
            messageReflectionSyncPoint.waitForResult(this.timeout);
            this.conTwo.addStanzaListener(stanzaListener, (StanzaFilter)FromMatchesFilter.createStrictChildOf((BareJid)mucAddress));
            mucAsSeenByTwo.join(this.nicknameTwo);
            subjectResultSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)4, (int)results.size(), (String)("Unexpected amount of stanzas received by '" + String.valueOf(this.conTwo.getUser()) + "' after it joined room '" + String.valueOf(mucAddress) + "'. Results: " + String.valueOf(results)));
            Assertions.assertTrue((boolean)(results.get(0) instanceof Presence), (String)("Expected the first stanza that was received by '" + String.valueOf(this.conTwo.getUser()) + "' after it joined room '" + String.valueOf(mucAddress) + "' to be a presence stanza (but it was not)."));
            Assertions.assertEquals((Object)JidCreate.fullFrom((BareJid)mucAddress, (Resourcepart)this.nicknameOne), (Object)((Stanza)results.get(0)).getFrom(), (String)("Unexpected 'from' address of the first stanza that was received by '" + String.valueOf(this.conTwo.getUser()) + "' after it joined room '" + String.valueOf(mucAddress) + "'."));
            Assertions.assertTrue((boolean)(results.get(1) instanceof Presence), (String)("Expected the second stanza that was received by '" + String.valueOf(this.conTwo.getUser()) + "' after it joined room '" + String.valueOf(mucAddress) + "' to be a presence stanza (but it was not)."));
            Assertions.assertEquals((Object)JidCreate.fullFrom((BareJid)mucAddress, (Resourcepart)this.nicknameTwo), (Object)((Stanza)results.get(1)).getFrom(), (String)("Unexpected 'from' address of the seconds stanza that was received by '" + String.valueOf(this.conTwo.getUser()) + "' after it joined room '" + String.valueOf(mucAddress) + "'."));
            Assertions.assertTrue((boolean)(results.get(2) instanceof Message), (String)("Expected the third stanza that was received by '" + String.valueOf(this.conTwo.getUser()) + "' after it joined room '" + String.valueOf(mucAddress) + "' to be a message stanza (but it was not)."));
            Assertions.assertEquals((Object)mucMessage, (Object)((Message)results.get(2)).getBody(), (String)("The third stanza that was received by '" + String.valueOf(this.conTwo.getUser()) + "' after it joined room '" + String.valueOf(mucAddress) + "' was expected to be a different stanza."));
            Assertions.assertTrue((boolean)(results.get(3) instanceof Message), (String)("Expected the fourth stanza that was received by '" + String.valueOf(this.conTwo.getUser()) + "' after it joined room '" + String.valueOf(mucAddress) + "' to be a message stanza (but it was not)."));
            Assertions.assertEquals((Object)mucSubject, (Object)((Message)results.get(3)).getSubject(), (String)("The fourth stanza that was received by '" + String.valueOf(this.conTwo.getUser()) + "' after it joined room '" + String.valueOf(mucAddress) + "' was expected to be a different stanza."));
        }
        finally {
            MultiUserChatOccupantIntegrationTest.tryDestroy(mucAsSeenByOne);
            this.conTwo.removeStanzaListener(stanzaListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.1 & 7.4", quote="\u00a7 7.2.1: In order to participate in the discussions held in a multi-user chat room, a user MUST first become an occupant by entering the room [...] \u00a7 7.4: If the sender is not an occupant of the room, the service SHOULD return a <not-acceptable/> error to the sender and SHOULD NOT reflect the message to all occupants")
    public void mucSendBeforeJoiningTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("send-without-joining");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            ResultSyncPoint errorMessageResultSyncPoint = new ResultSyncPoint();
            this.conTwo.addStanzaListener(packet -> errorMessageResultSyncPoint.signal((Message)packet), (StanzaFilter)ForEveryMessage.INSTANCE);
            ResultSyncPoint distributedMessageResultSyncPoint = new ResultSyncPoint();
            mucAsSeenByOne.addMessageListener(distributedMessageResultSyncPoint::signal);
            mucAsSeenByTwo.sendMessage("Message without Joining");
            Message response = (Message)this.assertResult(errorMessageResultSyncPoint, "Expected an error to be returned to '" + String.valueOf(this.conTwo.getUser()) + "' after it sent a message to room '" + String.valueOf(mucAddress) + "' without joining it first (but no error was returned).");
            Assertions.assertEquals((Object)StanzaError.Condition.not_acceptable, (Object)response.getError().getCondition(), (String)("Unexpected error condition in the (expected) error that was returned to '" + String.valueOf(this.conTwo.getUser()) + "' after it sent a message to room '" + String.valueOf(mucAddress) + "' without joining it first."));
            Assertions.assertThrows(TimeoutException.class, () -> distributedMessageResultSyncPoint.waitForResult(1000L), (String)("Occupant '" + String.valueOf(this.conOne.getUser()) + "' should NOT have seen the message that was sent by '" + String.valueOf(this.conTwo.getUser()) + "' to room '" + String.valueOf(mucAddress) + "' without the sender have joined the room (but the message was observed by the occupant)."));
        }
        finally {
            MultiUserChatOccupantIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.2", quote="If the service is able to add the user to the room, it MUST send presence from all the existing participants' occupant JIDs to the new occupant's full JID, including extended presence information about roles in a single <x/> element qualified by the 'http://jabber.org/protocol/muc#user' namespace and containing an <item/> child with the 'role' attribute set to a value of \"moderator\", \"participant\", or \"visitor\", and with the 'affiliation' attribute set to a value of \"owner\", \"admin\", \"member\", or \"none\" as appropriate. [...] the \"self-presence\" sent by the room to the new user MUST include a status code of 110 so that the user knows this presence refers to itself as an occupant [...] The service MUST first send the complete list of the existing occupants to the new occupant and only then send the new occupant's own presence to the new occupant.")
    public void mucJoinPresenceInformationTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("presenceinfo");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            SimpleResultSyncPoint oneSeesTwo = new SimpleResultSyncPoint();
            mucAsSeenByOne.addParticipantListener(presence -> {
                if (this.nicknameTwo.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    oneSeesTwo.signal();
                }
            });
            mucAsSeenByTwo.join(this.nicknameTwo);
            oneSeesTwo.waitForResult(this.timeout);
            mucAsSeenByOne.grantModerator(this.nicknameTwo);
            ArrayList results = new ArrayList();
            mucAsSeenByThree.addParticipantListener(results::add);
            mucAsSeenByThree.join(this.nicknameThree);
            Assertions.assertEquals((int)3, (int)results.size(), (String)("Unexpected amount of occupants seen by '" + String.valueOf(this.conThree) + "' in room '" + String.valueOf(mucAddress) + "' after joining."));
            Assertions.assertNotNull((Object)MUCUser.from((Stanza)((Stanza)results.get(0))), (String)("Expected to be able to parse a MUC occupant from '" + String.valueOf(results.get(0)) + "', but could not. Its syntax is likely incorrect."));
            MUCItem mucItemSelf = MUCUser.from((Stanza)((Stanza)results.get(2))).getItem();
            HashSet<MUCItem> others = new HashSet<MUCItem>();
            others.add(MUCUser.from((Stanza)((Stanza)results.get(0))).getItem());
            others.add(MUCUser.from((Stanza)((Stanza)results.get(1))).getItem());
            Assertions.assertEquals((Object)MUCAffiliation.none, (Object)mucItemSelf.getAffiliation(), (String)("Unexpected MUC affiliation in reflected self-presence of '" + String.valueOf(this.conThree.getUser()) + "' joining room '" + String.valueOf(mucAddress) + "'."));
            Assertions.assertEquals((long)1L, (long)others.stream().filter(item -> MUCAffiliation.owner.equals((Object)item.getAffiliation())).count(), (String)("Unexpected amount of other occupants in room '" + String.valueOf(mucAddress) + "' (as observed by '" + String.valueOf(this.conThree.getUser()) + "') that have the 'owner' affiliation."));
            Assertions.assertEquals((long)1L, (long)others.stream().filter(item -> MUCAffiliation.none.equals((Object)item.getAffiliation())).count(), (String)("Unexpected amount of other occupants in room '" + String.valueOf(mucAddress) + "' (as observed by '" + String.valueOf(this.conThree.getUser()) + "') that have no affiliation."));
            Assertions.assertEquals((Object)MUCRole.participant, (Object)mucItemSelf.getRole(), (String)("Unexpected MUC role in reflected self-presence of '" + String.valueOf(this.conThree.getUser()) + "' joining room '" + String.valueOf(mucAddress) + "'."));
            Assertions.assertEquals((long)2L, (long)others.stream().filter(item -> MUCRole.moderator.equals((Object)item.getRole())).count(), (String)("Unexpected amount of other occupants in room '" + String.valueOf(mucAddress) + "' (as observed by '" + String.valueOf(this.conThree.getUser()) + "') that have the 'moderator' role."));
            Assertions.assertTrue((boolean)MUCUser.from((Stanza)((Stanza)results.get(2))).getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110), (String)("Expected to find status '" + String.valueOf(MUCUser.Status.PRESENCE_TO_SELF_110) + "' in reflected self-presence of '" + String.valueOf(this.conThree.getUser()) + "' joining room '" + String.valueOf(mucAddress) + "' (but did not)."));
        }
        finally {
            MultiUserChatOccupantIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.2", quote="the service MUST also send presence from the new participant's occupant JID to the full JIDs of all the occupants (including the new occupant)")
    public void mucJoinPresenceBroadcastTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("presenceinfo");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            mucAsSeenByTwo.join(this.nicknameTwo);
            MultiResultSyncPoint syncPoint = new MultiResultSyncPoint(2);
            mucAsSeenByOne.addParticipantListener(presence -> {
                if (this.nicknameThree.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    syncPoint.signal(presence);
                }
            });
            mucAsSeenByTwo.addParticipantListener(presence -> {
                if (this.nicknameThree.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    syncPoint.signal(presence);
                }
            });
            mucAsSeenByThree.join(this.nicknameThree);
            List results = this.assertResult(syncPoint, "Expected all occupants of room '" + String.valueOf(mucAddress) + "' to be notified of '" + String.valueOf(this.conThree.getUser()) + "' using nickname '" + String.valueOf(this.nicknameThree) + "' joining the room (but one or more did not get notified)");
            Assertions.assertTrue((boolean)results.stream().allMatch(result -> JidCreate.fullFrom((BareJid)mucAddress, (Resourcepart)this.nicknameThree).equals((CharSequence)result.getFrom())), (String)("Expected all occupants of room '" + String.valueOf(mucAddress) + "' to be notified of '" + String.valueOf(this.conThree.getUser()) + "' using nickname '" + String.valueOf(this.nicknameThree) + "' joining the room (but one or more got notified for a different user)."));
            Assertions.assertTrue((boolean)results.stream().anyMatch(result -> result.getTo().equals((CharSequence)this.conOne.getUser().asEntityFullJidIfPossible())), (String)("Expected '" + String.valueOf(this.conOne.getUser().asEntityFullJidIfPossible()) + "' to be notified of '" + String.valueOf(this.conThree.getUser()) + "' joining room '" + String.valueOf(mucAddress) + "' (but did not)"));
            Assertions.assertTrue((boolean)results.stream().anyMatch(result -> result.getTo().equals((CharSequence)this.conTwo.getUser().asEntityFullJidIfPossible())), (String)("Expected '" + String.valueOf(this.conTwo.getUser().asEntityFullJidIfPossible()) + "' to be notified of '" + String.valueOf(this.conThree.getUser()) + "' joining room '" + String.valueOf(mucAddress) + "' (but did not)"));
        }
        finally {
            MultiUserChatOccupantIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.3", quote="If the room is non-anonymous, the service MUST send the new occupant's full JID to all occupants using extended presence information in an <x/> element qualified by the 'http://jabber.org/protocol/muc#user' namespace and containing an <item/> child with a 'jid' attribute specifying the occupant's full JID. [...]If the user is entering a room that is non-anonymous (i.e., which informs all occupants of each occupant's full JID as shown above), the service MUST warn the user by including a status code of \"100\" in the initial presence that the room sends to the new occupant.")
    public void mucJoinNonAnonymousRoomTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("joinnonanonymousroom");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChatOccupantIntegrationTest.createMucNonAnonymous(mucAsSeenByOne, this.nicknameOne);
        try {
            ResultSyncPoint participantOneSyncPoint = new ResultSyncPoint();
            mucAsSeenByOne.addParticipantListener(presence -> {
                if (this.nicknameTwo.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantOneSyncPoint.signal(presence);
                }
            });
            ResultSyncPoint participantTwoSyncPoint = new ResultSyncPoint();
            mucAsSeenByTwo.addParticipantListener(presence -> {
                if (this.nicknameTwo.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantTwoSyncPoint.signal(presence);
                }
            });
            mucAsSeenByTwo.join(this.nicknameTwo);
            Presence presenceReceivedByOne = (Presence)this.assertResult(participantOneSyncPoint, "Expected '" + String.valueOf(this.conOne.getUser()) + "' to receive a presence stanza after '" + String.valueOf(this.conTwo.getUser()) + "' joined room '" + String.valueOf(mucAddress) + "' (but did not).");
            Presence presenceReceivedByTwo = (Presence)this.assertResult(participantTwoSyncPoint, "Expected '" + String.valueOf(this.conTwo.getUser()) + "' to receive a presence stanza after they themselves joined room '" + String.valueOf(mucAddress) + "' (but did not).");
            MUCUser announcedParticipantTwoUser = MUCUser.from((Stanza)presenceReceivedByOne);
            Assertions.assertNotNull((Object)announcedParticipantTwoUser, (String)("Expected to be able to parse a MUC occupant from '" + String.valueOf(presenceReceivedByOne) + "', but could not. Its syntax is likely incorrect."));
            Assertions.assertNotNull((Object)announcedParticipantTwoUser.getItem(), (String)("Expected to be able to parse a MUC occupant item from '" + String.valueOf(presenceReceivedByOne) + "', but could not. Its syntax is likely incorrect."));
            Assertions.assertEquals((Object)this.conTwo.getUser().asEntityFullJidOrThrow(), (Object)announcedParticipantTwoUser.getItem().getJid(), (String)("Expected extended presence information received by '" + String.valueOf(this.conOne.getUser()) + "' after '" + String.valueOf(this.conTwo.getUser()) + "' joined room '" + String.valueOf(mucAddress) + "' to include their full JID."));
            Assertions.assertTrue((boolean)MUCUser.from((Stanza)presenceReceivedByTwo).getStatus().stream().anyMatch(status -> 100 == status.getCode()), (String)("Expected to find status '100' in reflected self-presence of '" + String.valueOf(this.conTwo.getUser()) + "' joining room '" + String.valueOf(mucAddress) + "' (but did not)."));
        }
        finally {
            MultiUserChatOccupantIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.4", quote="If the room is semi-anonymous, the service MUST send presence from the new occupant to all occupants as specified above (i.e., unless the room is configured to not broadcast presence from new occupants below a certain affiliation level as controlled by the \"muc#roomconfig_presencebroadcast\" room configuration option), but MUST include the new occupant's full JID only in the presence notifications it sends to occupants with a role of \"moderator\" and not to non-moderator occupants.")
    public void mucJoinSemiAnonymousRoomReceivedByNonModeratorTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("seminanonymous-by-non-moderator");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        MultiUserChatOccupantIntegrationTest.createMucSemiAnonymous(mucAsSeenByOne, this.nicknameOne);
        try {
            mucAsSeenByTwo.join(this.nicknameTwo);
            ResultSyncPoint participantTwoSyncPoint = new ResultSyncPoint();
            mucAsSeenByTwo.addParticipantListener(presence -> {
                if (this.nicknameThree.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantTwoSyncPoint.signal(presence);
                }
            });
            mucAsSeenByThree.join(this.nicknameThree);
            Presence presenceReceivedByTwo = (Presence)this.assertResult(participantTwoSyncPoint, "Expected '" + String.valueOf(this.conTwo.getUser()) + "' to receive presence when '" + String.valueOf(this.conThree.getUser()) + "' joined room '" + String.valueOf(mucAddress) + "' (but did not).");
            Assertions.assertNull((Object)MUCUser.from((Stanza)presenceReceivedByTwo).getItem().getJid(), (String)("Did not expect '" + String.valueOf(this.conTwo.getUser()) + "' (who is not a moderator at this stage) to receive the full JID of '" + String.valueOf(this.conThree.getUser()) + "' when they joined room '" + String.valueOf(mucAddress) + "' (but they did)."));
        }
        finally {
            MultiUserChatOccupantIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.4", quote="If the room is semi-anonymous, the service MUST send presence from the new occupant to all occupants as specified above (i.e., unless the room is configured to not broadcast presence from new occupants below a certain affiliation level as controlled by the \"muc#roomconfig_presencebroadcast\" room configuration option), but MUST include the new occupant's full JID only in the presence notifications it sends to occupants with a role of \"moderator\" and not to non-moderator occupants.")
    public void mucJoinSemiAnonymousRoomReceivedByModeratorTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("seminanonymous-by-moderator");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        MultiUserChatOccupantIntegrationTest.createMucSemiAnonymous(mucAsSeenByOne, this.nicknameOne);
        try {
            mucAsSeenByTwo.join(this.nicknameTwo);
            mucAsSeenByOne.grantModerator(this.nicknameTwo);
            ResultSyncPoint participantTwoSyncPoint = new ResultSyncPoint();
            mucAsSeenByTwo.addParticipantListener(presence -> {
                if (this.nicknameThree.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantTwoSyncPoint.signal(presence);
                }
            });
            mucAsSeenByThree.join(this.nicknameThree);
            Presence presenceReceivedByTwo = (Presence)this.assertResult(participantTwoSyncPoint, "Expected '" + String.valueOf(this.conTwo.getUser()) + "' to receive presence when '" + String.valueOf(this.conThree.getUser()) + "' joined room '" + String.valueOf(mucAddress) + "' (but did not).");
            MUCUser announcedParticipantThreeUser = MUCUser.from((Stanza)presenceReceivedByTwo);
            Assertions.assertEquals((Object)this.conThree.getUser().asEntityFullJidOrThrow(), (Object)announcedParticipantThreeUser.getItem().getJid(), (String)("Expected '" + String.valueOf(this.conTwo.getUser()) + "' (who is a moderator at this stage) to receive the full JID of '" + String.valueOf(this.conThree.getUser()) + "' when they joined room '" + String.valueOf(mucAddress) + "' (but they did not)."));
        }
        finally {
            MultiUserChatOccupantIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.5", quote="If the room requires a password and the user did not supply one (or the password provided is incorrect), the service MUST deny access to the room and inform the user that they are unauthorized; this is done by returning a presence stanza of type \"error\" specifying a <not-authorized/> error.")
    public void mucJoinPasswordProtectedWithoutPasswordRoomTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("enterpasswordprotectedroom");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        String correctPassword = StringUtils.insecureRandomString((int)8);
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            MultiUserChatOccupantIntegrationTest.setMucPasswordProtected(mucAsSeenByOne, correctPassword);
            XMPPException.XMPPErrorException noPasswordErrorException = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.join(this.nicknameTwo), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' attempted to join password-protected room '" + String.valueOf(mucAddress) + "' without a password."));
            Assertions.assertNotNull((Object)noPasswordErrorException.getStanzaError(), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' attempted to join password-protected room '" + String.valueOf(mucAddress) + "' without a password."));
            Assertions.assertEquals((Object)StanzaError.Condition.not_authorized, (Object)noPasswordErrorException.getStanzaError().getCondition(), (String)("Unexpected condition in the (expected) error that was returned when '" + String.valueOf(this.conTwo.getUser()) + "' attempted to join password-protected room '" + String.valueOf(mucAddress) + "' without a password."));
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.5", quote="If the room requires a password and the user did not supply one (or the password provided is incorrect), the service MUST deny access to the room and inform the user that they are unauthorized; this is done by returning a presence stanza of type \"error\" specifying a <not-authorized/> error.")
    public void mucJoinPasswordProtectedRoomWrongPasswordTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("enterpasswordprotectedroom");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        String correctPassword = StringUtils.insecureRandomString((int)8);
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            MultiUserChatOccupantIntegrationTest.setMucPasswordProtected(mucAsSeenByOne, correctPassword);
            XMPPException.XMPPErrorException wrongPasswordErrorException = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.join(this.nicknameTwo, correctPassword + "_"), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' attempted to join password-protected room '" + String.valueOf(mucAddress) + "' using an incorrect password."));
            Assertions.assertNotNull((Object)wrongPasswordErrorException.getStanzaError(), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' attempted to join password-protected room '" + String.valueOf(mucAddress) + "' using an incorrect password."));
            Assertions.assertEquals((Object)StanzaError.Condition.not_authorized, (Object)wrongPasswordErrorException.getStanzaError().getCondition(), (String)("Unexpected condition in the (expected) error that was returned when '" + String.valueOf(this.conTwo.getUser()) + "' attempted to join password-protected room '" + String.valueOf(mucAddress) + "' using an incorrect password."));
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.5", quote="If the room requires a password and the user did not supply one (or the password provided is incorrect), the service MUST deny access to the room and inform the user that they are unauthorized; this is done by returning a presence stanza of type \"error\" specifying a <not-authorized/> error.")
    public void mucJoinPasswordProtectedRoomCorrectPasswordTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("enterpasswordprotectedroom");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        String correctPassword = StringUtils.insecureRandomString((int)8);
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            MultiUserChatOccupantIntegrationTest.setMucPasswordProtected(mucAsSeenByOne, correctPassword);
            ResultSyncPoint participantTwoSyncPoint = new ResultSyncPoint();
            mucAsSeenByTwo.addParticipantListener(presence -> {
                if (this.nicknameTwo.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantTwoSyncPoint.signal(presence);
                }
            });
            mucAsSeenByTwo.join(this.nicknameTwo, correctPassword);
            Presence presenceCorrectPassword = (Presence)this.assertResult(participantTwoSyncPoint, "Expected '" + String.valueOf(this.conTwo.getUser()) + "' to be able to join password-protected room '" + String.valueOf(mucAddress) + "' using the correct password (but no join-presence was received).");
            Assertions.assertNull((Object)presenceCorrectPassword.getError(), (String)("Unexpected error in join-presence of '" + String.valueOf(this.conTwo.getUser()) + "' after joining password-protected room '" + String.valueOf(mucAddress) + "' using the correct password: " + String.valueOf(presenceCorrectPassword.getError())));
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.6", quote="If the room is members-only but the user is not on the member list, the service MUST deny access to the room and inform the user that they are not allowed to enter the room; this is done by returning a presence stanza of type \"error\" specifying a <registration-required/> error condition.")
    public void mucJoinMembersOnlyRoomTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("entermembersonlyroom");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        try {
            MultiUserChatOccupantIntegrationTest.createMembersOnlyMuc(mucAsSeenByOne, this.nicknameOne);
            XMPPException.XMPPErrorException registrationRequiredErrorException = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.join(this.nicknameTwo), (String)("Expected an error to be returned when non-member '" + String.valueOf(this.conTwo.getUser()) + "' tries to join member-online room '" + String.valueOf(mucAddress) + "' (but an error was not returned)."));
            Assertions.assertNotNull((Object)((Object)registrationRequiredErrorException), (String)("Expected an error to be returned when non-member '" + String.valueOf(this.conTwo.getUser()) + "' tries to join member-online room '" + String.valueOf(mucAddress) + "' (but an error was not returned)."));
            Assertions.assertNotNull((Object)registrationRequiredErrorException.getStanzaError(), (String)("Expected an error to be returned when non-member '" + String.valueOf(this.conTwo.getUser()) + "' tries to join member-online room '" + String.valueOf(mucAddress) + "' (but an error was not returned)."));
            Assertions.assertEquals((Object)StanzaError.Condition.registration_required, (Object)registrationRequiredErrorException.getStanzaError().getCondition(), (String)("Unexpected condition in the (expected) error that was returned when non-member '" + String.valueOf(this.conTwo.getUser()) + "' joined member-online room '" + String.valueOf(mucAddress) + "' (."));
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.7", quote="If the user has been banned from the room (i.e., has an affiliation of \"outcast\"), the service MUST deny access to the room and inform the user of the fact that they are banned; this is done by returning a presence stanza of type \"error\" specifying a <forbidden/> error condition.")
    public void mucBannedUserJoinRoomTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("banneduser");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        try {
            MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
            mucAsSeenByOne.banUser(this.conTwo.getUser().asBareJid(), "Insufficient witchcraft");
            XMPPException.XMPPErrorException forbiddenErrorException = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.join(this.nicknameTwo), (String)("Expected an error to be returned when outcast '" + String.valueOf(this.conTwo.getUser()) + "' tries to join room '" + String.valueOf(mucAddress) + "' (but an error was not returned)."));
            Assertions.assertNotNull((Object)((Object)forbiddenErrorException), (String)("Expected an error to be returned when outcast '" + String.valueOf(this.conTwo.getUser()) + "' tries to join room '" + String.valueOf(mucAddress) + "' (but an error was not returned)."));
            Assertions.assertNotNull((Object)forbiddenErrorException.getStanzaError(), (String)("Expected an error to be returned when outcast '" + String.valueOf(this.conTwo.getUser()) + "' tries to join room '" + String.valueOf(mucAddress) + "' (but an error was not returned)."));
            Assertions.assertEquals((Object)StanzaError.Condition.forbidden, (Object)forbiddenErrorException.getStanzaError().getCondition(), (String)("Unexpected condition in the (expected) error to was returned when outcast '" + String.valueOf(this.conTwo.getUser()) + "' tried to join room '" + String.valueOf(mucAddress) + "'."));
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.8", quote="If the room already contains another user with the nickname desired by the user seeking to enter the room (or if the nickname is reserved by another user on the member list), the service MUST deny access to the room and inform the user of the conflict; this is done by returning a presence stanza of type \"error\" specifying a <conflict/> error condition.")
    public void mucNicknameConflictJoinRoomTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("nicknameclash");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        try {
            MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
            XMPPException.XMPPErrorException conflictErrorException = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.join(this.nicknameOne), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to join room '" + String.valueOf(mucAddress) + "' using the nickname '" + String.valueOf(this.nicknameOne) + "' that was already in used by another occupant of the room (but an error was not returned)."));
            Assertions.assertNotNull((Object)((Object)conflictErrorException), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to join room '" + String.valueOf(mucAddress) + "' using the nickname '" + String.valueOf(this.nicknameOne) + "' that was already in used by another occupant of the room (but an error was not returned)."));
            Assertions.assertNotNull((Object)conflictErrorException.getStanzaError(), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to join room '" + String.valueOf(mucAddress) + "' using the nickname '" + String.valueOf(this.nicknameOne) + "' that was already in used by another occupant of the room (but an error was not returned)."));
            Assertions.assertEquals((Object)StanzaError.Condition.conflict, (Object)conflictErrorException.getStanzaError().getCondition(), (String)("Unexpected condition in the (expected) error that was returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to join room '" + String.valueOf(mucAddress) + "' using the nickname '" + String.valueOf(this.nicknameOne) + "' that was already in used by another occupant of the room."));
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.9", quote="If the room has reached its maximum number of occupants, the service SHOULD deny access to the room and inform the user of the restriction; this is done by returning a presence stanza of type \"error\" specifying a <service-unavailable/> error condition. Alternatively, the room could kick an \"idle user\" in order to free up space (where the definition of \"idle user\" is up to the implementation).")
    public void mucMaxUsersLimitJoinRoomTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("maxusersreached");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            StanzaError.Condition expectedCondition;
            MultiUserChatOccupantIntegrationTest.setMaxUsers(mucAsSeenByOne, 2);
            ResultSyncPoint participantOneSeesTwoSyncPoint = new ResultSyncPoint();
            mucAsSeenByOne.addParticipantListener(presence -> {
                if (this.nicknameTwo.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantOneSeesTwoSyncPoint.signal(presence);
                }
            });
            ResultSyncPoint participantThreeSeesThreeSyncPoint = new ResultSyncPoint();
            mucAsSeenByThree.addParticipantListener(presence -> {
                if (this.nicknameThree.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantThreeSeesThreeSyncPoint.signal(presence);
                }
            });
            mucAsSeenByTwo.join(this.nicknameTwo);
            participantOneSeesTwoSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)2, (int)mucAsSeenByOne.getOccupantsCount(), (String)("Unexpected occupant count as seen by '" + String.valueOf(this.conOne.getUser()) + "' in room '" + String.valueOf(mucAddress) + "' (prior to the join attempt of a third occupant)."));
            XMPPException.XMPPErrorException errorException = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByThree.join(this.nicknameThree));
            switch (this.sinttestConfiguration.compatibilityMode) {
                default: {
                    expectedCondition = StanzaError.Condition.service_unavailable;
                    break;
                }
                case ejabberd: {
                    expectedCondition = StanzaError.Condition.resource_constraint;
                }
            }
            StanzaError stanzaError = errorException.getStanzaError();
            Assertions.assertNotNull((Object)stanzaError);
            Assertions.assertEquals((Object)expectedCondition, (Object)stanzaError.getCondition());
            participantThreeSeesThreeSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)2, (int)mucAsSeenByOne.getOccupantsCount(), (String)("Unexpected occupant count as seen by '" + String.valueOf(this.conOne.getUser()) + "' in room '" + String.valueOf(mucAddress) + "' (after the join attempt of a third occupant)."));
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.9", quote="If the room has reached its maximum number of occupants and a room admin or owner attempts to join, the room MUST allow the admin or owner to join, up to some reasonable number of additional occupants; this helps to prevent denial of service attacks caused by stuffing the room with non-admin users.")
    public void mucMaxUsersLimitAdminCanStillJoinRoomTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("maxusersreached-adminjoin");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            MultiUserChatOccupantIntegrationTest.setMaxUsers(mucAsSeenByOne, 2);
            ResultSyncPoint participantOneSeesTwoSyncPoint = new ResultSyncPoint();
            ResultSyncPoint participantOneSeesThreeSyncPoint = new ResultSyncPoint();
            mucAsSeenByOne.addParticipantListener(presence -> {
                if (this.nicknameTwo.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantOneSeesTwoSyncPoint.signal(presence);
                } else if (this.nicknameThree.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantOneSeesThreeSyncPoint.signal(presence);
                }
            });
            mucAsSeenByTwo.join(this.nicknameTwo);
            participantOneSeesTwoSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)2, (int)mucAsSeenByOne.getOccupantsCount(), (String)("Unexpected occupant count in room '" + String.valueOf(mucAddress) + "' (as observed by '" + String.valueOf(this.conOne.getUser()) + "') (prior to an admin attempting to join a room that was already having its maximum number of occupants)."));
            mucAsSeenByOne.grantAdmin(this.conThree.getUser().asBareJid());
            mucAsSeenByThree.join(this.nicknameThree);
            participantOneSeesThreeSyncPoint.waitForResult(this.timeout);
            Assertions.assertNotNull((Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)this.nicknameThree)), (String)("Expected admin '" + String.valueOf(this.conThree.getUser()) + "' to be in room '" + String.valueOf(mucAddress) + "' (as observed by '" + String.valueOf(this.conOne.getUser()) + "'), but was not."));
            Assertions.assertEquals((int)3, (int)mucAsSeenByOne.getOccupantsCount(), (String)("Unexpected occupant count in room '" + String.valueOf(mucAddress) + "' (as observed by '" + String.valueOf(this.conOne.getUser()) + "') (after an admin joined a room that was already having its maximum number of occupants)"));
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.9", quote="If the room has reached its maximum number of occupants and a room admin or owner attempts to join, the room MUST allow the admin or owner to join, up to some reasonable number of additional occupants; this helps to prevent denial of service attacks caused by stuffing the room with non-admin users.")
    public void mucMaxUsersLimitOwnerCanStillJoinRoomTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("maxusersreached-ownerjoin");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByThree = this.mucManagerThree.getMultiUserChat(mucAddress);
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            MultiUserChatOccupantIntegrationTest.setMaxUsers(mucAsSeenByOne, 2);
            ResultSyncPoint participantOneSeesTwoSyncPoint = new ResultSyncPoint();
            ResultSyncPoint participantOneSeesThreeSyncPoint = new ResultSyncPoint();
            mucAsSeenByOne.addParticipantListener(presence -> {
                if (this.nicknameTwo.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantOneSeesTwoSyncPoint.signal(presence);
                } else if (this.nicknameThree.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantOneSeesThreeSyncPoint.signal(presence);
                }
            });
            mucAsSeenByTwo.join(this.nicknameTwo);
            participantOneSeesTwoSyncPoint.waitForResult(this.timeout);
            Assertions.assertEquals((int)2, (int)mucAsSeenByOne.getOccupantsCount(), (String)("Unexpected occupant count in room '" + String.valueOf(mucAddress) + "' (as observed by '" + String.valueOf(this.conOne.getUser()) + "') (prior to an owner attempting to join a room that was already having its maximum number of occupants)."));
            mucAsSeenByOne.grantOwnership(this.conThree.getUser().asBareJid());
            mucAsSeenByThree.join(this.nicknameThree);
            participantOneSeesThreeSyncPoint.waitForResult(this.timeout);
            Assertions.assertNotNull((Object)mucAsSeenByOne.getOccupant(JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)this.nicknameThree)), (String)("Expected owner '" + String.valueOf(this.conThree.getUser()) + "' to be in room '" + String.valueOf(mucAddress) + "' (as observed by '" + String.valueOf(this.conOne.getUser()) + "'), but was not."));
            Assertions.assertEquals((int)3, (int)mucAsSeenByOne.getOccupantsCount(), (String)("Unexpected occupant count in room '" + String.valueOf(mucAddress) + "' (as observed by '" + String.valueOf(this.conOne.getUser()) + "') (after an owner joined a room that was already having its maximum number of occupants)"));
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.2.10", quote="If a user attempts to enter a room while it is \"locked\" (i.e., before the room creator provides an initial configuration and therefore before the room officially exists), the service MUST refuse entry and return an <item-not-found/> error to the user.")
    public void mucJoinLockedRoomTest() throws Exception {
        if (this.sinttestConfiguration.compatibilityMode == Configuration.CompatibilityMode.ejabberd) {
            throw new TestNotPossibleException("ejabberd does not implement MUC locked rooms as per XEP-0045 \u00a7 7.2.10");
        }
        EntityBareJid mucAddress = this.getRandomRoom("lockedroom");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        mucAsSeenByOne.create(this.nicknameOne);
        try {
            XMPPException.XMPPErrorException conflictErrorException = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.join(this.nicknameTwo), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to join room '" + String.valueOf(mucAddress) + "' that is still being created/is locked (but no error was returned)."));
            Assertions.assertNotNull((Object)((Object)conflictErrorException), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to join room '" + String.valueOf(mucAddress) + "' that is still being created/is locked (but no error was returned)."));
            Assertions.assertNotNull((Object)conflictErrorException.getStanzaError(), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to join room '" + String.valueOf(mucAddress) + "' that is still being created/is locked (but no error was returned)."));
            Assertions.assertEquals((Object)StanzaError.Condition.item_not_found, (Object)conflictErrorException.getStanzaError().getCondition(), (String)("Unexpected condition in the (expected) error that was returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to join room '" + String.valueOf(mucAddress) + "' that is still being created/is locked."));
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    @SmackIntegrationTest(section="7.2.12", quote="If the user is entering a room in which the discussions are logged to a public archive (often accessible via HTTP), the service SHOULD allow the user to enter the room but MUST also warn the user that the discussions are logged. This is done by including a status code of \"170\" in the initial presence that the room sends to the new occupant.")
    public void mucJoinRoomWithPublicLoggingTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("publiclogging");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            mucAsSeenByOne.getConfigFormManager().enablePublicLogging().submitConfigurationForm();
            Presence twoPresence = mucAsSeenByTwo.join(this.nicknameTwo);
            Assertions.assertTrue((boolean)MUCUser.from((Stanza)twoPresence).getStatus().contains(MUCUser.Status.create((Integer)170)), (String)("Expected initial presence reflected to '" + String.valueOf(this.conTwo.getUser()) + "' when joining room '" + String.valueOf(mucAddress) + "' to include the status code '170' (but it did not)."));
        }
        catch (MultiUserChatException.MucConfigurationNotSupportedException e) {
            throw new TestNotPossibleException(e);
        }
        finally {
            mucAsSeenByOne.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.6", quote="A common feature of chat rooms is the ability for an occupant to change his or her nickname within the room. In MUC this is done by sending updated presence information to the room, specifically by sending presence to a new occupant JID in the same room (changing only the resource identifier in the occupant JID). The service then sends two presence stanzas to the full JID of each occupant (including the occupant who is changing his or her room nickname), one of type \"unavailable\" for the old nickname and one indicating availability for the new nickname. The unavailable presence MUST contain the following as extended presence information in an <x/>; element qualified by the 'http://jabber.org/protocol/muc#user' namespace: - The new nickname (in this case, nick='oldhag') - A status code of 303 This enables the recipients to correlate the old roomnick with the new roomnick.\n")
    public void mucChangeNicknameInformationTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("changenickname");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        Resourcepart nicknameTwoOriginal = Resourcepart.from((String)("two-original-" + this.randomString));
        Resourcepart nicknameTwoNew = Resourcepart.from((String)("two-new-" + this.randomString));
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        try {
            SimpleResultSyncPoint participantOneSeesTwoEnter = new SimpleResultSyncPoint();
            mucAsSeenByOne.addParticipantListener(presence -> {
                if (nicknameTwoOriginal.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                    participantOneSeesTwoEnter.signal();
                }
            });
            mucAsSeenByTwo.join(nicknameTwoOriginal);
            participantOneSeesTwoEnter.waitForResult(this.timeout);
            MultiResultSyncPoint participantTwoPresencesSyncPoint = new MultiResultSyncPoint(4);
            PresenceListener mucPresenceListener = presence -> {
                Resourcepart fromResource = presence.getFrom().getResourceOrEmpty();
                if (nicknameTwoOriginal.equals((Object)fromResource) || nicknameTwoNew.equals((Object)fromResource)) {
                    participantTwoPresencesSyncPoint.signal(presence);
                }
            };
            mucAsSeenByOne.addParticipantListener(mucPresenceListener);
            mucAsSeenByTwo.addParticipantListener(mucPresenceListener);
            mucAsSeenByTwo.changeNickname(nicknameTwoNew);
            List partTwoPresencesReceived = participantTwoPresencesSyncPoint.waitForResults(this.timeout);
            List unavailablePresencesReceivedByOne = partTwoPresencesReceived.stream().filter(presence -> !presence.isAvailable()).filter(presence -> presence.getTo().equals((CharSequence)this.conOne.getUser().asEntityFullJidIfPossible())).collect(Collectors.toList());
            List unavailablePresencesReceivedByTwo = partTwoPresencesReceived.stream().filter(presence -> !presence.isAvailable()).filter(presence -> presence.getTo().equals((CharSequence)this.conTwo.getUser().asEntityFullJidIfPossible())).collect(Collectors.toList());
            List availablePresencesReceivedByOne = partTwoPresencesReceived.stream().filter(Presence::isAvailable).filter(presence -> presence.getTo().equals((CharSequence)this.conOne.getUser().asEntityFullJidIfPossible())).collect(Collectors.toList());
            List availablePresencesReceivedByTwo = partTwoPresencesReceived.stream().filter(Presence::isAvailable).filter(presence -> presence.getTo().equals((CharSequence)this.conTwo.getUser().asEntityFullJidIfPossible())).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)unavailablePresencesReceivedByOne.size(), (String)("Expected '" + String.valueOf(this.conOne.getUser()) + "' to have received one 'unavailable' presence when '" + String.valueOf(this.conTwo.getUser()) + "' changed its nickname in room '" + String.valueOf(mucAddress) + "' (but did not)"));
            Assertions.assertEquals((int)1, (int)unavailablePresencesReceivedByTwo.size(), (String)("Expected '" + String.valueOf(this.conTwo.getUser()) + "' to have received one 'unavailable' presence when they changed their nickname in room '" + String.valueOf(mucAddress) + "' (but did not)"));
            Assertions.assertEquals((int)1, (int)availablePresencesReceivedByOne.size(), (String)("Expected '" + String.valueOf(this.conOne.getUser()) + "' to have received one 'available' presence when '" + String.valueOf(this.conTwo.getUser()) + "' changed its nickname in room '" + String.valueOf(mucAddress) + "' (but did not)"));
            Assertions.assertEquals((int)1, (int)availablePresencesReceivedByTwo.size(), (String)("Expected '" + String.valueOf(this.conTwo.getUser()) + "' to have received one 'available' presence when they changed their nickname in room '" + String.valueOf(mucAddress) + "' (but did not)"));
            Assertions.assertTrue((boolean)MUCUser.from((Stanza)((Stanza)unavailablePresencesReceivedByOne.get(0))).getStatus().stream().anyMatch(status -> 303 == status.getCode()), (String)("Expected the 'unavailable' presence of user '" + String.valueOf(this.conTwo.getUser()) + "' reflecting their nickname change in room '" + String.valueOf(mucAddress) + "' as received by '" + String.valueOf(this.conOne.getUser()) + "' to include status code '303' (but it did not)."));
            Assertions.assertEquals((Object)nicknameTwoNew, (Object)MUCUser.from((Stanza)((Stanza)unavailablePresencesReceivedByOne.get(0))).getItem().getNick(), (String)("Expected the 'unavailable' presence of user '" + String.valueOf(this.conTwo.getUser()) + "' reflecting their nickname change in room '" + String.valueOf(mucAddress) + "' as received by '" + String.valueOf(this.conOne.getUser()) + "' to include the new nickname (but it did not)."));
            Assertions.assertTrue((boolean)MUCUser.from((Stanza)((Stanza)unavailablePresencesReceivedByTwo.get(0))).getStatus().stream().anyMatch(status -> 303 == status.getCode()), (String)("Expected the 'unavailable' presence of user '" + String.valueOf(this.conTwo.getUser()) + "' reflecting their nickname change in room '" + String.valueOf(mucAddress) + "' as received by themselves to include status code '303' (but it did not)."));
            Assertions.assertEquals((Object)nicknameTwoNew, (Object)MUCUser.from((Stanza)((Stanza)unavailablePresencesReceivedByTwo.get(0))).getItem().getNick(), (String)("Expected the 'unavailable' presence of user '" + String.valueOf(this.conTwo.getUser()) + "' reflecting their nickname change in room '" + String.valueOf(mucAddress) + "' as received by themselves to include the new nickname (but it did not)."));
            Assertions.assertEquals((Object)nicknameTwoNew, (Object)((Presence)availablePresencesReceivedByOne.get(0)).getFrom().getResourceOrEmpty(), (String)("Expected the 'available' presence of '" + String.valueOf(this.conTwo.getUser()) + "' as received by '" + String.valueOf(this.conOne.getUser()) + "' in room '" + String.valueOf(mucAddress) + "' to be sent 'from' their new nickname (but it was not)."));
            Assertions.assertEquals((Object)nicknameTwoNew, (Object)((Presence)availablePresencesReceivedByTwo.get(0)).getFrom().getResourceOrEmpty(), (String)("Expected the 'available' presence of '" + String.valueOf(this.conTwo.getUser()) + "' as received by themselves in room '" + String.valueOf(mucAddress) + "' to be sent 'from' their new nickname (but it was not)."));
        }
        finally {
            MultiUserChatOccupantIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.6", quote="If the user attempts to change his or her room nickname to a room nickname that is already in use by another user (or that is reserved by another user affiliated with the room, e.g., a member or owner), the service MUST deny the nickname change request and inform the user of the conflict; this is done by returning a presence stanza of type \"error\" specifying a <conflict/> error condition:")
    public void mucBlockChangeNicknameInformationTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("blockchangenickname");
        MultiUserChat mucAsSeenByOne = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTwo = this.mucManagerTwo.getMultiUserChat(mucAddress);
        Resourcepart nicknameTwoOriginal = Resourcepart.from((String)("two-original-" + this.randomString));
        MultiUserChatOccupantIntegrationTest.createMuc(mucAsSeenByOne, this.nicknameOne);
        SimpleResultSyncPoint participantOneSeesTwoEnter = new SimpleResultSyncPoint();
        mucAsSeenByOne.addParticipantListener(presence -> {
            if (nicknameTwoOriginal.equals((Object)presence.getFrom().getResourceOrEmpty())) {
                participantOneSeesTwoEnter.signal();
            }
        });
        mucAsSeenByTwo.join(nicknameTwoOriginal);
        participantOneSeesTwoEnter.waitForResult(this.timeout);
        try {
            XMPPException.XMPPErrorException conflictErrorException = (XMPPException.XMPPErrorException)Assertions.assertThrows(XMPPException.XMPPErrorException.class, () -> mucAsSeenByTwo.changeNickname(this.nicknameOne), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to change their nickname in room '" + String.valueOf(mucAddress) + "' to a nickname that was already in use by another occupant (but no error was returned)."));
            Assertions.assertNotNull((Object)((Object)conflictErrorException), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to change their nickname in room '" + String.valueOf(mucAddress) + "' to a nickname that was already in use by another occupant (but no error was returned)."));
            Assertions.assertNotNull((Object)conflictErrorException.getStanzaError(), (String)("Expected an error to be returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to change their nickname in room '" + String.valueOf(mucAddress) + "' to a nickname that was already in use by another occupant (but no error was returned)."));
            Assertions.assertEquals((Object)StanzaError.Condition.conflict, (Object)conflictErrorException.getStanzaError().getCondition(), (String)("Unexpected conidtion in the (expected) error to was returned when '" + String.valueOf(this.conTwo.getUser()) + "' tried to change their nickname in room '" + String.valueOf(mucAddress) + "' to a nickname that was already in use by another occupant."));
        }
        finally {
            MultiUserChatOccupantIntegrationTest.tryDestroy(mucAsSeenByOne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="7.14", quote="The service MUST then send a presence stanzas of type \"unavailable\" from the departing user's occupant JID to the departing occupant's full JIDs, including a status code of \"110\" to indicate that this notification is \"self-presence\"")
    public void mucLeaveTest() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("leave");
        MultiUserChat muc = this.mucManagerOne.getMultiUserChat(mucAddress);
        try {
            muc.join(Resourcepart.from((String)"nick-one"));
            Presence reflectedLeavePresence = muc.leave();
            MUCUser mucUser = MUCUser.from((Stanza)reflectedLeavePresence);
            Assertions.assertNotNull((Object)mucUser, (String)("Expected the reflected 'leave' presence of '" + String.valueOf(this.conOne.getUser()) + "' that left room '" + String.valueOf(mucAddress) + "' to include a valid 'user' child element (but it did not)."));
            Assertions.assertTrue((boolean)mucUser.getStatus().contains(MUCUser.Status.PRESENCE_TO_SELF_110), (String)("Expected the reflected 'leave' presence of '" + String.valueOf(this.conOne.getUser()) + "' that left room '" + String.valueOf(mucAddress) + "' to include status '" + String.valueOf(MUCUser.Status.PRESENCE_TO_SELF_110) + "' (but it did not)."));
            Assertions.assertEquals((Object)(String.valueOf(mucAddress) + "/nick-one"), (Object)reflectedLeavePresence.getFrom().toString(), (String)("Unexpected 'from' attribute value in the reflected 'leave' presence of '" + String.valueOf(this.conOne.getUser()) + "' that left room '" + String.valueOf(mucAddress) + "'."));
            Assertions.assertEquals((Object)this.conOne.getUser().asEntityFullJidIfPossible().toString(), (Object)reflectedLeavePresence.getTo().toString(), (String)("Unexpected 'to' attribute value in the reflected 'leave' presence of '" + String.valueOf(this.conOne.getUser()) + "' that left room '" + String.valueOf(mucAddress) + "'."));
        }
        finally {
            muc.join(Resourcepart.from((String)"nick-one"));
            MultiUserChatOccupantIntegrationTest.tryDestroy(muc);
        }
    }
}

