/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.muc.AbstractMultiUserChatIntegrationTest;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

@SpecificationReference(document="XEP-0045", version="1.34.6")
public class ParticipantStatusIntegrationTest
extends AbstractMultiUserChatIntegrationTest {
    public ParticipantStatusIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException, MultiUserChatException.MucAlreadyJoinedException, MultiUserChatException.MissingMucCreationAcknowledgeException, XmppStringprepException, MultiUserChatException.NotAMucServiceException {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="9.4", quote="An admin might want to revoke a user's membership [...] The service MUST then send updated presence from this individual to all occupants, indicating the loss of membership by sending a presence element that contains an <x/> element qualified by the 'http://jabber.org/protocol/muc#user' namespace and containing an <item/> child with the 'affiliation' attribute set to a value of \"none\".")
    public void testMembershipRevokedInOpenRoom() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("participantstatus-membership-revoked-open");
        MultiUserChat mucAsSeenByOwner = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTarget = this.mucManagerTwo.getMultiUserChat(mucAddress);
        EntityFullJid mucAddressOwner = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)Resourcepart.from((String)("owner-" + this.randomString)));
        final EntityFullJid mucAddressTarget = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)Resourcepart.from((String)("target-" + this.randomString)));
        ParticipantStatusIntegrationTest.createMuc(mucAsSeenByOwner, mucAddressOwner.getResourcepart());
        try {
            mucAsSeenByOwner.grantMembership(this.conTwo.getUser().asBareJid());
            mucAsSeenByTarget.join(mucAddressTarget.getResourcepart());
            final SimpleResultSyncPoint ownerSeesRevoke = new SimpleResultSyncPoint();
            mucAsSeenByOwner.addParticipantStatusListener(new ParticipantStatusListener(){

                public void membershipRevoked(EntityFullJid participant) {
                    if (mucAddressTarget.equals((CharSequence)participant)) {
                        ownerSeesRevoke.signal();
                    }
                }
            });
            mucAsSeenByOwner.revokeMembership(this.conTwo.getUser().asBareJid());
            this.assertResult(ownerSeesRevoke, "Expected '" + String.valueOf(this.conOne.getUser()) + "' to be notified of the revocation of membership of '" + String.valueOf(this.conTwo.getUser()) + "' (using nickname '" + String.valueOf(mucAddressTarget.getResourcepart()) + "') in '" + String.valueOf(mucAddress) + "' (but did not).");
        }
        finally {
            ParticipantStatusIntegrationTest.tryDestroy(mucAsSeenByOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest(section="9.4", quote="An admin might want to revoke a user's membership [...] If the room is members-only, the service MUST remove the user from the room, including a status code of 321 to indicate that the user was removed because of an affiliation change, and inform all remaining occupants")
    public void testMembershipRevokedInMemberOnlyRoom() throws Exception {
        EntityBareJid mucAddress = this.getRandomRoom("participantstatus-membership-revoked-membersonly");
        MultiUserChat mucAsSeenByOwner = this.mucManagerOne.getMultiUserChat(mucAddress);
        MultiUserChat mucAsSeenByTarget = this.mucManagerTwo.getMultiUserChat(mucAddress);
        EntityFullJid mucAddressOwner = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)Resourcepart.from((String)("owner-" + this.randomString)));
        final EntityFullJid mucAddressTarget = JidCreate.entityFullFrom((EntityBareJid)mucAddress, (Resourcepart)Resourcepart.from((String)("target-" + this.randomString)));
        ParticipantStatusIntegrationTest.createMembersOnlyMuc(mucAsSeenByOwner, mucAddressOwner.getResourcepart());
        try {
            mucAsSeenByOwner.grantMembership(this.conTwo.getUser().asBareJid());
            mucAsSeenByTarget.join(mucAddressTarget.getResourcepart());
            final SimpleResultSyncPoint ownerSeesRevoke = new SimpleResultSyncPoint();
            final SimpleResultSyncPoint ownerSeesDeparture = new SimpleResultSyncPoint();
            mucAsSeenByOwner.addParticipantStatusListener(new ParticipantStatusListener(){

                public void membershipRevoked(EntityFullJid participant) {
                    if (mucAddressTarget.equals((CharSequence)participant)) {
                        ownerSeesRevoke.signal();
                    }
                }

                public void parted(EntityFullJid participant) {
                    if (mucAddressTarget.equals((CharSequence)participant)) {
                        ownerSeesDeparture.signal();
                    }
                }
            });
            mucAsSeenByOwner.revokeMembership(this.conTwo.getUser().asBareJid());
            this.assertResult(ownerSeesRevoke, "Expected '" + String.valueOf(this.conOne.getUser()) + "' to be notified of the revocation of membership of '" + String.valueOf(this.conTwo.getUser()) + "' (using nickname '" + String.valueOf(mucAddressTarget.getResourcepart()) + "') in '" + String.valueOf(mucAddress) + "' (but did not).");
            this.assertResult(ownerSeesDeparture, "Expected '" + String.valueOf(this.conOne.getUser()) + "' to be notified of '" + String.valueOf(this.conTwo.getUser()) + "' (using nickname '" + String.valueOf(mucAddressTarget.getResourcepart()) + "') departing '" + String.valueOf(mucAddress) + "' (but did not).");
        }
        finally {
            ParticipantStatusIntegrationTest.tryDestroy(mucAsSeenByOwner);
        }
    }
}

