/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smackx.omemo.EphemeralTrustCallback;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.trust.OmemoTrustCallback;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.Jid;

public class OmemoManagerSetupHelper {
    public static void trustAllIdentities(OmemoManager alice, OmemoManager bob) throws InterruptedException, SmackException.NotConnectedException, SmackException.NotLoggedInException, SmackException.NoResponseException, CannotEstablishOmemoSessionException, CorruptedOmemoKeyException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException, IOException {
        Roster roster = Roster.getInstanceFor((XMPPConnection)alice.getConnection());
        if (!(alice.getOwnJid() == bob.getOwnJid() || roster.iAmSubscribedTo((Jid)bob.getOwnJid()) && roster.isSubscribedToMyPresence((Jid)bob.getOwnJid()))) {
            throw new IllegalStateException("Before trusting identities of a user, we must be subscribed to one another.");
        }
        alice.requestDeviceListUpdateFor(bob.getOwnJid());
        Map fingerprints = alice.getActiveFingerprints(bob.getOwnJid());
        for (OmemoDevice device : fingerprints.keySet()) {
            OmemoFingerprint fingerprint = (OmemoFingerprint)fingerprints.get(device);
            alice.trustOmemoIdentity(device, fingerprint);
        }
    }

    public static void trustAllIdentitiesWithTests(OmemoManager alice, OmemoManager bob) throws InterruptedException, SmackException.NotConnectedException, SmackException.NotLoggedInException, SmackException.NoResponseException, CannotEstablishOmemoSessionException, CorruptedOmemoKeyException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException, IOException {
        alice.requestDeviceListUpdateFor(bob.getOwnJid());
        Map fps1 = alice.getActiveFingerprints(bob.getOwnJid());
        Assertions.assertFalse((boolean)fps1.isEmpty());
        OmemoManagerSetupHelper.assertAllDevicesAreUndecided(alice, fps1);
        OmemoManagerSetupHelper.assertAllDevicesAreUntrusted(alice, fps1);
        OmemoManagerSetupHelper.trustAllIdentities(alice, bob);
        Map fps2 = alice.getActiveFingerprints(bob.getOwnJid());
        Assertions.assertEquals((int)fps1.size(), (int)fps2.size());
        Assertions.assertTrue((boolean)Maps.difference((Map)fps1, (Map)fps2).areEqual());
        OmemoManagerSetupHelper.assertAllDevicesAreDecided(alice, fps2);
        OmemoManagerSetupHelper.assertAllDevicesAreTrusted(alice, fps2);
    }

    public static OmemoManager prepareOmemoManager(XMPPConnection connection) throws Exception {
        OmemoManager manager = OmemoManager.getInstanceFor((XMPPConnection)connection, (Integer)OmemoManager.randomDeviceId());
        manager.setTrustCallback((OmemoTrustCallback)new EphemeralTrustCallback());
        if (!connection.isAuthenticated()) {
            throw new AssertionError((Object)"Connection must be authenticated.");
        }
        manager.initialize();
        return manager;
    }

    public static void assertAllDevicesAreUndecided(OmemoManager manager, Map<OmemoDevice, OmemoFingerprint> devices) {
        for (OmemoDevice device : devices.keySet()) {
            Assertions.assertFalse((boolean)manager.isDecidedOmemoIdentity(device, devices.get(device)));
        }
    }

    public static void assertAllDevicesAreUntrusted(OmemoManager manager, Map<OmemoDevice, OmemoFingerprint> devices) {
        for (OmemoDevice device : devices.keySet()) {
            Assertions.assertFalse((boolean)manager.isTrustedOmemoIdentity(device, devices.get(device)));
        }
    }

    public static void assertAllDevicesAreDecided(OmemoManager manager, Map<OmemoDevice, OmemoFingerprint> devices) {
        for (OmemoDevice device : devices.keySet()) {
            Assertions.assertTrue((boolean)manager.isDecidedOmemoIdentity(device, devices.get(device)));
        }
    }

    public static void assertAllDevicesAreTrusted(OmemoManager manager, Map<OmemoDevice, OmemoFingerprint> devices) {
        for (OmemoDevice device : devices.keySet()) {
            Assertions.assertTrue((boolean)manager.isTrustedOmemoIdentity(device, devices.get(device)));
        }
    }

    public static void cleanUpPubSub(OmemoManager omemoManager) throws IOException, SmackException.NotConnectedException, InterruptedException {
        List exceptions = omemoManager.purgeEverything();
        Assertions.assertTrue((boolean)exceptions.isEmpty(), (String)("There where exceptions while purging OMEMO: " + String.valueOf(exceptions)));
    }

    public static void cleanUpRoster(OmemoManager omemoManager) {
        Roster roster = Roster.getInstanceFor((XMPPConnection)omemoManager.getConnection());
        for (RosterEntry r : roster.getEntries()) {
            try {
                roster.removeEntry(r);
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | SmackException.NotLoggedInException | XMPPException.XMPPErrorException throwable) {}
        }
    }
}

