/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.IOException;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.annotations.SpecificationReference;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.omemo.AbstractTwoUsersOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoConfiguration;
import org.jivesoftware.smackx.omemo.OmemoMessage;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.ReadOnlyDeviceException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.junit.jupiter.api.Assertions;

@SpecificationReference(document="XEP-0384", version="0.3.0")
public class ReadOnlyDeviceIntegrationTest
extends AbstractTwoUsersOmemoIntegrationTest {
    public ReadOnlyDeviceIntegrationTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, TestNotPossibleException {
        super(environment);
    }

    @SmackIntegrationTest
    public void test() throws InterruptedException, SmackException.NoResponseException, SmackException.NotLoggedInException, SmackException.NotConnectedException, CryptoFailedException, UndecidedOmemoIdentityException, IOException {
        boolean prevIgnoreReadOnlyConf = OmemoConfiguration.getIgnoreReadOnlyDevices();
        int prevMaxMessageCounter = OmemoConfiguration.getMaxReadOnlyMessageCount();
        OmemoConfiguration.setIgnoreReadOnlyDevices((boolean)true);
        OmemoConfiguration.setMaxReadOnlyMessageCount((int)5);
        this.alice.getOmemoService().getOmemoStoreBackend().storeOmemoMessageCounter(this.alice.getOwnDevice(), this.bob.getOwnDevice(), 0);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertEquals((int)i, (int)this.alice.getOmemoService().getOmemoStoreBackend().loadOmemoMessageCounter(this.alice.getOwnDevice(), this.bob.getOwnDevice()));
            OmemoMessage.Sent message = this.alice.encrypt(this.bob.getOwnJid(), "Hello World!");
            Assertions.assertFalse((boolean)message.getSkippedDevices().containsKey(this.bob.getOwnDevice()));
        }
        OmemoMessage.Sent message = this.alice.encrypt(this.bob.getOwnJid(), "Hello World!");
        Throwable exception = (Throwable)message.getSkippedDevices().get(this.bob.getOwnDevice());
        Assertions.assertTrue((boolean)(exception instanceof ReadOnlyDeviceException));
        Assertions.assertEquals((Object)this.bob.getOwnDevice(), (Object)((ReadOnlyDeviceException)exception).getDevice());
        this.alice.getOmemoService().getOmemoStoreBackend().storeOmemoMessageCounter(this.alice.getOwnDevice(), this.bob.getOwnDevice(), 0);
        OmemoConfiguration.setMaxReadOnlyMessageCount((int)prevMaxMessageCounter);
        OmemoConfiguration.setIgnoreReadOnlyDevices((boolean)prevIgnoreReadOnlyConf);
    }
}

