/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.List;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.igniterealtime.smack.inttest.annotations.SmackIntegrationTest;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.search.UserSearchManager;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.jid.DomainBareJid;

public class UserSearchManagerIntegrationTest
extends AbstractSmackIntegrationTest {
    private final DomainBareJid userSearchService;
    private final UserSearchManager searchOne;

    public UserSearchManagerIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
        List searchServices = UserSearchManager.getSearchServices((XMPPConnection)this.conOne);
        if (searchServices.isEmpty()) {
            throw new TestNotPossibleException("No user search services (XEP-0055) found");
        }
        this.userSearchService = (DomainBareJid)searchServices.get(0);
        this.searchOne = UserSearchManager.getInstanceFor((XMPPConnection)this.conOne);
    }

    @SmackIntegrationTest
    public void simple() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Form searchForm = this.searchOne.getSearchForm(this.userSearchService);
        FillableForm fillableForm = searchForm.getFillableForm();
        for (String r : fillableForm.getMissingRequiredFields()) {
            fillableForm.setAnswer(r, (CharSequence)"sinttest");
        }
        ReportedData reportedData = this.searchOne.search(fillableForm, this.userSearchService);
        Assertions.assertNotNull((Object)reportedData);
    }
}

