/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.full;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.util.XmppElementUtil;
import org.junit.jupiter.api.Test;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;

public class ExtensionElementQNameDeclaredTest {
    @Test
    public void qnameOrElementNamespaceDeclaredTest() {
        String[] smackPackages = new String[]{"org.jivesoftware.smack", "org.igniterealtime.smack"};
        Reflections reflections = new Reflections(new Object[]{smackPackages, new SubTypesScanner()});
        Set extensionElementClasses = reflections.getSubTypesOf(ExtensionElement.class);
        HashMap<Class, IllegalArgumentException> exceptions = new HashMap<Class, IllegalArgumentException>();
        for (Class extensionElementClass : extensionElementClasses) {
            if (Modifier.isAbstract(extensionElementClass.getModifiers())) continue;
            try {
                XmppElementUtil.getQNameFor((Class)extensionElementClass);
            }
            catch (IllegalArgumentException e) {
                exceptions.put(extensionElementClass, e);
            }
        }
        Set failedClasses = exceptions.keySet();
        ((IterableAssert)Assertions.assertThat(failedClasses).withFailMessage("The following " + failedClasses.size() + " classes are missing QNAME declaration: " + String.valueOf(failedClasses), new Object[0])).isEmpty();
    }
}

