/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.java7;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.security.util.HostnameChecker;

public class Java7HostnameVerifier
implements HostnameVerifier {
    @Override
    public boolean verify(String hostname, SSLSession session) {
        HostnameChecker checker = HostnameChecker.getInstance((byte)1);
        boolean validCertificate = false;
        boolean validPrincipal = false;
        try {
            Certificate[] peerCertificates = session.getPeerCertificates();
            if (peerCertificates.length > 0 && peerCertificates[0] instanceof X509Certificate) {
                X509Certificate peerCertificate = (X509Certificate)peerCertificates[0];
                try {
                    checker.match(hostname, peerCertificate);
                    validCertificate = true;
                }
                catch (CertificateException certificateException) {}
            }
        }
        catch (SSLPeerUnverifiedException ex) {
            try {
                Principal peerPrincipal = session.getPeerPrincipal();
                if (peerPrincipal instanceof KerberosPrincipal) {
                    validPrincipal = HostnameChecker.match((String)hostname, (Principal)((KerberosPrincipal)peerPrincipal));
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return validCertificate || validPrincipal;
    }
}

