/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.full;

import com.google.common.io.Resources;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.io.DOTImporter;
import org.jgrapht.io.ImportException;
import org.jivesoftware.smack.full.ModularXmppClientToServerConnectionTool;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ModularXmppClientToServerConnectionStateGraphTest {
    @Test
    public void testStateGraphDotOutput() throws IOException, ImportException {
        URL stateGraphDotFileUrl = Resources.getResource((String)"state-graph.dot");
        String expectedStateGraphDot = Resources.toString((URL)stateGraphDotFileUrl, (Charset)StandardCharsets.UTF_8);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ModularXmppClientToServerConnectionTool.printStateGraph((PrintWriter)pw, (boolean)false);
        String currentStateGraphDot = sw.toString();
        DOTImporter dotImporter = new DOTImporter((id, attributes) -> id, (from, to, label, attributes) -> new DefaultEdge(){

            public int hashCode() {
                return HashCode.builder().append(this.getSource()).append(this.getTarget()).build();
            }

            public boolean equals(Object other) {
                return EqualsUtil.equals((Object)((Object)this), (Object)other, (b, o) -> b.append(this.getSource(), o.getSource()).append(this.getTarget(), o.getTarget()));
            }
        });
        DirectedPseudograph currentStateGraph = new DirectedPseudograph(DefaultEdge.class);
        DirectedPseudograph expectedStateGraph = new DirectedPseudograph(DefaultEdge.class);
        dotImporter.importGraph((Graph)expectedStateGraph, (Reader)new StringReader(expectedStateGraphDot));
        dotImporter.importGraph((Graph)currentStateGraph, (Reader)new StringReader(currentStateGraphDot));
        Assertions.assertEquals((Object)expectedStateGraph, (Object)currentStateGraph);
    }
}

