/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.full;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.debugger.ConsoleDebugger;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.websocket.XmppWebSocketTransportModuleDescriptor;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jxmpp.util.XmppDateTime;

public class WebSocketConnectionTest {
    public static void main(String[] args) throws URISyntaxException, SmackException, IOException, XMPPException, InterruptedException {
        String messageTo = null;
        if (args.length < 3 || args.length > 4) {
            throw new IllegalArgumentException();
        }
        String jid = args[0];
        String password = args[1];
        String websocketEndpoint = args[2];
        if (args.length >= 4) {
            messageTo = args[3];
        }
        WebSocketConnectionTest.testWebSocketConnection(jid, password, websocketEndpoint, messageTo);
    }

    public static void testWebSocketConnection(String jid, String password, String websocketEndpoint) throws URISyntaxException, SmackException, IOException, XMPPException, InterruptedException {
        WebSocketConnectionTest.testWebSocketConnection(jid, password, websocketEndpoint, null);
    }

    public static void testWebSocketConnection(String jid, String password, String websocketEndpoint, String messageTo) throws URISyntaxException, SmackException, IOException, XMPPException, InterruptedException {
        ModularXmppClientToServerConnectionConfiguration.Builder builder = ModularXmppClientToServerConnectionConfiguration.builder();
        ((ModularXmppClientToServerConnectionConfiguration.Builder)builder.removeAllModules().setXmppAddressAndPassword((CharSequence)jid, password)).setDebuggerFactory(ConsoleDebugger.Factory.INSTANCE);
        XmppWebSocketTransportModuleDescriptor.Builder websocketBuilder = XmppWebSocketTransportModuleDescriptor.getBuilder((ModularXmppClientToServerConnectionConfiguration.Builder)builder);
        websocketBuilder.explicitlySetWebSocketEndpointAndDiscovery((CharSequence)websocketEndpoint, false);
        builder.addModule(websocketBuilder.build());
        ModularXmppClientToServerConnectionConfiguration config = builder.build();
        ModularXmppClientToServerConnection connection = new ModularXmppClientToServerConnection(config);
        connection.setReplyTimeout(300000L);
        connection.addConnectionStateMachineListener((event, c) -> Logger.getAnonymousLogger().info("Connection event: " + event));
        connection.connect();
        connection.login();
        if (messageTo != null) {
            Message message = ((MessageBuilder)connection.getStanzaFactory().buildMessageStanza().to((CharSequence)messageTo)).setBody("It is alive! " + XmppDateTime.formatXEP0082Date((Date)new Date())).build();
            connection.sendStanza((Stanza)message);
        }
        Thread.sleep(1000L);
        connection.disconnect();
        ModularXmppClientToServerConnection.Stats connectionStats = connection.getStats();
        ServiceDiscoveryManager.Stats serviceDiscoveryManagerStats = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).getStats();
        System.out.println("WebSocket successfully finished, yeah!\n" + connectionStats + '\n' + serviceDiscoveryManagerStats);
    }

    static {
        SmackConfiguration.DEBUG = true;
    }
}

