/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.packet.JingleContentDescription;
import org.xmlpull.v1.XmlPullParser;

public abstract class JingleContentDescriptionProvider
implements PacketExtensionProvider {
    protected JingleContentDescription.JinglePayloadType parsePayload(XmlPullParser parser) throws Exception {
        int ptId = 0;
        int ptChannels = 0;
        try {
            ptId = Integer.parseInt(parser.getAttributeValue("", "id"));
        }
        catch (Exception e) {
            // empty catch block
        }
        String ptName = parser.getAttributeValue("", "name");
        try {
            ptChannels = Integer.parseInt(parser.getAttributeValue("", "channels"));
        }
        catch (Exception e) {
            // empty catch block
        }
        return new JingleContentDescription.JinglePayloadType(new PayloadType(ptId, ptName, ptChannels));
    }

    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        boolean done = false;
        JingleContentDescription desc = this.getInstance();
        while (!done) {
            int eventType = parser.next();
            String name = parser.getName();
            if (eventType == 2) {
                if (name.equals("payload-type")) {
                    desc.addJinglePayloadType(this.parsePayload(parser));
                    continue;
                }
                throw new Exception("Unknow element \"" + name + "\" in content.");
            }
            if (eventType != 3 || !name.equals("description")) continue;
            done = true;
        }
        return desc;
    }

    protected abstract JingleContentDescription getInstance();

    public static class Audio
    extends JingleContentDescriptionProvider {
        @Override
        public JingleContentDescription.JinglePayloadType parsePayload(XmlPullParser parser) throws Exception {
            JingleContentDescription.JinglePayloadType pte = super.parsePayload(parser);
            PayloadType.Audio pt = new PayloadType.Audio(pte.getPayloadType());
            int ptClockRate = 0;
            try {
                ptClockRate = Integer.parseInt(parser.getAttributeValue("", "clockrate"));
            }
            catch (Exception e) {
                // empty catch block
            }
            pt.setClockRate(ptClockRate);
            return new JingleContentDescription.JinglePayloadType.Audio(pt);
        }

        @Override
        protected JingleContentDescription getInstance() {
            return new JingleContentDescription.Audio();
        }
    }
}

