/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.packet;

import java.util.Locale;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.jingleold.media.ContentInfo;
import org.jivesoftware.smackx.jingleold.packet.JingleContentInfo;
import org.xmlpull.v1.XmlPullParser;

public class JingleError
implements PacketExtension {
    public static String NAMESPACE = "urn:xmpp:tmp:jingle:errors";
    public static final JingleError OUT_OF_ORDER = new JingleError("out-of-order");
    public static final JingleError UNKNOWN_SESSION = new JingleError("unknown-session");
    public static final JingleError UNSUPPORTED_CONTENT = new JingleError("unsupported-content");
    public static final JingleError UNSUPPORTED_TRANSPORTS = new JingleError("unsupported-transports");
    public static final JingleError NO_COMMON_PAYLOAD = new JingleError("unsupported-codecs");
    public static final JingleError NEGOTIATION_ERROR = new JingleError("negotiation-error");
    public static final JingleError MALFORMED_STANZA = new JingleError("malformed-stanza");
    private String message;

    public JingleError(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        if (this.message != null) {
            buf.append("<error type=\"cancel\">");
            buf.append("<").append(this.message).append(" xmlns=\"").append(NAMESPACE).append("\"/>");
            buf.append("</error>");
        }
        return buf.toString();
    }

    public static JingleError fromString(String value) {
        if (value != null) {
            if ((value = value.toLowerCase(Locale.US)).equals("out-of-order")) {
                return OUT_OF_ORDER;
            }
            if (value.equals("unknown-session")) {
                return UNKNOWN_SESSION;
            }
            if (value.equals("unsupported-content")) {
                return UNSUPPORTED_CONTENT;
            }
            if (value.equals("unsupported-transports")) {
                return UNSUPPORTED_TRANSPORTS;
            }
            if (value.equals("unsupported-codecs")) {
                return NO_COMMON_PAYLOAD;
            }
            if (value.equals("negotiation-error")) {
                return NEGOTIATION_ERROR;
            }
            if (value.equals("malformed-stanza")) {
                return MALFORMED_STANZA;
            }
        }
        return null;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getElementName() {
        return this.message;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public static class Provider
    implements PacketExtensionProvider {
        private PacketExtension audioInfo;

        public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
            PacketExtension result = null;
            if (this.audioInfo != null) {
                result = this.audioInfo;
            } else {
                String elementName = parser.getName();
                ContentInfo mi = ContentInfo.Audio.fromString(elementName);
                if (mi != null) {
                    result = new JingleContentInfo.Audio(mi);
                }
            }
            return result;
        }
    }
}

