/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.packet.JingleDescription;
import org.xmlpull.v1.XmlPullParser;

public abstract class JingleDescriptionProvider
implements PacketExtensionProvider {
    protected PayloadType parsePayload(XmlPullParser parser) throws Exception {
        int ptId = 0;
        int ptChannels = 0;
        try {
            ptId = Integer.parseInt(parser.getAttributeValue("", "id"));
        }
        catch (Exception e) {
            // empty catch block
        }
        String ptName = parser.getAttributeValue("", "name");
        try {
            ptChannels = Integer.parseInt(parser.getAttributeValue("", "channels"));
        }
        catch (Exception e) {
            // empty catch block
        }
        return new PayloadType(ptId, ptName, ptChannels);
    }

    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        boolean done = false;
        JingleDescription desc = this.getInstance();
        while (!done) {
            int eventType = parser.next();
            String name = parser.getName();
            if (eventType == 2) {
                if (name.equals("payload-type")) {
                    desc.addPayloadType(this.parsePayload(parser));
                    continue;
                }
                throw new Exception("Unknow element \"" + name + "\" in content.");
            }
            if (eventType != 3 || !name.equals("description")) continue;
            done = true;
        }
        return desc;
    }

    protected abstract JingleDescription getInstance();

    public static class Audio
    extends JingleDescriptionProvider {
        @Override
        public PayloadType parsePayload(XmlPullParser parser) throws Exception {
            PayloadType pte = super.parsePayload(parser);
            PayloadType.Audio pt = new PayloadType.Audio(pte);
            int ptClockRate = 0;
            try {
                ptClockRate = Integer.parseInt(parser.getAttributeValue("", "clockrate"));
            }
            catch (Exception e) {
                // empty catch block
            }
            pt.setClockRate(ptClockRate);
            return pt;
        }

        @Override
        protected JingleDescription getInstance() {
            return new JingleDescription.Audio();
        }
    }
}

