/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.nat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class STUN
extends IQ {
    private static final Logger LOGGER = Logger.getLogger(STUN.class.getName());
    private List<StunServerAddress> servers = new ArrayList<StunServerAddress>();
    private String publicIp = null;
    public static final String DOMAIN = "stun";
    public static final String ELEMENT_NAME = "query";
    public static final String NAMESPACE = "google:jingleinfo";

    public List<StunServerAddress> getServers() {
        return this.servers;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    private void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public String getChildElementXML() {
        StringBuilder str = new StringBuilder();
        str.append("<query xmlns='google:jingleinfo'/>");
        return str.toString();
    }

    public static STUN getSTUNServer(XMPPConnection connection) throws SmackException.NotConnectedException {
        if (!connection.isConnected()) {
            return null;
        }
        STUN stunPacket = new STUN();
        stunPacket.setTo("stun." + connection.getServiceName());
        PacketCollector collector = connection.createPacketCollectorAndSend((IQ)stunPacket);
        STUN response = (STUN)collector.nextResult();
        collector.cancel();
        return response;
    }

    public static boolean serviceAvailable(XMPPConnection connection) throws XMPPException, SmackException {
        if (!connection.isConnected()) {
            return false;
        }
        LOGGER.fine("Service listing");
        ServiceDiscoveryManager disco = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        DiscoverItems items = disco.discoverItems(connection.getServiceName());
        for (DiscoverItems.Item item : items.getItems()) {
            DiscoverInfo info = disco.discoverInfo(item.getEntityID());
            for (DiscoverInfo.Identity identity : info.getIdentities()) {
                if (!identity.getCategory().equals("proxy") || !identity.getType().equals(DOMAIN) || !info.containsFeature(NAMESPACE)) continue;
                return true;
            }
            LOGGER.fine(item.getName() + "-" + info.getType());
        }
        return false;
    }

    static {
        ProviderManager.addIQProvider((String)ELEMENT_NAME, (String)NAMESPACE, (Object)((Object)new Provider()));
    }

    public static class StunServerAddress {
        private String server;
        private String port;

        public StunServerAddress(String server, String port) {
            this.server = server;
            this.port = port;
        }

        public String getServer() {
            return this.server;
        }

        public String getPort() {
            return this.port;
        }
    }

    public static class Provider
    extends IQProvider<STUN> {
        public STUN parse(XmlPullParser parser, int initialDepth) throws SmackException, XmlPullParserException, IOException {
            boolean done = false;
            if (!parser.getNamespace().equals(STUN.NAMESPACE)) {
                throw new SmackException("Not a STUN packet");
            }
            STUN iq = new STUN();
            while (!done) {
                int eventType = parser.next();
                String elementName = parser.getName();
                if (eventType == 2) {
                    String host;
                    if (elementName.equals("server")) {
                        host = null;
                        String port = null;
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            if (parser.getAttributeName(i).equals("host")) {
                                host = parser.getAttributeValue(i);
                                continue;
                            }
                            if (!parser.getAttributeName(i).equals("udp")) continue;
                            port = parser.getAttributeValue(i);
                        }
                        if (host == null || port == null) continue;
                        iq.servers.add(new StunServerAddress(host, port));
                        continue;
                    }
                    if (!elementName.equals("publicip")) continue;
                    host = null;
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (!parser.getAttributeName(i).equals("ip")) continue;
                        host = parser.getAttributeValue(i);
                    }
                    if (host == null || host.equals("")) continue;
                    iq.setPublicIp(host);
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals(STUN.ELEMENT_NAME)) continue;
                done = true;
            }
            return iq;
        }
    }
}

