/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.mediaimpl.jspeex;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.media.JingleMediaManager;
import org.jivesoftware.smackx.jingleold.media.JingleMediaSession;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.mediaimpl.JMFInit;
import org.jivesoftware.smackx.jingleold.mediaimpl.jspeex.AudioMediaSession;
import org.jivesoftware.smackx.jingleold.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;

public class SpeexMediaManager
extends JingleMediaManager {
    private static final Logger LOGGER = Logger.getLogger(SpeexMediaManager.class.getName());
    public static final String MEDIA_NAME = "Speex";
    private List<PayloadType> payloads = new ArrayList<PayloadType>();

    public SpeexMediaManager(JingleTransportManager transportManager) {
        super(transportManager);
        this.setupPayloads();
        SpeexMediaManager.setupJMF();
    }

    @Override
    public JingleMediaSession createMediaSession(PayloadType payloadType, TransportCandidate remote, TransportCandidate local, JingleSession jingleSession) {
        return new AudioMediaSession(payloadType, remote, local, null, null);
    }

    private void setupPayloads() {
        this.payloads.add(new PayloadType.Audio(15, "speex"));
    }

    @Override
    public List<PayloadType> getPayloads() {
        return this.payloads;
    }

    public static void setupJMF() {
        File jmfProperties;
        String homeDir = System.getProperty("user.home");
        File jmfDir = new File(homeDir, ".jmf");
        String classpath = System.getProperty("java.class.path");
        classpath = classpath + System.getProperty("path.separator") + jmfDir.getAbsolutePath();
        System.setProperty("java.class.path", classpath);
        if (!jmfDir.exists()) {
            jmfDir.mkdir();
        }
        if (!(jmfProperties = new File(jmfDir, "jmf.properties")).exists()) {
            try {
                jmfProperties.createNewFile();
            }
            catch (IOException ex) {
                LOGGER.fine("Failed to create jmf.properties");
                ex.printStackTrace();
            }
        }
        SpeexMediaManager.runLinuxPreInstall();
        if (jmfProperties.length() == 0L) {
            new JMFInit(null, false);
        }
    }

    private static void runLinuxPreInstall() {
    }

    @Override
    public String getName() {
        return MEDIA_NAME;
    }
}

