/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.media;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingleold.ContentNegotiator;
import org.jivesoftware.smackx.jingleold.JingleActionEnum;
import org.jivesoftware.smackx.jingleold.JingleException;
import org.jivesoftware.smackx.jingleold.JingleNegotiator;
import org.jivesoftware.smackx.jingleold.JingleNegotiatorState;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.listeners.JingleListener;
import org.jivesoftware.smackx.jingleold.listeners.JingleMediaListener;
import org.jivesoftware.smackx.jingleold.media.JingleMediaManager;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.packet.Jingle;
import org.jivesoftware.smackx.jingleold.packet.JingleContent;
import org.jivesoftware.smackx.jingleold.packet.JingleDescription;
import org.jivesoftware.smackx.jingleold.packet.JingleError;

public class MediaNegotiator
extends JingleNegotiator {
    private static final Logger LOGGER = Logger.getLogger(MediaNegotiator.class.getName());
    private final JingleMediaManager mediaManager;
    private final List<PayloadType> localAudioPts = new ArrayList<PayloadType>();
    private final List<PayloadType> remoteAudioPts = new ArrayList<PayloadType>();
    private PayloadType bestCommonAudioPt;
    private ContentNegotiator parentNegotiator;

    public MediaNegotiator(JingleSession session, JingleMediaManager mediaManager, List<PayloadType> pts, ContentNegotiator parentNegotiator) {
        super(session);
        this.mediaManager = mediaManager;
        this.parentNegotiator = parentNegotiator;
        this.bestCommonAudioPt = null;
        if (pts != null && pts.size() > 0) {
            this.localAudioPts.addAll(pts);
        }
    }

    public JingleMediaManager getMediaManager() {
        return this.mediaManager;
    }

    @Override
    public List<IQ> dispatchIncomingPacket(IQ iq, String id) throws XMPPException, SmackException.NotConnectedException {
        ArrayList<IQ> responses = new ArrayList<IQ>();
        IQ response = null;
        if (iq.getType().equals((Object)IQ.Type.error)) {
            this.setNegotiatorState(JingleNegotiatorState.FAILED);
            this.triggerMediaClosed(this.getBestCommonAudioPt());
            throw new JingleException(iq.getError().getDescriptiveText());
        }
        if (iq.getType().equals((Object)IQ.Type.result)) {
            if (this.isExpectedId(iq.getPacketID())) {
                this.receiveResult(iq);
                this.removeExpectedId(iq.getPacketID());
            }
        } else if (iq instanceof Jingle) {
            Jingle jingle = (Jingle)iq;
            JingleActionEnum action = jingle.getAction();
            for (JingleContent jingleContent : jingle.getContentsList()) {
                JingleDescription description;
                if (!jingleContent.getName().equals(this.parentNegotiator.getName()) || (description = jingleContent.getDescription()) == null) continue;
                switch (action) {
                    case CONTENT_ACCEPT: {
                        response = this.receiveContentAcceptAction(jingle, description);
                        break;
                    }
                    case CONTENT_MODIFY: {
                        break;
                    }
                    case CONTENT_REMOVE: {
                        break;
                    }
                    case SESSION_INFO: {
                        response = this.receiveSessionInfoAction(jingle, description);
                        break;
                    }
                    case SESSION_INITIATE: {
                        response = this.receiveSessionInitiateAction(jingle, description);
                        break;
                    }
                    case SESSION_ACCEPT: {
                        response = this.receiveSessionAcceptAction(jingle, description);
                        break;
                    }
                }
            }
        }
        if (response != null) {
            this.addExpectedId(response.getPacketID());
            responses.add(response);
        }
        return responses;
    }

    private Jingle receiveResult(IQ iq) throws XMPPException {
        Jingle response = null;
        return response;
    }

    private IQ receiveContentAcceptAction(Jingle jingle, JingleDescription description) throws XMPPException, SmackException.NotConnectedException {
        IQ response = null;
        ArrayList<PayloadType> offeredPayloads = new ArrayList();
        offeredPayloads = description.getAudioPayloadTypesList();
        this.bestCommonAudioPt = this.calculateBestCommonAudioPt(offeredPayloads);
        if (this.bestCommonAudioPt == null) {
            this.setNegotiatorState(JingleNegotiatorState.FAILED);
            response = this.session.createJingleError(jingle, JingleError.NEGOTIATION_ERROR);
        } else {
            this.setNegotiatorState(JingleNegotiatorState.SUCCEEDED);
            this.triggerMediaEstablished(this.getBestCommonAudioPt());
            LOGGER.severe("Media choice:" + this.getBestCommonAudioPt().getName());
            response = this.session.createAck(jingle);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQ receiveSessionInitiateAction(Jingle jingle, JingleDescription description) {
        IQ response = null;
        ArrayList<PayloadType> offeredPayloads = new ArrayList();
        offeredPayloads = description.getAudioPayloadTypesList();
        this.bestCommonAudioPt = this.calculateBestCommonAudioPt(offeredPayloads);
        List<PayloadType> list = this.remoteAudioPts;
        synchronized (list) {
            this.remoteAudioPts.addAll(offeredPayloads);
        }
        if (this.bestCommonAudioPt != null) {
            this.setNegotiatorState(JingleNegotiatorState.PENDING);
        } else {
            this.setNegotiatorState(JingleNegotiatorState.FAILED);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IQ receiveSessionInfoAction(Jingle jingle, JingleDescription description) throws JingleException {
        IQ response = null;
        PayloadType oldBestCommonAudioPt = this.bestCommonAudioPt;
        boolean ptChange = false;
        List<PayloadType> offeredPayloads = description.getAudioPayloadTypesList();
        if (!offeredPayloads.isEmpty()) {
            List<PayloadType> list = this.remoteAudioPts;
            synchronized (list) {
                this.remoteAudioPts.clear();
                this.remoteAudioPts.addAll(offeredPayloads);
            }
            this.bestCommonAudioPt = this.calculateBestCommonAudioPt(this.remoteAudioPts);
            if (this.bestCommonAudioPt != null) {
                boolean bl = ptChange = !this.bestCommonAudioPt.equals(oldBestCommonAudioPt);
                if (oldBestCommonAudioPt != null && ptChange) {
                    // empty if block
                }
            } else {
                throw new JingleException(JingleError.NO_COMMON_PAYLOAD);
            }
        }
        return response;
    }

    private IQ receiveSessionAcceptAction(Jingle jingle, JingleDescription description) throws JingleException {
        IQ response = null;
        List<Object> offeredPayloads = new ArrayList();
        if (this.bestCommonAudioPt == null) {
            this.bestCommonAudioPt = this.calculateBestCommonAudioPt(this.remoteAudioPts);
        }
        if (!(offeredPayloads = description.getAudioPayloadTypesList()).isEmpty()) {
            if (offeredPayloads.size() == 1) {
                PayloadType.Audio agreedCommonAudioPt = (PayloadType.Audio)offeredPayloads.get(0);
                if (this.bestCommonAudioPt != null && !agreedCommonAudioPt.equals(this.bestCommonAudioPt)) {
                    throw new JingleException(JingleError.NEGOTIATION_ERROR);
                }
            } else if (offeredPayloads.size() > 1) {
                throw new JingleException(JingleError.MALFORMED_STANZA);
            }
        }
        return response;
    }

    public boolean isEstablished() {
        return this.getBestCommonAudioPt() != null;
    }

    public boolean isFullyEstablished() {
        return this.isEstablished() && (this.getNegotiatorState() == JingleNegotiatorState.SUCCEEDED || this.getNegotiatorState() == JingleNegotiatorState.FAILED);
    }

    private PayloadType calculateBestCommonAudioPt(List<PayloadType> remoteAudioPts) {
        ArrayList<PayloadType> commonAudioPtsHere = new ArrayList<PayloadType>();
        ArrayList<PayloadType> commonAudioPtsThere = new ArrayList<PayloadType>();
        PayloadType.Audio result = null;
        if (!remoteAudioPts.isEmpty()) {
            commonAudioPtsHere.addAll(this.localAudioPts);
            commonAudioPtsHere.retainAll(remoteAudioPts);
            commonAudioPtsThere.addAll(remoteAudioPts);
            commonAudioPtsThere.retainAll(this.localAudioPts);
            if (!commonAudioPtsHere.isEmpty() && !commonAudioPtsThere.isEmpty()) {
                if (this.session.getInitiator().equals(this.session.getConnection().getUser())) {
                    PayloadType.Audio bestPtHere = null;
                    PayloadType payload = this.mediaManager.getPreferredPayloadType();
                    if (payload != null && payload instanceof PayloadType.Audio && commonAudioPtsHere.contains(payload)) {
                        bestPtHere = (PayloadType.Audio)payload;
                    }
                    if (bestPtHere == null) {
                        for (PayloadType payloadType : commonAudioPtsHere) {
                            if (!(payloadType instanceof PayloadType.Audio)) continue;
                            bestPtHere = (PayloadType.Audio)payloadType;
                            break;
                        }
                    }
                    result = bestPtHere;
                } else {
                    PayloadType.Audio bestPtThere = null;
                    for (PayloadType payloadType : commonAudioPtsThere) {
                        if (!(payloadType instanceof PayloadType.Audio)) continue;
                        bestPtThere = (PayloadType.Audio)payloadType;
                        break;
                    }
                    result = bestPtThere;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteAudioPayloadType(PayloadType.Audio pt) {
        if (pt != null) {
            List<PayloadType> list = this.remoteAudioPts;
            synchronized (list) {
                this.remoteAudioPts.add(pt);
            }
        }
    }

    public PayloadType getBestCommonAudioPt() {
        return this.bestCommonAudioPt;
    }

    protected void triggerMediaEstablished(PayloadType bestPt) throws SmackException.NotConnectedException {
        List<JingleListener> listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleMediaListener)) continue;
            JingleMediaListener mli = (JingleMediaListener)li;
            mli.mediaEstablished(bestPt);
        }
    }

    protected void triggerMediaClosed(PayloadType currPt) {
        List<JingleListener> listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleMediaListener)) continue;
            JingleMediaListener mli = (JingleMediaListener)li;
            mli.mediaClosed(currPt);
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    public void close() {
        super.close();
        this.triggerMediaClosed(this.getBestCommonAudioPt());
    }

    public JingleDescription getJingleDescription() {
        JingleDescription.Audio result = null;
        PayloadType payloadType = this.getBestCommonAudioPt();
        if (payloadType != null) {
            result = new JingleDescription.Audio(payloadType);
        } else {
            result = new JingleDescription.Audio();
            result.addAudioPayloadTypes(this.localAudioPts);
        }
        return result;
    }
}

