/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.mediaimpl.sshare.api;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.jivesoftware.smackx.jingleold.mediaimpl.sshare.api.DefaultDecoder;
import org.jivesoftware.smackx.jingleold.mediaimpl.sshare.api.ImageDecoder;

public class ImageReceiver
extends Canvas {
    private static final long serialVersionUID = -7000112305305269025L;
    private boolean on = true;
    private DatagramSocket socket;
    private BufferedImage[][] tiles;
    private static final int tileWidth = 25;
    private InetAddress localHost;
    private InetAddress remoteHost;
    private int localPort;
    private int remotePort;
    private ImageDecoder decoder;

    public ImageReceiver(final InetAddress remoteHost, final int remotePort, int localPort, int width, int height) {
        this.tiles = new BufferedImage[width][height];
        try {
            this.socket = new DatagramSocket(localPort);
            this.localHost = this.socket.getLocalAddress();
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.localPort = localPort;
            this.decoder = new DefaultDecoder();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    byte[] buf = new byte[1024];
                    DatagramPacket p = new DatagramPacket(buf, 1024);
                    try {
                        while (ImageReceiver.this.on) {
                            ImageReceiver.this.socket.receive(p);
                            int length = p.getLength();
                            BufferedImage bufferedImage = ImageReceiver.this.decoder.decode(new ByteArrayInputStream(p.getData(), 0, length - 2));
                            if (bufferedImage == null) continue;
                            byte x = p.getData()[length - 2];
                            byte y = p.getData()[length - 1];
                            ImageReceiver.this.drawTile(x, y, bufferedImage);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    byte[] buf = new byte[1024];
                    DatagramPacket p = new DatagramPacket(buf, 1024);
                    try {
                        while (ImageReceiver.this.on) {
                            p.setAddress(remoteHost);
                            p.setPort(remotePort);
                            ImageReceiver.this.socket.send(p);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        this.setSize(width, height);
    }

    public InetAddress getLocalHost() {
        return this.localHost;
    }

    public InetAddress getRemoteHost() {
        return this.remoteHost;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public DatagramSocket getDatagramSocket() {
        return this.socket;
    }

    public void drawTile(int x, int y, BufferedImage bufferedImage) {
        this.tiles[x][y] = bufferedImage;
        this.getGraphics().drawImage(bufferedImage, 25 * x, 25 * y, this);
    }

    @Override
    public void paint(Graphics g) {
        for (int i = 0; i < this.tiles.length; ++i) {
            for (int j = 0; j < this.tiles[0].length; ++j) {
                g.drawImage(this.tiles[i][j], 25 * i, 25 * j, this);
            }
        }
    }

    public ImageDecoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(ImageDecoder decoder) {
        this.decoder = decoder;
    }

    public void stop() {
        this.on = false;
        this.socket.close();
    }
}

