/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.jingleold.nat.ICECandidate;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;
import org.jivesoftware.smackx.jingleold.packet.JingleTransport;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class JingleTransportProvider
extends PacketExtensionProvider<JingleTransport> {
    protected JingleTransport getInstance() {
        return new JingleTransport();
    }

    public JingleTransport parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        boolean done = false;
        JingleTransport trans = this.getInstance();
        while (!done) {
            int eventType = parser.next();
            String name = parser.getName();
            if (eventType == 2) {
                if (name.equals("candidate")) {
                    JingleTransport.JingleTransportCandidate jtc = this.parseCandidate(parser);
                    if (jtc == null) continue;
                    trans.addCandidate(jtc);
                    continue;
                }
                throw new SmackException("Unknown tag \"" + name + "\" in transport element.");
            }
            if (eventType != 3 || !name.equals("transport")) continue;
            done = true;
        }
        return trans;
    }

    protected abstract JingleTransport.JingleTransportCandidate parseCandidate(XmlPullParser var1);

    public static class RawUdp
    extends JingleTransportProvider {
        @Override
        protected JingleTransport getInstance() {
            return new JingleTransport.RawUdp();
        }

        @Override
        protected JingleTransport.JingleTransportCandidate parseCandidate(XmlPullParser parser) {
            TransportCandidate.Fixed mt = new TransportCandidate.Fixed();
            String generation = parser.getAttributeValue("", "generation");
            String ip = parser.getAttributeValue("", "ip");
            String name = parser.getAttributeValue("", "name");
            String port = parser.getAttributeValue("", "port");
            if (generation != null) {
                try {
                    mt.setGeneration(Integer.parseInt(generation));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (ip != null) {
                mt.setIp(ip);
            }
            if (name != null) {
                mt.setName(name);
            }
            if (port != null) {
                try {
                    mt.setPort(Integer.parseInt(port));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return new JingleTransport.RawUdp.Candidate(mt);
        }
    }

    public static class Ice
    extends JingleTransportProvider {
        @Override
        protected JingleTransport getInstance() {
            return new JingleTransport.Ice();
        }

        @Override
        protected JingleTransport.JingleTransportCandidate parseCandidate(XmlPullParser parser) {
            ICECandidate mt = new ICECandidate();
            String channel = parser.getAttributeValue("", "channel");
            String generation = parser.getAttributeValue("", "generation");
            String ip = parser.getAttributeValue("", "ip");
            String name = parser.getAttributeValue("", "name");
            String network = parser.getAttributeValue("", "network");
            String username = parser.getAttributeValue("", "username");
            String password = parser.getAttributeValue("", "password");
            String port = parser.getAttributeValue("", "port");
            String preference = parser.getAttributeValue("", "preference");
            String proto = parser.getAttributeValue("", "proto");
            String type = parser.getAttributeValue("", "type");
            if (channel != null) {
                mt.setChannel(new TransportCandidate.Channel(channel));
            }
            if (generation != null) {
                try {
                    mt.setGeneration(Integer.parseInt(generation));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (ip == null) {
                return null;
            }
            mt.setIp(ip);
            if (name != null) {
                mt.setName(name);
            }
            if (network != null) {
                try {
                    mt.setNetwork(Integer.parseInt(network));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (username != null) {
                mt.setUsername(username);
            }
            if (password != null) {
                mt.setPassword(password);
            }
            if (port != null) {
                try {
                    mt.setPort(Integer.parseInt(port));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (preference != null) {
                try {
                    mt.setPreference(Integer.parseInt(preference));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (proto != null) {
                mt.setProto(new TransportCandidate.Protocol(proto));
            }
            if (type != null) {
                mt.setType(ICECandidate.Type.valueOf(type));
            }
            return new JingleTransport.Ice.Candidate(mt);
        }
    }
}

