/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smackx.jingleold.media.ContentInfo;
import org.jivesoftware.smackx.jingleold.packet.JingleContentInfo;
import org.xmlpull.v1.XmlPullParser;

public class JingleContentInfoProvider {

    public static class Audio
    extends ExtensionElementProvider<ExtensionElement> {
        private final ExtensionElement audioInfo;

        public Audio() {
            this(null);
        }

        public Audio(ExtensionElement audioInfo) {
            this.audioInfo = audioInfo;
        }

        public ExtensionElement parse(XmlPullParser parser, int initialDepth) {
            ExtensionElement result = null;
            if (this.audioInfo != null) {
                result = this.audioInfo;
            } else {
                String elementName = parser.getName();
                ContentInfo mi = ContentInfo.Audio.fromString(elementName);
                if (mi != null) {
                    result = new JingleContentInfo.Audio(mi);
                }
            }
            return result;
        }

        public static class Ringing
        extends Audio {
            public Ringing() {
                super(new JingleContentInfo.Audio.Ringing());
            }
        }

        public static class Queued
        extends Audio {
            public Queued() {
                super(new JingleContentInfo.Audio.Queued());
            }
        }

        public static class Mute
        extends Audio {
            public Mute() {
                super(new JingleContentInfo.Audio.Mute());
            }
        }

        public static class Hold
        extends Audio {
            public Hold() {
                super(new JingleContentInfo.Audio.Hold());
            }
        }

        public static class Busy
        extends Audio {
            public Busy() {
                super(new JingleContentInfo.Audio.Busy());
            }
        }
    }
}

