/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smackx.jingleold.packet.JingleDescription;
import org.jivesoftware.smackx.jingleold.packet.JingleTransport;

public class JingleContent
implements ExtensionElement {
    public static final String NODENAME = "content";
    public static final String CREATOR = "creator";
    public static final String NAME = "name";
    private String creator;
    private String name;
    private JingleDescription description;
    private final List<JingleTransport> transports = new ArrayList<JingleTransport>();

    public JingleContent(String creator, String name) {
        this.creator = creator;
        this.name = name;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getName() {
        return this.name;
    }

    public String getElementName() {
        return NODENAME;
    }

    public String getNamespace() {
        return "";
    }

    public void setDescription(JingleDescription description) {
        this.description = description;
    }

    public JingleDescription getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJingleTransport(JingleTransport transport) {
        List<JingleTransport> list = this.transports;
        synchronized (list) {
            this.transports.add(transport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransports(List<JingleTransport> transports) {
        List<JingleTransport> list = transports;
        synchronized (list) {
            for (JingleTransport transport : transports) {
                this.addJingleTransport(transport);
            }
        }
    }

    public Iterator<JingleTransport> getJingleTransports() {
        return Collections.unmodifiableList(this.getJingleTransportsList()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JingleTransport> getJingleTransportsList() {
        List<JingleTransport> list = this.transports;
        synchronized (list) {
            return new ArrayList<JingleTransport>(this.transports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJingleTransportsCount() {
        List<JingleTransport> list = this.transports;
        synchronized (list) {
            return this.transports.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        List<JingleTransport> list = this.transports;
        synchronized (list) {
            buf.append("<").append(this.getElementName());
            buf.append(" creator='" + this.creator + "' name='" + this.name + "'>");
            if (this.description != null) {
                buf.append(this.description.toXML());
            }
            for (JingleTransport transport : this.transports) {
                buf.append(transport.toXML());
            }
            buf.append("</").append(this.getElementName()).append(">");
        }
        return buf.toString();
    }
}

