/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.nat;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.nat.DatagramListener;
import org.jivesoftware.smackx.jingleold.nat.ResultListener;
import org.jivesoftware.smackx.jingleold.nat.TestResult;
import org.jivesoftware.smackx.jingleold.nat.TransportResolverListener;

public abstract class TransportCandidate {
    private static final Logger LOGGER = Logger.getLogger(TransportCandidate.class.getName());
    private String name;
    private String ip;
    private int port;
    private String localIp;
    private int generation;
    protected String password;
    private String sessionId;
    private XMPPConnection connection;
    private TransportCandidate symmetric;
    private CandidateEcho candidateEcho = null;
    private Thread echoThread = null;
    private final List<TransportResolverListener.Checker> listeners = new ArrayList<TransportResolverListener.Checker>();

    public void addCandidateEcho(JingleSession session) throws SocketException, UnknownHostException {
        this.candidateEcho = new CandidateEcho(this, session);
        this.echoThread = new Thread(this.candidateEcho);
        this.echoThread.start();
    }

    public void removeCandidateEcho() {
        if (this.candidateEcho != null) {
            this.candidateEcho.cancel();
        }
        this.candidateEcho = null;
        this.echoThread = null;
    }

    public CandidateEcho getCandidateEcho() {
        return this.candidateEcho;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getLocalIp() {
        return this.localIp == null ? this.ip : this.localIp;
    }

    public void setLocalIp(String localIp) {
        this.localIp = localIp;
    }

    public TransportCandidate getSymmetric() {
        return this.symmetric;
    }

    public void setSymmetric(TransportCandidate symetric) {
        this.symmetric = symetric;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public void setConnection(XMPPConnection connection) {
        this.connection = connection;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public TransportCandidate() {
        this(null, 0, 0);
    }

    public TransportCandidate(String ip, int port) {
        this(ip, port, 0);
    }

    public TransportCandidate(String ip, int port, int generation) {
        this.ip = ip;
        this.port = port;
        this.generation = generation;
    }

    public boolean isNull() {
        if (this.ip == null) {
            return true;
        }
        if (this.ip.length() == 0) {
            return true;
        }
        return this.port < 0;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransportCandidate other = (TransportCandidate)obj;
        if (this.generation != other.generation) {
            return false;
        }
        if (this.getIp() == null ? other.getIp() != null : !this.getIp().equals(other.getIp())) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    public void check(List<TransportCandidate> localCandidates) {
        Thread checkThread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean isUsable;
                try {
                    InetAddress candAddress = InetAddress.getByName(TransportCandidate.this.getIp());
                    isUsable = true;
                }
                catch (Exception e) {
                    isUsable = false;
                }
                TransportCandidate.this.triggerCandidateChecked(isUsable);
            }
        }, "Transport candidate check");
        checkThread.setName("Transport candidate test");
        checkThread.start();
    }

    void triggerCandidateChecked(boolean result) {
        for (TransportResolverListener.Checker trl : this.getListenersList()) {
            trl.candidateChecked(this, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransportResolverListener.Checker> getListenersList() {
        List<TransportResolverListener.Checker> list = this.listeners;
        synchronized (list) {
            return new ArrayList<TransportResolverListener.Checker>(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TransportResolverListener.Checker li) {
        List<TransportResolverListener.Checker> list = this.listeners;
        synchronized (list) {
            this.listeners.add(li);
        }
    }

    public class CandidateEcho
    implements Runnable {
        DatagramSocket socket = null;
        String localUser = null;
        String remoteUser = null;
        String id = null;
        byte[] send = null;
        byte[] receive = null;
        DatagramPacket sendStanza = null;
        List<DatagramListener> listeners = new ArrayList<DatagramListener>();
        List<ResultListener> resultListeners = new ArrayList<ResultListener>();
        boolean enabled = true;
        boolean ended = false;
        long replyTries = 2L;
        long tries = 10L;
        TransportCandidate candidate = null;

        public CandidateEcho(TransportCandidate candidate, JingleSession session) throws UnknownHostException, SocketException {
            this.socket = new DatagramSocket(candidate.getPort(), InetAddress.getByName(candidate.getLocalIp()));
            this.localUser = session.getInitiator();
            this.remoteUser = session.getResponder();
            this.id = session.getSid();
            this.candidate = candidate;
            int keySplitIndex = (int)Math.ceil((float)this.id.length() / 2.0f);
            String local = this.id.substring(0, keySplitIndex) + ";" + this.localUser;
            String remote = this.id.substring(keySplitIndex) + ";" + this.remoteUser;
            try {
                if (session.getConnection().getUser().equals(session.getInitiator())) {
                    this.send = local.getBytes("UTF-8");
                    this.receive = remote.getBytes("UTF-8");
                } else {
                    this.receive = local.getBytes("UTF-8");
                    this.send = remote.getBytes("UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        /*
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                TransportCandidate.access$000().fine("Listening for ECHO: " + this.socket.getLocalAddress().getHostAddress() + ":" + this.socket.getLocalPort());
                block9: while (true) {
                    packet = new DatagramPacket(new byte[150], 150);
                    this.socket.receive(packet);
                    accept = false;
                    buf = ByteBuffer.wrap(packet.getData());
                    content = new byte[packet.getLength()];
                    buf = buf.get(content, 0, packet.getLength());
                    packet.setData(content);
                    var5_10 = this.listeners.iterator();
                    while (var5_10.hasNext() && !(accept = (listener = var5_10.next()).datagramReceived(packet))) {
                    }
                    delay = 100L / this.replyTries;
                    str = new String(packet.getData(), "UTF-8").split(";");
                    pass = str[0];
                    address = str[1].split(":");
                    ip = address[0];
                    port = address[1];
                    if (!pass.equals(this.candidate.getPassword()) || accept) continue;
                    cont = null;
                    try {
                        cont = (TransportCandidate.this.password + ";" + this.candidate.getIp() + ":" + this.candidate.getPort()).getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    packet.setData(cont);
                    packet.setLength(cont.length);
                    packet.setAddress(InetAddress.getByName(ip));
                    packet.setPort(Integer.parseInt(port));
                    i = 0;
                    while (true) {
                        if ((long)i >= this.replyTries) continue block9;
                        this.socket.send(packet);
                        if (this.enabled) ** break;
                        continue block9;
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (UnknownHostException uhe) {
                if (!this.enabled) return;
            }
            catch (SocketException se) {
                if (!this.enabled) return;
            }
            catch (IOException ioe) {
                if (!this.enabled) return;
            }
            catch (Exception e) {
                if (!this.enabled) return;
            }
        }

        public void cancel() {
            this.enabled = false;
            this.socket.close();
        }

        private void fireTestResult(TestResult testResult, TransportCandidate candidate) {
            for (ResultListener resultListener : this.resultListeners) {
                resultListener.testFinished(testResult, candidate);
            }
        }

        public void testASync(final TransportCandidate transportCandidate, final String password) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    DatagramListener listener = new DatagramListener(){

                        @Override
                        public boolean datagramReceived(DatagramPacket datagramPacket) {
                            try {
                                LOGGER.fine("ECHO Received to: " + CandidateEcho.this.candidate.getIp() + ":" + CandidateEcho.this.candidate.getPort() + "  data: " + new String(datagramPacket.getData(), "UTF-8"));
                                String[] str = new String(datagramPacket.getData(), "UTF-8").split(";");
                                String pass = str[0];
                                String[] addr = str[1].split(":");
                                String ip = addr[0];
                                String pt = addr[1];
                                if (pass.equals(password) && transportCandidate.getIp().indexOf(ip) != -1 && transportCandidate.getPort() == Integer.parseInt(pt)) {
                                    LOGGER.fine("ECHO OK: " + CandidateEcho.this.candidate.getIp() + ":" + CandidateEcho.this.candidate.getPort() + " <-> " + transportCandidate.getIp() + ":" + transportCandidate.getPort());
                                    TestResult testResult = new TestResult();
                                    testResult.setResult(true);
                                    CandidateEcho.this.ended = true;
                                    CandidateEcho.this.fireTestResult(testResult, transportCandidate);
                                    return true;
                                }
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                            LOGGER.fine("ECHO Wrong Data: " + datagramPacket.getAddress().getHostAddress() + ":" + datagramPacket.getPort());
                            return false;
                        }
                    };
                    CandidateEcho.this.addListener(listener);
                    byte[] content = null;
                    try {
                        content = new String(password + ";" + TransportCandidate.this.getIp() + ":" + TransportCandidate.this.getPort()).getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    DatagramPacket packet = new DatagramPacket(content, content.length);
                    try {
                        packet.setAddress(InetAddress.getByName(transportCandidate.getIp()));
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                    packet.setPort(transportCandidate.getPort());
                    long delay = 200L;
                    try {
                        int i = 0;
                        while ((long)i < CandidateEcho.this.tries) {
                            CandidateEcho.this.socket.send(packet);
                            if (CandidateEcho.this.ended) break;
                            try {
                                Thread.sleep(delay);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            ++i;
                        }
                    }
                    catch (IOException i) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    CandidateEcho.this.removeListener(listener);
                }
            });
            thread.start();
        }

        public void addListener(DatagramListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(DatagramListener listener) {
            this.listeners.remove(listener);
        }

        public void addResultListener(ResultListener resultListener) {
            this.resultListeners.add(resultListener);
        }

        public void removeResultListener(ResultListener resultListener) {
            this.resultListeners.remove(resultListener);
        }
    }

    public static class Channel {
        public static final Channel MYRTPVOICE = new Channel("myrtpvoice");
        public static final Channel MYRTCPVOICE = new Channel("myrtcpvoice");
        private String value;

        public Channel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Channel fromString(String value) {
            if (value == null) {
                return MYRTPVOICE;
            }
            if ((value = value.toLowerCase(Locale.US)).equals("myrtpvoice")) {
                return MYRTPVOICE;
            }
            if (value.equals("tcp")) {
                return MYRTCPVOICE;
            }
            return MYRTPVOICE;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Channel other = (Channel)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public boolean isNull() {
            if (this.value == null) {
                return true;
            }
            return this.value.length() == 0;
        }
    }

    public static class Protocol {
        public static final Protocol UDP = new Protocol("udp");
        public static final Protocol TCP = new Protocol("tcp");
        public static final Protocol TCPACT = new Protocol("tcp-act");
        public static final Protocol TCPPASS = new Protocol("tcp-pass");
        public static final Protocol SSLTCP = new Protocol("ssltcp");
        private String value;

        public Protocol(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Protocol fromString(String value) {
            if (value == null) {
                return UDP;
            }
            if ((value = value.toLowerCase(Locale.US)).equals("udp")) {
                return UDP;
            }
            if (value.equals("tcp")) {
                return TCP;
            }
            if (value.equals("tcp-act")) {
                return TCPACT;
            }
            if (value.equals("tcp-pass")) {
                return TCPPASS;
            }
            if (value.equals("ssltcp")) {
                return SSLTCP;
            }
            return UDP;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Protocol other = (Protocol)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public boolean isNull() {
            if (this.value == null) {
                return true;
            }
            return this.value.length() == 0;
        }
    }

    public static class Fixed
    extends TransportCandidate {
        public Fixed() {
        }

        public Fixed(String ip, int port) {
            super(ip, port);
        }

        public Fixed(String ip, int port, int generation) {
            super(ip, port, generation);
        }
    }
}

