/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.nat;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.nat.ICECandidate;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;
import org.jivesoftware.smackx.jingleold.nat.TransportResolverListener;

public abstract class TransportResolver {
    private static final Logger LOGGER = Logger.getLogger(TransportResolver.class.getName());
    public Type type = Type.rawupd;
    public static final int CHECK_TIMEOUT = 3000;
    private final ArrayList<TransportResolverListener> listeners = new ArrayList();
    private boolean resolving = false;
    private boolean resolved = false;
    private boolean initialized = false;
    protected final List<TransportCandidate> candidates = new ArrayList<TransportCandidate>();

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    protected TransportResolver() {
    }

    public abstract void initialize() throws XMPPException, SmackException;

    public abstract void resolve(JingleSession var1) throws XMPPException, SmackException;

    public void clear() throws XMPPException {
        this.cancel();
        this.candidates.clear();
    }

    public abstract void cancel() throws XMPPException;

    public boolean isResolving() {
        return this.resolving;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public synchronized void setInitialized() {
        this.initialized = true;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    protected synchronized void setResolveInit() {
        this.resolved = false;
        this.resolving = true;
        this.triggerResolveInit();
    }

    protected synchronized void setResolveEnd() {
        this.resolved = true;
        this.resolving = false;
        this.triggerResolveEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TransportResolverListener li) {
        ArrayList<TransportResolverListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TransportResolverListener li) {
        ArrayList<TransportResolverListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(li);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TransportResolverListener> getListenersList() {
        ArrayList<TransportResolverListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return new ArrayList<TransportResolverListener>(this.listeners);
        }
    }

    protected void triggerCandidateAdded(TransportCandidate cand) throws SmackException.NotConnectedException {
        for (TransportResolverListener trl : this.getListenersList()) {
            if (!(trl instanceof TransportResolverListener.Resolver)) continue;
            TransportResolverListener.Resolver li = (TransportResolverListener.Resolver)trl;
            LOGGER.fine("triggerCandidateAdded : " + cand.getLocalIp());
            li.candidateAdded(cand);
        }
    }

    private void triggerResolveInit() {
        for (TransportResolverListener trl : this.getListenersList()) {
            if (!(trl instanceof TransportResolverListener.Resolver)) continue;
            TransportResolverListener.Resolver li = (TransportResolverListener.Resolver)trl;
            li.init();
        }
    }

    private void triggerResolveEnd() {
        for (TransportResolverListener trl : this.getListenersList()) {
            if (!(trl instanceof TransportResolverListener.Resolver)) continue;
            TransportResolverListener.Resolver li = (TransportResolverListener.Resolver)trl;
            li.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCandidates() {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            this.candidates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCandidate(TransportCandidate cand) throws SmackException.NotConnectedException {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            if (!this.candidates.contains(cand)) {
                this.candidates.add(cand);
            }
        }
        this.triggerCandidateAdded(cand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<TransportCandidate> getCandidates() {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<TransportCandidate>(this.candidates)).iterator();
        }
    }

    public TransportCandidate getPreferredCandidate() {
        TransportCandidate result = null;
        ArrayList<ICECandidate> cands = new ArrayList<ICECandidate>();
        for (TransportCandidate tpcan : this.getCandidatesList()) {
            if (!(tpcan instanceof ICECandidate)) continue;
            cands.add((ICECandidate)tpcan);
        }
        if (cands.size() > 0) {
            Collections.sort(cands);
            result = (TransportCandidate)cands.get(cands.size() - 1);
            LOGGER.fine("Result: " + result.getIp());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCandidateCount() {
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            return this.candidates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransportCandidate> getCandidatesList() {
        ArrayList<TransportCandidate> result = null;
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            result = new ArrayList<TransportCandidate>(this.candidates);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportCandidate getCandidate(int i) {
        TransportCandidate cand;
        List<TransportCandidate> list = this.candidates;
        synchronized (list) {
            cand = this.candidates.get(i);
        }
        return cand;
    }

    public void initializeAndWait() throws XMPPException, SmackException {
        this.initialize();
        try {
            LOGGER.fine("Initializing transport resolver...");
            while (!this.isInitialized()) {
                LOGGER.fine("Resolver init still pending");
                Thread.sleep(1000L);
            }
            LOGGER.fine("Transport resolved");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getFreePort() {
        int freePort = 0;
        for (int i = 0; i < 10; ++i) {
            freePort = (int)(10000L + Math.round(Math.random() * 10000.0));
            freePort = freePort % 2 == 0 ? freePort : freePort + 1;
            try {
                ServerSocket ss = new ServerSocket(freePort);
                freePort = ss.getLocalPort();
                ss.close();
                return freePort;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
        }
        try {
            ServerSocket ss = new ServerSocket(0);
            freePort = ss.getLocalPort();
            ss.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return freePort;
    }

    public static enum Type {
        rawupd,
        ice;

    }
}

