/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingleold.JingleNegotiator;
import org.jivesoftware.smackx.jingleold.JingleNegotiatorState;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.listeners.JingleListener;
import org.jivesoftware.smackx.jingleold.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingleold.media.JingleMediaManager;
import org.jivesoftware.smackx.jingleold.media.JingleMediaSession;
import org.jivesoftware.smackx.jingleold.media.MediaNegotiator;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;
import org.jivesoftware.smackx.jingleold.nat.TransportNegotiator;
import org.jivesoftware.smackx.jingleold.packet.Jingle;
import org.jivesoftware.smackx.jingleold.packet.JingleContent;

public class ContentNegotiator
extends JingleNegotiator {
    public static final String INITIATOR = "initiator";
    public static final String RESPONDER = "responder";
    private List<TransportNegotiator> transportNegotiators;
    private MediaNegotiator mediaNeg;
    private TransportNegotiator transNeg;
    private JingleTransportManager jingleTransportManager;
    private String creator;
    private String name;
    private JingleMediaSession jingleMediaSession = null;

    public ContentNegotiator(JingleSession session, String inCreator, String inName) {
        super(session);
        this.creator = inCreator;
        this.name = inName;
        this.transportNegotiators = new ArrayList<TransportNegotiator>();
    }

    @Override
    public List<IQ> dispatchIncomingPacket(IQ iq, String id) throws XMPPException, SmackException {
        ArrayList<IQ> responses = new ArrayList<IQ>();
        if (iq != null && !iq.getType().equals((Object)IQ.Type.error)) {
            if (iq.getType().equals((Object)IQ.Type.result)) {
                if (this.isExpectedId(iq.getStanzaId())) {
                    this.removeExpectedId(iq.getStanzaId());
                }
            } else if (iq instanceof Jingle) {
                Jingle jingle = (Jingle)iq;
                for (JingleContent jingleContent : jingle.getContentsList()) {
                    if (!jingleContent.getName().equals(this.name)) continue;
                    if (this.mediaNeg != null) {
                        responses.addAll(this.mediaNeg.dispatchIncomingPacket(iq, id));
                    }
                    if (this.transNeg == null) continue;
                    responses.addAll(this.transNeg.dispatchIncomingPacket(iq, id));
                }
            }
        }
        return responses;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getName() {
        return this.name;
    }

    public JingleMediaSession getJingleMediaSession() {
        return this.jingleMediaSession;
    }

    public void addTransportNegotiator(TransportNegotiator transportNegotiator) {
        this.transportNegotiators.add(transportNegotiator);
    }

    public void setJingleTransportManager(JingleTransportManager jingleTransportManager) {
        this.jingleTransportManager = jingleTransportManager;
    }

    public JingleTransportManager getTransportManager() {
        return this.jingleTransportManager;
    }

    @Override
    protected void doStart() {
        this.mediaNeg.start();
        this.transNeg.start();
    }

    @Override
    public void close() {
        this.destroyMediaNegotiator();
        this.destroyTransportNegotiator();
    }

    public MediaNegotiator getMediaNegotiator() {
        return this.mediaNeg;
    }

    protected void setMediaNegotiator(MediaNegotiator mediaNeg) {
        this.destroyMediaNegotiator();
        this.mediaNeg = mediaNeg;
    }

    protected void destroyMediaNegotiator() {
        if (this.mediaNeg != null) {
            this.mediaNeg.close();
            this.mediaNeg = null;
        }
    }

    public TransportNegotiator getTransportNegotiator() {
        return this.transNeg;
    }

    protected void setTransportNegotiator(TransportNegotiator transNeg) {
        this.destroyTransportNegotiator();
        this.transNeg = transNeg;
    }

    protected void destroyTransportNegotiator() {
        if (this.transNeg != null) {
            this.transNeg.close();
            this.transNeg = null;
        }
    }

    public boolean isFullyEstablished() {
        TransportNegotiator transNeg;
        boolean result = true;
        MediaNegotiator mediaNeg = this.getMediaNegotiator();
        if (mediaNeg == null || !mediaNeg.isFullyEstablished()) {
            result = false;
        }
        if ((transNeg = this.getTransportNegotiator()) == null || !transNeg.isFullyEstablished()) {
            result = false;
        }
        return result;
    }

    public JingleContent getJingleContent() {
        JingleContent result = new JingleContent(this.creator, this.name);
        if (this.mediaNeg != null) {
            result.setDescription(this.mediaNeg.getJingleDescription());
        }
        if (this.transNeg != null) {
            result.addJingleTransport(this.transNeg.getJingleTransport());
        }
        return result;
    }

    public void triggerContentEstablished() throws SmackException.NotConnectedException {
        PayloadType bestCommonAudioPt = this.getMediaNegotiator().getBestCommonAudioPt();
        TransportCandidate bestRemoteCandidate = this.getTransportNegotiator().getBestRemoteCandidate();
        TransportCandidate acceptedLocalCandidate = this.getTransportNegotiator().getAcceptedLocalCandidate();
        this.triggerContentEstablished(bestCommonAudioPt, bestRemoteCandidate, acceptedLocalCandidate);
    }

    private void triggerContentEstablished(PayloadType pt, TransportCandidate rc, TransportCandidate lc) throws SmackException.NotConnectedException {
        JingleSession session = this.getSession();
        if (session != null) {
            List<JingleListener> listeners = session.getListenersList();
            Iterator<JingleListener> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                JingleListener li = iterator.next();
                if (!(li instanceof JingleSessionListener)) continue;
                JingleSessionListener sli = (JingleSessionListener)li;
                sli.sessionEstablished(pt, rc, lc, session);
            }
        }
        if (this.mediaNeg.getMediaManager() != null) {
            rc.removeCandidateEcho();
            lc.removeCandidateEcho();
            this.jingleMediaSession = this.getMediaNegotiator().getMediaManager().createMediaSession(pt, rc, lc, session);
            this.jingleMediaSession.addMediaReceivedListener(session);
            if (this.jingleMediaSession != null) {
                this.jingleMediaSession.startTrasmit();
                this.jingleMediaSession.startReceive();
                for (TransportCandidate candidate : this.getTransportNegotiator().getOfferedCandidates()) {
                    candidate.removeCandidateEcho();
                }
            }
            JingleMediaManager mediaManager = this.getMediaNegotiator().getMediaManager();
            this.getSession().addJingleMediaSession(mediaManager.getName(), this.jingleMediaSession);
        }
    }

    public void stopJingleMediaSession() {
        if (this.jingleMediaSession != null) {
            this.jingleMediaSession.stopTrasmit();
            this.jingleMediaSession.stopReceive();
        }
    }

    @Override
    public JingleNegotiatorState getNegotiatorState() {
        JingleNegotiatorState result = JingleNegotiatorState.PENDING;
        if (this.mediaNeg != null && this.transNeg != null) {
            if (this.mediaNeg.getNegotiatorState() == JingleNegotiatorState.SUCCEEDED || this.transNeg.getNegotiatorState() == JingleNegotiatorState.SUCCEEDED) {
                result = JingleNegotiatorState.SUCCEEDED;
            }
            if (this.mediaNeg.getNegotiatorState() == JingleNegotiatorState.FAILED || this.transNeg.getNegotiatorState() == JingleNegotiatorState.FAILED) {
                result = JingleNegotiatorState.FAILED;
            }
        }
        this.setNegotiatorState(result);
        return result;
    }
}

