/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.nat;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.listeners.CreatedJingleSessionListener;
import org.jivesoftware.smackx.jingleold.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.nat.ICECandidate;
import org.jivesoftware.smackx.jingleold.nat.ICEResolver;
import org.jivesoftware.smackx.jingleold.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingleold.nat.RTPBridge;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;
import org.jivesoftware.smackx.jingleold.nat.TransportResolver;

public class ICETransportManager
extends JingleTransportManager
implements JingleSessionListener,
CreatedJingleSessionListener {
    ICEResolver iceResolver = null;

    public ICETransportManager(XMPPConnection xmppConnection, String server, int port) {
        this.iceResolver = new ICEResolver(xmppConnection, server, port);
        try {
            this.iceResolver.initializeAndWait();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected TransportResolver createResolver(JingleSession session) throws SmackException {
        try {
            this.iceResolver.resolve(session);
        }
        catch (XMPPException e) {
            e.printStackTrace();
        }
        return this.iceResolver;
    }

    @Override
    public void sessionEstablished(PayloadType pt, TransportCandidate rc, TransportCandidate lc, JingleSession jingleSession) throws SmackException.NotConnectedException {
        if (lc instanceof ICECandidate && ((ICECandidate)lc).getType().equals("relay")) {
            RTPBridge rTPBridge = RTPBridge.relaySession(lc.getConnection(), lc.getSessionId(), lc.getPassword(), rc, lc);
        }
    }

    @Override
    public void sessionDeclined(String reason, JingleSession jingleSession) {
    }

    @Override
    public void sessionRedirected(String redirection, JingleSession jingleSession) {
    }

    @Override
    public void sessionClosed(String reason, JingleSession jingleSession) {
    }

    @Override
    public void sessionClosedOnError(XMPPException e, JingleSession jingleSession) {
    }

    @Override
    public void sessionMediaReceived(JingleSession jingleSession, String participant) {
    }

    @Override
    public void sessionCreated(JingleSession jingleSession) {
        jingleSession.addListener(this);
    }
}

