/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.nat;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Random;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.nat.RTPBridge;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;
import org.jivesoftware.smackx.jingleold.nat.TransportResolver;

public class BridgedResolver
extends TransportResolver {
    XMPPConnection connection;
    Random random = new Random();
    long sid;

    public BridgedResolver(XMPPConnection connection) {
        this.connection = connection;
    }

    @Override
    public synchronized void resolve(JingleSession session) throws XMPPException, SmackException.NotConnectedException, InterruptedException {
        this.setResolveInit();
        this.clearCandidates();
        this.sid = Math.abs(this.random.nextLong());
        RTPBridge rtpBridge = RTPBridge.getRTPBridge(this.connection, String.valueOf(this.sid));
        String localIp = BridgedResolver.getLocalHost();
        TransportCandidate.Fixed localCandidate = new TransportCandidate.Fixed(rtpBridge.getIp(), rtpBridge.getPortA());
        localCandidate.setLocalIp(localIp);
        TransportCandidate.Fixed remoteCandidate = new TransportCandidate.Fixed(rtpBridge.getIp(), rtpBridge.getPortB());
        remoteCandidate.setLocalIp(localIp);
        localCandidate.setSymmetric(remoteCandidate);
        remoteCandidate.setSymmetric(localCandidate);
        localCandidate.setPassword(rtpBridge.getPass());
        remoteCandidate.setPassword(rtpBridge.getPass());
        localCandidate.setSessionId(rtpBridge.getSid());
        remoteCandidate.setSessionId(rtpBridge.getSid());
        localCandidate.setConnection(this.connection);
        remoteCandidate.setConnection(this.connection);
        this.addCandidate(localCandidate);
        this.setResolveEnd();
    }

    @Override
    public void initialize() throws SmackException, XMPPException.XMPPErrorException, InterruptedException {
        this.clearCandidates();
        if (!RTPBridge.serviceAvailable(this.connection)) {
            this.setInitialized();
            throw new SmackException("No RTP Bridge service available");
        }
        this.setInitialized();
    }

    @Override
    public void cancel() throws XMPPException {
    }

    public static String getLocalHost() {
        Enumeration<NetworkInterface> ifaces = null;
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
            while (iaddresses.hasMoreElements()) {
                InetAddress iaddress = iaddresses.nextElement();
                if (iaddress.isLoopbackAddress() || iaddress.isLinkLocalAddress() || iaddress.isSiteLocalAddress() || iaddress instanceof Inet6Address) continue;
                return iaddress.getHostAddress();
            }
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "127.0.0.1";
        }
    }
}

