/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingleold.JingleActionEnum;
import org.jivesoftware.smackx.jingleold.packet.JingleContent;
import org.jivesoftware.smackx.jingleold.packet.JingleContentInfo;
import org.jxmpp.jid.Jid;

public class Jingle
extends IQ {
    public static final String NAMESPACE = "urn:xmpp:tmp:jingle";
    public static final String NODENAME = "jingle";
    private String sid;
    private JingleActionEnum action;
    private Jid initiator;
    private Jid responder;
    private final List<JingleContent> contents = new ArrayList<JingleContent>();
    private JingleContentInfo contentInfo;

    public Jingle(List<JingleContent> contents, JingleContentInfo mi, String sid) {
        this();
        if (contents != null) {
            contents.addAll(contents);
        }
        this.setContentInfo(mi);
        this.setSid(sid);
        this.initiator = null;
        this.responder = null;
        this.action = null;
    }

    public Jingle(JingleContent content) {
        this();
        this.addContent(content);
        this.initiator = null;
        this.responder = null;
        this.action = JingleActionEnum.UNKNOWN;
        this.setType(IQ.Type.set);
    }

    public Jingle(JingleContentInfo info) {
        this();
        this.setContentInfo(info);
        this.initiator = null;
        this.responder = null;
        this.action = JingleActionEnum.UNKNOWN;
        this.setType(IQ.Type.set);
    }

    public Jingle(JingleActionEnum action) {
        this(null, null, null);
        this.action = action;
        this.setType(IQ.Type.set);
    }

    public Jingle(String sid) {
        this(null, null, sid);
    }

    public Jingle() {
        super(NODENAME, NAMESPACE);
    }

    public final void setSid(String sid) {
        this.sid = sid;
    }

    public String getSid() {
        return this.sid;
    }

    public static String getElementName() {
        return NODENAME;
    }

    public static String getNamespace() {
        return NAMESPACE;
    }

    public JingleContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(JingleContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<JingleContent> getContents() {
        List<JingleContent> list = this.contents;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<JingleContent>(this.contents)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JingleContent> getContentsList() {
        List<JingleContent> list = this.contents;
        synchronized (list) {
            return new ArrayList<JingleContent>(this.contents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContent(JingleContent content) {
        if (content != null) {
            List<JingleContent> list = this.contents;
            synchronized (list) {
                this.contents.add(content);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContents(List<JingleContent> contentList) {
        if (contentList != null) {
            List<JingleContent> list = this.contents;
            synchronized (list) {
                this.contents.addAll(contentList);
            }
        }
    }

    public JingleActionEnum getAction() {
        return this.action;
    }

    public void setAction(JingleActionEnum action) {
        this.action = action;
    }

    public Jid getInitiator() {
        return this.initiator;
    }

    public void setInitiator(Jid initiator) {
        this.initiator = initiator;
    }

    public Jid getResponder() {
        return this.responder;
    }

    public void setResponder(Jid resp) {
        this.responder = resp;
    }

    public static int getSessionHash(String sid, Jid initiator) {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (initiator == null ? 0 : initiator.hashCode());
        result = 31 * result + (sid == null ? 0 : sid.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        if (this.getInitiator() != null) {
            buf.append((CharSequence)" initiator=\"").append((CharSequence)this.getInitiator()).append((CharSequence)"\"");
        }
        if (this.getResponder() != null) {
            buf.append((CharSequence)" responder=\"").append((CharSequence)this.getResponder()).append((CharSequence)"\"");
        }
        if (this.getAction() != null) {
            buf.append((CharSequence)" action=\"").append((CharSequence)this.getAction().name()).append((CharSequence)"\"");
        }
        if (this.getSid() != null) {
            buf.append((CharSequence)" sid=\"").append((CharSequence)this.getSid()).append((CharSequence)"\"");
        }
        buf.append((CharSequence)">");
        List<JingleContent> list = this.contents;
        synchronized (list) {
            for (JingleContent content : this.contents) {
                buf.append((CharSequence)content.toXML());
            }
        }
        if (this.contentInfo != null) {
            buf.append((CharSequence)this.contentInfo.toXML());
        }
        return buf;
    }
}

