/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smackx.jingleold.JingleActionEnum;
import org.jivesoftware.smackx.jingleold.packet.Jingle;
import org.jivesoftware.smackx.jingleold.packet.JingleContent;
import org.jivesoftware.smackx.jingleold.packet.JingleContentInfo;
import org.jivesoftware.smackx.jingleold.packet.JingleDescription;
import org.jivesoftware.smackx.jingleold.packet.JingleTransport;
import org.jivesoftware.smackx.jingleold.provider.JingleContentInfoProvider;
import org.jivesoftware.smackx.jingleold.provider.JingleContentProvider;
import org.jivesoftware.smackx.jingleold.provider.JingleDescriptionProvider;
import org.jivesoftware.smackx.jingleold.provider.JingleTransportProvider;
import org.jxmpp.jid.Jid;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class JingleProvider
extends IQProvider<Jingle> {
    public Jingle parse(XmlPullParser parser, int intialDepth) throws XmlPullParserException, IOException, SmackException {
        Jingle jingle = new Jingle();
        String sid = "";
        Jid initiator = null;
        Jid responder = null;
        boolean done = false;
        JingleContent currentContent = null;
        JingleContentProvider jcp = new JingleContentProvider();
        JingleDescriptionProvider.Audio jdpAudio = new JingleDescriptionProvider.Audio();
        JingleTransportProvider.RawUdp jtpRawUdp = new JingleTransportProvider.RawUdp();
        JingleTransportProvider.Ice jtpIce = new JingleTransportProvider.Ice();
        JingleContentInfoProvider.Audio jmipAudio = new JingleContentInfoProvider.Audio();
        sid = parser.getAttributeValue("", "sid");
        JingleActionEnum action = JingleActionEnum.getAction(parser.getAttributeValue("", "action"));
        initiator = ParserUtils.getJidAttribute((XmlPullParser)parser, (String)"initiator");
        responder = ParserUtils.getJidAttribute((XmlPullParser)parser, (String)"responder");
        jingle.setSid(sid);
        jingle.setAction(action);
        jingle.setInitiator(initiator);
        jingle.setResponder(responder);
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == 2) {
                if (elementName.equals("content")) {
                    currentContent = (JingleContent)jcp.parse(parser);
                    jingle.addContent(currentContent);
                    continue;
                }
                if (elementName.equals("description") && namespace.equals("urn:xmpp:tmp:jingle:apps:rtp")) {
                    currentContent.setDescription((JingleDescription)jdpAudio.parse(parser));
                    continue;
                }
                if (elementName.equals("transport")) {
                    if (namespace.equals("http://www.xmpp.org/extensions/xep-0177.html#ns")) {
                        currentContent.addJingleTransport((JingleTransport)jtpRawUdp.parse(parser));
                        continue;
                    }
                    if (namespace.equals("urn:xmpp:tmp:jingle:transports:ice-udp")) {
                        currentContent.addJingleTransport((JingleTransport)jtpIce.parse(parser));
                        continue;
                    }
                    throw new SmackException("Unknown transport namespace \"" + namespace + "\" in Jingle packet.");
                }
                if (namespace.equals("urn:xmpp:tmp:jingle:apps:rtp")) {
                    jingle.setContentInfo((JingleContentInfo)jmipAudio.parse(parser));
                    continue;
                }
                throw new SmackException("Unknown combination of namespace \"" + namespace + "\" and element name \"" + elementName + "\" in Jingle packet.");
            }
            if (eventType != 3 || !parser.getName().equals(Jingle.getElementName())) continue;
            done = true;
        }
        return jingle;
    }
}

