/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smackx.jingleold.media.PayloadType;

public abstract class JingleDescription
implements ExtensionElement {
    private static final Logger LOGGER = Logger.getLogger(JingleDescription.class.getName());
    public static final String NODENAME = "description";
    private final List<PayloadType> payloads = new ArrayList<PayloadType>();

    public String getElementName() {
        return NODENAME;
    }

    public abstract String getNamespace();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPayloadType(PayloadType pt) {
        List<PayloadType> list = this.payloads;
        synchronized (list) {
            if (pt == null) {
                LOGGER.severe("Null payload type");
            } else {
                this.payloads.add(pt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioPayloadTypes(List<PayloadType> pts) {
        List<PayloadType> list = this.payloads;
        synchronized (list) {
            for (PayloadType.Audio audio : pts) {
                this.addPayloadType(new PayloadType.Audio(audio));
            }
        }
    }

    public Iterator<PayloadType> getPayloadTypes() {
        return Collections.unmodifiableList(this.getPayloadTypesList()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PayloadType> getPayloadTypesList() {
        List<PayloadType> list = this.payloads;
        synchronized (list) {
            return new ArrayList<PayloadType>(this.payloads);
        }
    }

    public List<PayloadType> getAudioPayloadTypesList() {
        ArrayList<PayloadType> result = new ArrayList<PayloadType>();
        Iterator<PayloadType> jinglePtsIter = this.getPayloadTypes();
        while (jinglePtsIter.hasNext()) {
            PayloadType jpt = jinglePtsIter.next();
            if (!(jpt instanceof PayloadType.Audio)) continue;
            PayloadType.Audio jpta = (PayloadType.Audio)jpt;
            result.add(jpta);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPayloadTypesCount() {
        List<PayloadType> list = this.payloads;
        synchronized (list) {
            return this.payloads.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML(String enclosingNamespace) {
        StringBuilder buf = new StringBuilder();
        List<PayloadType> list = this.payloads;
        synchronized (list) {
            if (this.payloads.size() > 0) {
                buf.append('<').append(this.getElementName());
                buf.append(" xmlns=\"").append(this.getNamespace()).append("\" >");
                for (PayloadType payloadType : this.payloads) {
                    if (payloadType == null) continue;
                    buf.append(payloadType.toXML());
                }
                buf.append("</").append(this.getElementName()).append('>');
            }
        }
        return buf.toString();
    }

    public static class Audio
    extends JingleDescription {
        public static final String NAMESPACE = "urn:xmpp:tmp:jingle:apps:rtp";

        public Audio() {
        }

        public Audio(PayloadType pt) {
            this.addPayloadType(pt);
        }

        @Override
        public String getNamespace() {
            return NAMESPACE;
        }
    }
}

