/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.packet.JingleContentDescription;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class JingleContentDescriptionProvider
extends ExtensionElementProvider<JingleContentDescription> {
    protected JingleContentDescription.JinglePayloadType parsePayload(XmlPullParser parser) {
        int ptId = 0;
        int ptChannels = 0;
        try {
            ptId = Integer.parseInt(parser.getAttributeValue("", "id"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String ptName = parser.getAttributeValue("", "name");
        try {
            ptChannels = Integer.parseInt(parser.getAttributeValue("", "channels"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new JingleContentDescription.JinglePayloadType(new PayloadType(ptId, ptName, ptChannels));
    }

    public JingleContentDescription parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        boolean done = false;
        JingleContentDescription desc = this.getInstance();
        while (!done) {
            int eventType = parser.next();
            String name = parser.getName();
            if (eventType == 2) {
                if (name.equals("payload-type")) {
                    desc.addJinglePayloadType(this.parsePayload(parser));
                    continue;
                }
                throw new SmackException("Unknow element \"" + name + "\" in content.");
            }
            if (eventType != 3 || !name.equals("description")) continue;
            done = true;
        }
        return desc;
    }

    protected abstract JingleContentDescription getInstance();

    public static class Audio
    extends JingleContentDescriptionProvider {
        @Override
        public JingleContentDescription.JinglePayloadType parsePayload(XmlPullParser parser) {
            JingleContentDescription.JinglePayloadType pte = super.parsePayload(parser);
            PayloadType.Audio pt = new PayloadType.Audio(pte.getPayloadType());
            int ptClockRate = 0;
            try {
                ptClockRate = Integer.parseInt(parser.getAttributeValue("", "clockrate"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            pt.setClockRate(ptClockRate);
            return new JingleContentDescription.JinglePayloadType.Audio(pt);
        }

        @Override
        protected JingleContentDescription getInstance() {
            return new JingleContentDescription.Audio();
        }
    }
}

