/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionClosedListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.jingleold.ContentNegotiator;
import org.jivesoftware.smackx.jingleold.JingleActionEnum;
import org.jivesoftware.smackx.jingleold.JingleException;
import org.jivesoftware.smackx.jingleold.JingleNegotiator;
import org.jivesoftware.smackx.jingleold.JingleNegotiatorState;
import org.jivesoftware.smackx.jingleold.JingleSessionRequest;
import org.jivesoftware.smackx.jingleold.JingleSessionState;
import org.jivesoftware.smackx.jingleold.JingleSessionStateActive;
import org.jivesoftware.smackx.jingleold.JingleSessionStateEnded;
import org.jivesoftware.smackx.jingleold.JingleSessionStatePending;
import org.jivesoftware.smackx.jingleold.JingleSessionStateUnknown;
import org.jivesoftware.smackx.jingleold.listeners.JingleListener;
import org.jivesoftware.smackx.jingleold.listeners.JingleMediaListener;
import org.jivesoftware.smackx.jingleold.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingleold.listeners.JingleTransportListener;
import org.jivesoftware.smackx.jingleold.media.JingleMediaManager;
import org.jivesoftware.smackx.jingleold.media.JingleMediaSession;
import org.jivesoftware.smackx.jingleold.media.MediaNegotiator;
import org.jivesoftware.smackx.jingleold.media.MediaReceivedListener;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;
import org.jivesoftware.smackx.jingleold.nat.TransportNegotiator;
import org.jivesoftware.smackx.jingleold.nat.TransportResolver;
import org.jivesoftware.smackx.jingleold.packet.Jingle;
import org.jivesoftware.smackx.jingleold.packet.JingleError;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public final class JingleSession
extends JingleNegotiator
implements MediaReceivedListener {
    private static final Logger LOGGER = Logger.getLogger(JingleSession.class.getName());
    private static final HashMap<XMPPConnection, JingleSession> sessions = new HashMap();
    private static final Random randomGenerator = new Random();
    private Jid initiator;
    private Jid responder;
    private String sid;
    private ConnectionListener connectionListener;
    private StanzaListener packetListener;
    private StanzaFilter packetFilter;
    protected List<JingleMediaManager> jingleMediaManagers = null;
    private JingleSessionState sessionState;
    private final List<ContentNegotiator> contentNegotiators;
    private final XMPPConnection connection;
    private String sessionInitPacketID;
    private final Map<String, JingleMediaSession> mediaSessionMap;

    public JingleSession(XMPPConnection conn, Jid initiator, Jid responder, String sessionid, List<JingleMediaManager> jingleMediaManagers) {
        this.initiator = initiator;
        this.responder = responder;
        this.sid = sessionid;
        this.jingleMediaManagers = jingleMediaManagers;
        this.setSession(this);
        this.connection = conn;
        this.setSessionState(JingleSessionStateUnknown.getInstance());
        this.contentNegotiators = new ArrayList<ContentNegotiator>();
        this.mediaSessionMap = new HashMap<String, JingleMediaSession>();
        this.registerInstance();
        this.installConnectionListeners(conn);
    }

    public JingleSession(XMPPConnection conn, JingleSessionRequest request, Jid initiator, Jid responder, List<JingleMediaManager> jingleMediaManagers) {
        this(conn, initiator, responder, JingleSession.generateSessionId(), jingleMediaManagers);
    }

    public Jid getInitiator() {
        return this.initiator;
    }

    @Override
    public XMPPConnection getConnection() {
        return this.connection;
    }

    public void setInitiator(Jid initiator) {
        this.initiator = initiator;
    }

    public List<JingleMediaManager> getMediaManagers() {
        return this.jingleMediaManagers;
    }

    public void setMediaManagers(List<JingleMediaManager> jingleMediaManagers) {
        this.jingleMediaManagers = jingleMediaManagers;
    }

    public Jid getResponder() {
        return this.responder;
    }

    public void setResponder(Jid responder) {
        this.responder = responder;
    }

    public String getSid() {
        return this.sid;
    }

    protected void setSid(String sessionId) {
        this.sid = sessionId;
    }

    protected static String generateSessionId() {
        return String.valueOf(randomGenerator.nextInt(Integer.MAX_VALUE) + randomGenerator.nextInt(Integer.MAX_VALUE));
    }

    public void setSessionState(JingleSessionState stateIs) {
        LOGGER.fine("Session state change: " + this.sessionState + "->" + stateIs);
        stateIs.enter();
        this.sessionState = stateIs;
    }

    public JingleSessionState getSessionState() {
        return this.sessionState;
    }

    public boolean isFullyEstablished() {
        boolean result = true;
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.isFullyEstablished()) continue;
            result = false;
        }
        return result;
    }

    public synchronized void receivePacketAndRespond(IQ iq) throws XMPPException, SmackException, InterruptedException {
        ArrayList<IQ> responses = new ArrayList<IQ>();
        LOGGER.fine("Packet: " + iq.toXML());
        try {
            responses.addAll(this.dispatchIncomingPacket(iq, null));
            if (iq != null) {
                String responseId = iq.getStanzaId();
                for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
                    if (!contentNegotiator.isStarted()) {
                        contentNegotiator.start();
                    }
                    responses.addAll(contentNegotiator.dispatchIncomingPacket(iq, responseId));
                }
            }
        }
        catch (JingleException e) {
            JingleError error = e.getError();
            if (error != null) {
                responses.add(this.createJingleError(iq, error));
            }
            this.triggerSessionClosedOnError(e);
        }
        for (IQ response : responses) {
            this.sendStanza(response);
        }
    }

    @Override
    public List<IQ> dispatchIncomingPacket(IQ iq, String id) throws XMPPException, SmackException, InterruptedException {
        ArrayList<IQ> responses = new ArrayList<IQ>();
        IQ response = null;
        if (iq != null && !iq.getType().equals((Object)IQ.Type.error)) {
            if (iq.getType().equals((Object)IQ.Type.result)) {
                if (this.isExpectedId(iq.getStanzaId())) {
                    if (iq.getStanzaId().equals(this.sessionInitPacketID)) {
                        this.startNegotiators();
                    }
                    this.removeExpectedId(iq.getStanzaId());
                }
            } else if (iq instanceof Jingle) {
                Jingle jin = (Jingle)iq;
                JingleActionEnum action = jin.getAction();
                response = this.getSessionState().processJingle(this, jin, action);
            }
        }
        if (response != null) {
            this.addExpectedId(response.getStanzaId());
            responses.add(response);
        }
        return responses;
    }

    public void addContentNegotiator(ContentNegotiator inContentNegotiator) {
        this.contentNegotiators.add(inContentNegotiator);
    }

    public void sendStanza(IQ iq) throws SmackException.NotConnectedException, InterruptedException {
        if (iq instanceof Jingle) {
            this.sendFormattedJingle((Jingle)iq);
        } else {
            this.getConnection().sendStanza((Stanza)iq);
        }
    }

    public Jingle sendFormattedJingle(Jingle jout) throws SmackException.NotConnectedException, InterruptedException {
        return this.sendFormattedJingle(null, jout);
    }

    public Jingle sendFormattedJingle(IQ iq, Jingle jout) throws SmackException.NotConnectedException, InterruptedException {
        if (jout != null) {
            Jid other;
            if (jout.getInitiator() == null) {
                jout.setInitiator(this.getInitiator());
            }
            if (jout.getResponder() == null) {
                jout.setResponder(this.getResponder());
            }
            if (jout.getSid() == null) {
                jout.setSid(this.getSid());
            }
            EntityFullJid me = this.getConnection().getUser();
            Jid jid = other = this.getResponder().equals((CharSequence)me) ? this.getInitiator() : this.getResponder();
            if (jout.getTo() == null) {
                if (iq != null) {
                    jout.setTo(iq.getFrom());
                } else {
                    jout.setTo(other);
                }
            }
            if (jout.getFrom() == null) {
                if (iq != null) {
                    jout.setFrom(iq.getTo());
                } else {
                    jout.setFrom((Jid)me);
                }
            }
            if (this.getConnection() != null && this.getConnection().isConnected()) {
                this.getConnection().sendStanza((Stanza)jout);
            }
        }
        return jout;
    }

    public IQ createAck(IQ iq) {
        IQ result = null;
        if (iq != null && iq.getType().equals((Object)IQ.Type.set)) {
            IQ ack;
            result = ack = IQ.createResultIQ((IQ)iq);
        }
        return result;
    }

    public int hashCode() {
        return Jingle.getSessionHash(this.getSid(), this.getInitiator());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JingleSession other = (JingleSession)obj;
        if (this.initiator == null) {
            if (other.initiator != null) {
                return false;
            }
        } else if (!this.initiator.equals((CharSequence)other.initiator)) {
            // empty if block
        }
        if (this.responder == null ? other.responder != null : !this.responder.equals((CharSequence)other.responder)) {
            return false;
        }
        return !(this.sid == null ? other.sid != null : !this.sid.equals(other.sid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInstanceFor(XMPPConnection connection) {
        HashMap<XMPPConnection, JingleSession> hashMap = sessions;
        synchronized (hashMap) {
            sessions.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInstance() {
        HashMap<XMPPConnection, JingleSession> hashMap = sessions;
        synchronized (hashMap) {
            sessions.put(this.getConnection(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized JingleSession getInstanceFor(XMPPConnection con) {
        if (con == null) {
            throw new IllegalArgumentException("XMPPConnection cannot be null");
        }
        JingleSession result = null;
        HashMap<XMPPConnection, JingleSession> hashMap = sessions;
        synchronized (hashMap) {
            if (sessions.containsKey(con)) {
                result = sessions.get(con);
            }
        }
        return result;
    }

    private void installConnectionListeners(final XMPPConnection connection) {
        if (connection != null) {
            this.connectionListener = new AbstractConnectionClosedListener(){

                public void connectionTerminated() {
                    JingleSession.this.unregisterInstanceFor(connection);
                }
            };
            connection.addConnectionListener(this.connectionListener);
        }
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            this.getConnection().removeConnectionListener(this.connectionListener);
            LOGGER.fine("JINGLE SESSION: REMOVE CONNECTION LISTENER");
        }
    }

    protected void removeAsyncPacketListener() {
        if (this.packetListener != null) {
            this.getConnection().removeAsyncStanzaListener(this.packetListener);
            LOGGER.fine("JINGLE SESSION: REMOVE PACKET LISTENER");
        }
    }

    protected void updatePacketListener() {
        this.removeAsyncPacketListener();
        LOGGER.fine("UpdatePacketListener");
        this.packetListener = new StanzaListener(){

            public void processStanza(Stanza packet) {
                try {
                    JingleSession.this.receivePacketAndRespond((IQ)packet);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "exception", e);
                }
            }
        };
        this.packetFilter = new StanzaFilter(){

            public boolean accept(Stanza packet) {
                if (packet instanceof IQ) {
                    Jid other;
                    IQ iq = (IQ)packet;
                    EntityFullJid me = JingleSession.this.getConnection().getUser();
                    if (!iq.getTo().equals((CharSequence)me)) {
                        return false;
                    }
                    Jid jid = other = JingleSession.this.getResponder().equals((CharSequence)me) ? JingleSession.this.getInitiator() : JingleSession.this.getResponder();
                    if (iq.getFrom() == null || !iq.getFrom().equals((CharSequence)(other == null ? "" : other))) {
                        return false;
                    }
                    if (iq instanceof Jingle) {
                        Jingle jin = (Jingle)iq;
                        String sid = jin.getSid();
                        if (sid == null || !sid.equals(JingleSession.this.getSid())) {
                            LOGGER.fine("Ignored Jingle(SID) " + sid + "|" + JingleSession.this.getSid() + " :" + iq.toXML());
                            return false;
                        }
                        Jid ini = jin.getInitiator();
                        if (!ini.equals((CharSequence)JingleSession.this.getInitiator())) {
                            LOGGER.fine("Ignored Jingle(INI): " + iq.toXML());
                            return false;
                        }
                    } else {
                        if (iq.getType().equals((Object)IQ.Type.set)) {
                            LOGGER.fine("Ignored Jingle(TYPE): " + iq.toXML());
                            return false;
                        }
                        if (iq.getType().equals((Object)IQ.Type.get)) {
                            LOGGER.fine("Ignored Jingle(TYPE): " + iq.toXML());
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        this.getConnection().addAsyncStanzaListener(this.packetListener, this.packetFilter);
    }

    public void addMediaListener(JingleMediaListener li) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getMediaNegotiator() == null) continue;
            contentNegotiator.getMediaNegotiator().addListener(li);
        }
    }

    public void removeMediaListener(JingleMediaListener li) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getMediaNegotiator() == null) continue;
            contentNegotiator.getMediaNegotiator().removeListener(li);
        }
    }

    public void addTransportListener(JingleTransportListener li) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getTransportNegotiator() == null) continue;
            contentNegotiator.getTransportNegotiator().addListener(li);
        }
    }

    public void removeTransportListener(JingleTransportListener li) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            if (contentNegotiator.getTransportNegotiator() == null) continue;
            contentNegotiator.getTransportNegotiator().removeListener(li);
        }
    }

    public void setupListeners() {
        JingleMediaListener jingleMediaListener = new JingleMediaListener(){

            @Override
            public void mediaClosed(PayloadType cand) {
            }

            @Override
            public void mediaEstablished(PayloadType pt) throws SmackException.NotConnectedException, InterruptedException {
                if (JingleSession.this.isFullyEstablished()) {
                    Jingle jout = new Jingle(JingleActionEnum.SESSION_ACCEPT);
                    for (ContentNegotiator contentNegotiator : JingleSession.this.contentNegotiators) {
                        if (contentNegotiator.getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) continue;
                        jout.addContent(contentNegotiator.getJingleContent());
                    }
                    JingleSession.this.addExpectedId(jout.getStanzaId());
                    JingleSession.this.sendStanza(jout);
                }
            }
        };
        JingleTransportListener jingleTransportListener = new JingleTransportListener(){

            @Override
            public void transportEstablished(TransportCandidate local, TransportCandidate remote) throws SmackException.NotConnectedException, InterruptedException {
                if (JingleSession.this.isFullyEstablished()) {
                    JingleSession.this.setSessionState(JingleSessionStateActive.getInstance());
                    for (ContentNegotiator contentNegotiator : JingleSession.this.contentNegotiators) {
                        if (contentNegotiator.getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) continue;
                        contentNegotiator.triggerContentEstablished();
                    }
                    if (JingleSession.this.getSessionState().equals(JingleSessionStatePending.getInstance())) {
                        Jingle jout = new Jingle(JingleActionEnum.SESSION_ACCEPT);
                        for (ContentNegotiator contentNegotiator : JingleSession.this.contentNegotiators) {
                            if (contentNegotiator.getNegotiatorState() != JingleNegotiatorState.SUCCEEDED) continue;
                            jout.addContent(contentNegotiator.getJingleContent());
                        }
                        JingleSession.this.addExpectedId(jout.getStanzaId());
                        JingleSession.this.sendStanza(jout);
                    }
                }
            }

            @Override
            public void transportClosed(TransportCandidate cand) {
            }

            @Override
            public void transportClosedOnError(XMPPException e) {
            }
        };
        this.addMediaListener(jingleMediaListener);
        this.addTransportListener(jingleTransportListener);
    }

    protected void triggerSessionClosed(String reason) {
        List<JingleListener> listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionClosed(reason, this);
        }
        this.close();
    }

    protected void triggerSessionClosedOnError(XMPPException exc) {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            contentNegotiator.stopJingleMediaSession();
            for (TransportCandidate candidate : contentNegotiator.getTransportNegotiator().getOfferedCandidates()) {
                candidate.removeCandidateEcho();
            }
        }
        List<JingleListener> listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionClosedOnError(exc, this);
        }
        this.close();
    }

    protected void triggerMediaReceived(String participant) {
        List<JingleListener> listeners = this.getListenersList();
        for (JingleListener li : listeners) {
            if (!(li instanceof JingleSessionListener)) continue;
            JingleSessionListener sli = (JingleSessionListener)li;
            sli.sessionMediaReceived(this, participant);
        }
    }

    public void terminate() throws XMPPException, SmackException.NotConnectedException, InterruptedException {
        this.terminate("Closed Locally");
    }

    public void terminate(String reason) throws XMPPException, SmackException.NotConnectedException, InterruptedException {
        if (this.isClosed()) {
            return;
        }
        LOGGER.fine("Terminate " + reason);
        Jingle jout = new Jingle(JingleActionEnum.SESSION_TERMINATE);
        jout.setType(IQ.Type.set);
        this.sendStanza(jout);
        this.triggerSessionClosed(reason);
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.setSessionState(JingleSessionStateEnded.getInstance());
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            contentNegotiator.stopJingleMediaSession();
            for (TransportCandidate candidate : contentNegotiator.getTransportNegotiator().getOfferedCandidates()) {
                candidate.removeCandidateEcho();
            }
            contentNegotiator.close();
        }
        this.removeAsyncPacketListener();
        this.removeConnectionListener();
        this.getConnection().removeConnectionListener(this.connectionListener);
        LOGGER.fine("Negotiation Closed: " + this.getConnection().getUser() + " " + this.sid);
        super.close();
    }

    public boolean isClosed() {
        return this.getSessionState().equals(JingleSessionStateEnded.getInstance());
    }

    public IQ createJingleError(IQ iq, JingleError jingleError) {
        ErrorIQ errorPacket = null;
        if (jingleError != null) {
            StanzaError.Builder builder = StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.undefined_condition);
            builder.addExtension((ExtensionElement)jingleError);
            errorPacket = IQ.createErrorResponse((IQ)iq, (StanzaError.Builder)builder);
            LOGGER.severe("Error sent: " + errorPacket.toXML());
        }
        return errorPacket;
    }

    @Override
    public void mediaReceived(String participant) {
        this.triggerMediaReceived(participant);
    }

    public void startOutgoing() throws IllegalStateException, SmackException, InterruptedException {
        this.updatePacketListener();
        this.setSessionState(JingleSessionStatePending.getInstance());
        Jingle jingle = new Jingle(JingleActionEnum.SESSION_INITIATE);
        for (JingleMediaManager mediaManager : this.getMediaManagers()) {
            ContentNegotiator contentNeg = new ContentNegotiator(this, "initiator", mediaManager.getName());
            contentNeg.setMediaNegotiator(new MediaNegotiator(this, mediaManager, mediaManager.getPayloads(), contentNeg));
            JingleTransportManager transportManager = mediaManager.getTransportManager();
            TransportResolver resolver = null;
            try {
                resolver = transportManager.getResolver(this);
            }
            catch (XMPPException e) {
                LOGGER.log(Level.WARNING, "exception", e);
            }
            if (resolver.getType().equals((Object)TransportResolver.Type.rawupd)) {
                contentNeg.setTransportNegotiator(new TransportNegotiator.RawUdp(this, resolver, contentNeg));
            }
            if (resolver.getType().equals((Object)TransportResolver.Type.ice)) {
                contentNeg.setTransportNegotiator(new TransportNegotiator.Ice(this, resolver, contentNeg));
            }
            this.addContentNegotiator(contentNeg);
        }
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            jingle.addContent(contentNegotiator.getJingleContent());
        }
        this.sessionInitPacketID = jingle.getStanzaId();
        this.sendStanza(jingle);
        this.setupListeners();
    }

    public void startIncoming() {
    }

    @Override
    protected void doStart() {
    }

    private void startNegotiators() {
        for (ContentNegotiator contentNegotiator : this.contentNegotiators) {
            TransportNegotiator transNeg = contentNegotiator.getTransportNegotiator();
            transNeg.start();
        }
    }

    public void addJingleMediaSession(String mediaManagerName, JingleMediaSession mediaSession) {
        this.mediaSessionMap.put(mediaManagerName, mediaSession);
    }

    public JingleMediaSession getMediaSession(String mediaManagerName) {
        return this.mediaSessionMap.get(mediaManagerName);
    }
}

