/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.mediaimpl;

import com.sun.media.ExclusiveUse;
import com.sun.media.util.Registry;
import java.awt.Frame;
import java.util.Vector;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.format.AudioFormat;

public class JMFInit
extends Frame
implements Runnable {
    private static final long serialVersionUID = 6476412003260641680L;
    private static final Logger LOGGER = Logger.getLogger(JMFInit.class.getName());
    private String tempDir = "/tmp";
    private boolean done = false;
    private String userHome;
    private boolean visible = false;

    public JMFInit(String[] args, boolean visible) {
        super("Initializing JMF...");
        this.visible = visible;
        Registry.set((String)"secure.allowCaptureFromApplets", (Object)true);
        Registry.set((String)"secure.allowSaveFileFromApplets", (Object)true);
        this.updateTemp(args);
        try {
            Registry.commit();
        }
        catch (Exception e) {
            this.message("Failed to commit to JMFRegistry!");
        }
        Thread detectThread = new Thread(this);
        detectThread.run();
    }

    @Override
    public void run() {
        this.detectDirectAudio();
        this.detectS8DirectAudio();
        this.detectCaptureDevices();
        this.done = true;
    }

    private void updateTemp(String[] args) {
        if (args != null && args.length > 0) {
            this.tempDir = args[0];
            this.message("Setting cache directory to " + this.tempDir);
            try {
                Registry.set((String)"secure.cacheDir", (Object)this.tempDir);
                Registry.commit();
                this.message("Updated registry");
            }
            catch (Exception e) {
                this.message("Couldn't update registry!");
            }
        }
    }

    private void detectCaptureDevices() {
        this.message("Looking for Audio capturer");
        try {
            Class<?> dsauto = Class.forName("DirectSoundAuto");
            dsauto.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.message("Finished detecting DirectSound capturer");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable td) {
            // empty catch block
        }
        try {
            Class<?> jsauto = Class.forName("JavaSoundAuto");
            jsauto.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.message("Finished detecting javasound capturer");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.message("JavaSound capturer detection failed!");
        }
    }

    private void detectDirectAudio() {
        int plType = 4;
        String dar = "com.sun.media.renderer.audio.DirectAudioRenderer";
        try {
            Class<?> cls = Class.forName("VFWAuto");
            cls = Class.forName("com.sun.media.protocol.dsound.DSound");
            cls = Class.forName(dar);
            Renderer rend = (Renderer)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                AudioFormat af = new AudioFormat("LINEAR", 44100.0, 16, 2);
                rend.setInputFormat((Format)af);
                rend.open();
                Format[] inputFormats = rend.getSupportedInputFormats();
                PlugInManager.addPlugIn((String)dar, (Format[])inputFormats, (Format[])new Format[0], (int)plType);
                Vector rendList = PlugInManager.getPlugInList(null, null, (int)plType);
                int listSize = rendList.size();
                if (((String)rendList.elementAt(listSize - 1)).equals(dar)) {
                    rendList.removeElementAt(listSize - 1);
                    rendList.insertElementAt(dar, 0);
                    PlugInManager.setPlugInList((Vector)rendList, (int)plType);
                    PlugInManager.commit();
                }
                rend.close();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void detectS8DirectAudio() {
        int plType = 4;
        String dar = "com.sun.media.renderer.audio.DirectAudioRenderer";
        try {
            Class<?> cls = Class.forName("SunVideoAuto");
            cls = Class.forName(dar);
            Renderer rend = (Renderer)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (rend instanceof ExclusiveUse && !((ExclusiveUse)rend).isExclusive()) {
                Vector rendList = PlugInManager.getPlugInList(null, null, (int)plType);
                int listSize = rendList.size();
                boolean found = false;
                for (int i = 0; i < listSize; ++i) {
                    String rname = (String)rendList.elementAt(i);
                    if (!rname.equals(dar)) continue;
                    found = true;
                    rendList.removeElementAt(i);
                    break;
                }
                if (found) {
                    rendList.insertElementAt(dar, 0);
                    PlugInManager.setPlugInList((Vector)rendList, (int)plType);
                    PlugInManager.commit();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void message(String mesg) {
        LOGGER.fine(mesg);
    }

    public static void start(boolean visible) {
        new JMFInit(null, visible);
    }
}

