/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.nat;

import de.javawi.jstun.test.BindingLifetimeTest;
import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.test.DiscoveryTest;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;
import org.jivesoftware.smackx.jingleold.nat.TransportResolver;

public class STUNResolver
extends TransportResolver {
    private static final Logger LOGGER = Logger.getLogger(STUNResolver.class.getName());
    public static final String STUNSERVERS_FILENAME = "META-INF/stun-config.xml";
    protected STUNService currentServer = new STUNService();
    protected Thread resolverThread;
    protected int defaultPort = 0;
    protected String resolvedPublicIP;
    protected String resolvedLocalIP;

    public STUNResolver() {
    }

    public STUNResolver(int defaultPort) {
        this();
        this.defaultPort = defaultPort;
    }

    @Override
    public boolean isResolving() {
        return super.isResolving() && this.resolverThread != null;
    }

    public void setSTUNService(String ip, int port) {
        this.currentServer = new STUNService(ip, port);
    }

    public String getCurrentServerName() {
        if (!this.currentServer.isNull()) {
            return this.currentServer.getHostname();
        }
        return null;
    }

    public int getCurrentServerPort() {
        if (!this.currentServer.isNull()) {
            return this.currentServer.getPort();
        }
        return 0;
    }

    public ArrayList<STUNService> loadSTUNServers(InputStream stunConfigStream) {
        ArrayList<STUNService> serversList = new ArrayList<STUNService>();
        try {
            XmlPullParser parser = PacketParserUtils.getParserFor((InputStream)stunConfigStream);
            XmlPullParser.Event eventType = parser.getEventType();
            do {
                if (eventType != XmlPullParser.Event.START_ELEMENT || !parser.getName().equals("stunServer")) continue;
                String serverName = null;
                int serverPort = -1;
                parser.next();
                parser.next();
                serverName = parser.nextText();
                parser.next();
                parser.next();
                try {
                    serverPort = Integer.parseInt(parser.nextText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (serverName == null || serverPort == -1) continue;
                STUNService service = new STUNService(serverName, serverPort);
                serversList.add(service);
            } while ((eventType = parser.next()) != XmlPullParser.Event.END_DOCUMENT);
        }
        catch (XmlPullParserException e) {
            LOGGER.log(Level.SEVERE, "Exception", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Exception", e);
        }
        this.currentServer = this.bestSTUNServer(serversList);
        return serversList;
    }

    public ArrayList<STUNService> loadSTUNServers() {
        ArrayList<STUNService> serversList = new ArrayList<STUNService>();
        try {
            ClassLoader[] classLoaders = new ClassLoader[]{new STUNResolver(){}.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader()};
            for (int i = 0; i < classLoaders.length; ++i) {
                Enumeration<URL> stunConfigEnum = classLoaders[i].getResources(STUNSERVERS_FILENAME);
                while (stunConfigEnum.hasMoreElements() && serversList.isEmpty()) {
                    URL url = stunConfigEnum.nextElement();
                    InputStream stunConfigStream = url.openStream();
                    serversList.addAll(this.loadSTUNServers(stunConfigStream));
                    stunConfigStream.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception", e);
        }
        return serversList;
    }

    private STUNService bestSTUNServer(ArrayList<STUNService> listServers) {
        if (listServers.isEmpty()) {
            return null;
        }
        return listServers.get(0);
    }

    @Override
    public synchronized void resolve(JingleSession session) throws XMPPException, SmackException.NotConnectedException, InterruptedException {
        this.setResolveInit();
        this.clearCandidates();
        TransportCandidate.Fixed candidate = new TransportCandidate.Fixed(this.resolvedPublicIP, this.getFreePort());
        candidate.setLocalIp(this.resolvedLocalIP);
        LOGGER.fine("RESOLVING : " + this.resolvedPublicIP + ":" + candidate.getPort());
        this.addCandidate(candidate);
        this.setResolveEnd();
    }

    @Override
    public void initialize() throws XMPPException {
        LOGGER.fine("Initialized");
        if (!this.isResolving() && !this.isResolved()) {
            if (this.currentServer.isNull()) {
                this.loadSTUNServers();
            }
            if (!this.currentServer.isNull()) {
                this.clearCandidates();
                this.resolverThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                            while (ifaces.hasMoreElements()) {
                                NetworkInterface iface = ifaces.nextElement();
                                Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
                                while (iaddresses.hasMoreElements()) {
                                    InetAddress iaddress = iaddresses.nextElement();
                                    if (iaddress.isLoopbackAddress() || iaddress.isLinkLocalAddress()) continue;
                                    String candAddress = null;
                                    int candPort = -1;
                                    DiscoveryTest test = new DiscoveryTest(iaddress, STUNResolver.this.currentServer.getHostname(), STUNResolver.this.currentServer.getPort());
                                    try {
                                        DiscoveryInfo di = test.test();
                                        candAddress = di.getPublicIP() != null ? di.getPublicIP().getHostAddress() : null;
                                        candPort = STUNResolver.this.defaultPort == 0 ? STUNResolver.this.getFreePort() : STUNResolver.this.defaultPort;
                                        if (candAddress == null || candPort < 0) continue;
                                        TransportCandidate.Fixed candidate = new TransportCandidate.Fixed(candAddress, candPort);
                                        candidate.setLocalIp(iaddress.getHostAddress() != null ? iaddress.getHostAddress() : iaddress.getHostName());
                                        STUNResolver.this.addCandidate(candidate);
                                        STUNResolver.this.resolvedPublicIP = candidate.getIp();
                                        STUNResolver.this.resolvedLocalIP = candidate.getLocalIp();
                                        return;
                                    }
                                    catch (Exception e) {
                                        LOGGER.log(Level.SEVERE, "Exception", e);
                                    }
                                }
                            }
                        }
                        catch (SocketException e) {
                            LOGGER.log(Level.SEVERE, "Exception", e);
                        }
                        finally {
                            STUNResolver.this.setInitialized();
                        }
                    }
                }, "Waiting for all the transport candidates checks...");
                this.resolverThread.setName("STUN resolver");
                this.resolverThread.start();
            } else {
                throw new IllegalStateException("No valid STUN server found.");
            }
        }
    }

    @Override
    public synchronized void cancel() throws XMPPException {
        if (this.isResolving()) {
            this.resolverThread.interrupt();
            this.setResolveEnd();
        }
    }

    @Override
    public synchronized void clear() throws XMPPException {
        this.defaultPort = 0;
        super.clear();
    }

    protected static class STUNService {
        private String hostname;
        private int port;

        public STUNService(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public STUNService() {
            this(null, -1);
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean isNull() {
            if (this.hostname == null) {
                return true;
            }
            if (this.hostname.length() == 0) {
                return true;
            }
            return this.port < 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean checkBinding() {
            boolean result = false;
            try {
                BindingLifetimeTest binding = new BindingLifetimeTest(this.hostname, this.port);
                binding.test();
                do {
                    Thread.sleep(5000L);
                    if (binding.getLifetime() == -1) return result;
                } while (!binding.isCompleted());
                return true;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception in checkBinding", e);
            }
            return result;
        }
    }
}

