/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.packet.JingleDescription;

public abstract class JingleDescriptionProvider
extends ExtensionElementProvider<JingleDescription> {
    protected PayloadType parsePayload(XmlPullParser parser) {
        int ptId = 0;
        int ptChannels = 0;
        try {
            ptId = Integer.parseInt(parser.getAttributeValue("", "id"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String ptName = parser.getAttributeValue("", "name");
        try {
            ptChannels = Integer.parseInt(parser.getAttributeValue("", "channels"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PayloadType(ptId, ptName, ptChannels);
    }

    public JingleDescription parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        boolean done = false;
        JingleDescription desc = this.getInstance();
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            String name = parser.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (name.equals("payload-type")) {
                    desc.addPayloadType(this.parsePayload(parser));
                    continue;
                }
                throw new IOException("Unknow element \"" + name + "\" in content.");
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !name.equals("description")) continue;
            done = true;
        }
        return desc;
    }

    protected abstract JingleDescription getInstance();

    public static class Audio
    extends JingleDescriptionProvider {
        @Override
        public PayloadType parsePayload(XmlPullParser parser) {
            PayloadType pte = super.parsePayload(parser);
            PayloadType.Audio pt = new PayloadType.Audio(pte);
            int ptClockRate = 0;
            try {
                ptClockRate = Integer.parseInt(parser.getAttributeValue("", "clockrate"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            pt.setClockRate(ptClockRate);
            return pt;
        }

        @Override
        protected JingleDescription getInstance() {
            return new JingleDescription.Audio();
        }
    }
}

