/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jingleold.nat.ICECandidate;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;
import org.jivesoftware.smackx.jingleold.packet.JingleTransport;

public abstract class JingleTransportProvider
extends ExtensionElementProvider<JingleTransport> {
    protected JingleTransport getInstance() {
        return new JingleTransport();
    }

    public JingleTransport parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        JingleTransport trans = this.getInstance();
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                String name = parser.getName();
                if (name.equals("candidate")) {
                    JingleTransport.JingleTransportCandidate jtc = this.parseCandidate(parser);
                    if (jtc == null) continue;
                    trans.addCandidate(jtc);
                    continue;
                }
                throw new IOException("Unknown tag \"" + name + "\" in transport element.");
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
        }
        return trans;
    }

    protected abstract JingleTransport.JingleTransportCandidate parseCandidate(XmlPullParser var1);

    public static class RawUdp
    extends JingleTransportProvider {
        @Override
        protected JingleTransport getInstance() {
            return new JingleTransport.RawUdp();
        }

        @Override
        protected JingleTransport.JingleTransportCandidate parseCandidate(XmlPullParser parser) {
            TransportCandidate.Fixed mt = new TransportCandidate.Fixed();
            String generation = parser.getAttributeValue("", "generation");
            String ip = parser.getAttributeValue("", "ip");
            String name = parser.getAttributeValue("", "name");
            String port = parser.getAttributeValue("", "port");
            if (generation != null) {
                try {
                    mt.setGeneration(Integer.parseInt(generation));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ip != null) {
                mt.setIp(ip);
            }
            if (name != null) {
                mt.setName(name);
            }
            if (port != null) {
                try {
                    mt.setPort(Integer.parseInt(port));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new JingleTransport.RawUdp.Candidate(mt);
        }
    }

    public static class Ice
    extends JingleTransportProvider {
        @Override
        protected JingleTransport getInstance() {
            return new JingleTransport.Ice();
        }

        @Override
        protected JingleTransport.JingleTransportCandidate parseCandidate(XmlPullParser parser) {
            ICECandidate mt = new ICECandidate();
            String channel = parser.getAttributeValue("", "channel");
            String generation = parser.getAttributeValue("", "generation");
            String ip = parser.getAttributeValue("", "ip");
            String name = parser.getAttributeValue("", "name");
            String network = parser.getAttributeValue("", "network");
            String username = parser.getAttributeValue("", "username");
            String password = parser.getAttributeValue("", "password");
            String port = parser.getAttributeValue("", "port");
            String preference = parser.getAttributeValue("", "preference");
            String proto = parser.getAttributeValue("", "proto");
            String type = parser.getAttributeValue("", "type");
            if (channel != null) {
                mt.setChannel(new TransportCandidate.Channel(channel));
            }
            if (generation != null) {
                try {
                    mt.setGeneration(Integer.parseInt(generation));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ip == null) {
                return null;
            }
            mt.setIp(ip);
            if (name != null) {
                mt.setName(name);
            }
            if (network != null) {
                try {
                    mt.setNetwork(Integer.parseInt(network));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (username != null) {
                mt.setUsername(username);
            }
            if (password != null) {
                mt.setPassword(password);
            }
            if (port != null) {
                try {
                    mt.setPort(Integer.parseInt(port));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (preference != null) {
                try {
                    mt.setPreference(Integer.parseInt(preference));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (proto != null) {
                mt.setProto(new TransportCandidate.Protocol(proto));
            }
            if (type != null) {
                mt.setType(ICECandidate.Type.valueOf(type));
            }
            return new JingleTransport.Ice.Candidate(mt);
        }
    }
}

