/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.mediaimpl.jmf;

import com.ibm.media.codec.audio.rc.RCModule;
import com.ibm.media.codec.audio.ulaw.JavaEncoder;
import com.sun.media.codec.audio.ulaw.Packetizer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Codec;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoProcessorException;
import javax.media.Processor;
import javax.media.UnsupportedPlugInException;
import javax.media.control.BufferControl;
import javax.media.control.PacketSizeControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.InvalidSessionAddressException;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SendStream;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionListener;
import org.jivesoftware.smackx.jingleold.media.JingleMediaSession;
import org.jivesoftware.smackx.jingleold.mediaimpl.jmf.AudioReceiver;

public class AudioChannel {
    private static final Logger LOGGER = Logger.getLogger(AudioChannel.class.getName());
    private MediaLocator locator;
    private String localIpAddress;
    private String remoteIpAddress;
    private int localPort;
    private int portBase;
    private Format format;
    private Processor processor = null;
    private RTPManager[] rtpMgrs;
    private DataSource dataOutput = null;
    private AudioReceiver audioReceiver;
    private List<SendStream> sendStreams = new ArrayList<SendStream>();
    private JingleMediaSession jingleMediaSession;
    private boolean started = false;
    private Integer stateLock = 0;
    private boolean failed = false;

    public AudioChannel(MediaLocator locator, String localIpAddress, String remoteIpAddress, int localPort, int remotePort, Format format, JingleMediaSession jingleMediaSession) {
        this.locator = locator;
        this.localIpAddress = localIpAddress;
        this.remoteIpAddress = remoteIpAddress;
        this.localPort = localPort;
        this.portBase = remotePort;
        this.format = format;
        this.jingleMediaSession = jingleMediaSession;
    }

    public synchronized String start() {
        if (this.started) {
            return null;
        }
        String result = this.createProcessor();
        if (result != null) {
            this.started = false;
        }
        if ((result = this.createTransmitter()) != null) {
            this.processor.close();
            this.processor = null;
            this.started = false;
        } else {
            this.started = true;
        }
        this.processor.start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.started) {
            return;
        }
        AudioChannel audioChannel = this;
        synchronized (audioChannel) {
            try {
                this.started = false;
                if (this.processor != null) {
                    this.processor.stop();
                    this.processor = null;
                    for (RTPManager rtpMgr : this.rtpMgrs) {
                        rtpMgr.removeReceiveStreamListener((ReceiveStreamListener)this.audioReceiver);
                        rtpMgr.removeSessionListener((SessionListener)this.audioReceiver);
                        rtpMgr.removeTargets("Session ended.");
                        rtpMgr.dispose();
                    }
                    this.sendStreams.clear();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "exception", e);
            }
        }
    }

    private String createProcessor() {
        DataSource ds;
        if (this.locator == null) {
            return "Locator is null";
        }
        try {
            ds = Manager.createDataSource((MediaLocator)this.locator);
        }
        catch (Exception e) {
            try {
                ds = Manager.createDataSource((MediaLocator)new MediaLocator("javasound://"));
            }
            catch (Exception ee) {
                return "Couldn't create DataSource";
            }
        }
        try {
            this.processor = Manager.createProcessor((DataSource)ds);
        }
        catch (NoProcessorException npe) {
            LOGGER.log(Level.WARNING, "exception", npe);
            return "Couldn't create processor";
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "exception", ioe);
            return "IOException creating processor";
        }
        boolean result = this.waitForState(this.processor, 180);
        if (!result) {
            return "Couldn't configure processor";
        }
        TrackControl[] tracks = this.processor.getTrackControls();
        if (tracks == null || tracks.length < 1) {
            return "Couldn't find tracks in processor";
        }
        ContentDescriptor cd = new ContentDescriptor("raw.rtp");
        this.processor.setContentDescriptor(cd);
        Format chosen = null;
        boolean atLeastOneTrack = false;
        for (int i = 0; i < tracks.length; ++i) {
            if (!tracks[i].isEnabled()) continue;
            Format[] supported = tracks[i].getSupportedFormats();
            if (supported.length > 0) {
                for (Format format : supported) {
                    if (!(format instanceof AudioFormat) || !this.format.matches(format)) continue;
                    chosen = format;
                }
                if (chosen != null) {
                    tracks[i].setFormat(chosen);
                    LOGGER.severe("Track " + i + " is set to transmit as: " + chosen);
                    if (tracks[i].getFormat() instanceof AudioFormat) {
                        int packetRate = 20;
                        PacketSizeControl pktCtrl = (PacketSizeControl)this.processor.getControl(PacketSizeControl.class.getName());
                        if (pktCtrl != null) {
                            try {
                                pktCtrl.setPacketSize(AudioChannel.getPacketSize(tracks[i].getFormat(), packetRate));
                            }
                            catch (IllegalArgumentException e) {
                                pktCtrl.setPacketSize(80);
                            }
                        }
                        if (tracks[i].getFormat().getEncoding().equals("ULAW/rtp")) {
                            Codec[] codec = new Codec[]{new RCModule(), new JavaEncoder(), new Packetizer()};
                            ((Packetizer)codec[2]).setPacketSize(160);
                            try {
                                tracks[i].setCodecChain(codec);
                            }
                            catch (UnsupportedPlugInException e) {
                                LOGGER.log(Level.WARNING, "exception", e);
                            }
                        }
                    }
                    atLeastOneTrack = true;
                    continue;
                }
                tracks[i].setEnabled(false);
                continue;
            }
            tracks[i].setEnabled(false);
        }
        if (!atLeastOneTrack) {
            return "Couldn't set any of the tracks to a valid RTP format";
        }
        result = this.waitForState(this.processor, 300);
        if (!result) {
            return "Couldn't realize processor";
        }
        this.dataOutput = this.processor.getDataOutput();
        return null;
    }

    private static int getPacketSize(Format codecFormat, int milliseconds) throws IllegalArgumentException {
        String encoding = codecFormat.getEncoding();
        if (encoding.equalsIgnoreCase("gsm") || encoding.equalsIgnoreCase("gsm/rtp")) {
            return milliseconds * 4;
        }
        if (encoding.equalsIgnoreCase("ULAW") || encoding.equalsIgnoreCase("ULAW/rtp")) {
            return milliseconds * 8;
        }
        throw new IllegalArgumentException("Unknown codec type");
    }

    private String createTransmitter() {
        PushBufferDataSource pbds = (PushBufferDataSource)this.dataOutput;
        PushBufferStream[] pbss = pbds.getStreams();
        this.rtpMgrs = new RTPManager[pbss.length];
        this.audioReceiver = new AudioReceiver(this, this.jingleMediaSession);
        for (int i = 0; i < pbss.length; ++i) {
            try {
                this.rtpMgrs[i] = RTPManager.newInstance();
                int port = this.portBase + 2 * i;
                InetAddress ipAddr = InetAddress.getByName(this.remoteIpAddress);
                SessionAddress localAddr = new SessionAddress(InetAddress.getByName(this.localIpAddress), this.localPort);
                SessionAddress destAddr = new SessionAddress(ipAddr, port);
                this.rtpMgrs[i].addReceiveStreamListener((ReceiveStreamListener)this.audioReceiver);
                this.rtpMgrs[i].addSessionListener((SessionListener)this.audioReceiver);
                BufferControl bc = (BufferControl)this.rtpMgrs[i].getControl("javax.media.control.BufferControl");
                if (bc != null) {
                    int bl = 160;
                    bc.setBufferLength((long)bl);
                }
                try {
                    this.rtpMgrs[i].initialize(localAddr);
                }
                catch (InvalidSessionAddressException e) {
                    SessionAddress sessAddr = new SessionAddress();
                    localAddr = new SessionAddress(sessAddr.getDataAddress(), this.localPort);
                    this.rtpMgrs[i].initialize(localAddr);
                }
                this.rtpMgrs[i].addTarget(destAddr);
                LOGGER.severe("Created RTP session at " + this.localPort + " to: " + this.remoteIpAddress + " " + port);
                SendStream sendStream = this.rtpMgrs[i].createSendStream(this.dataOutput, i);
                this.sendStreams.add(sendStream);
                sendStream.start();
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "exception", e);
                return e.getMessage();
            }
        }
        return null;
    }

    public void setTrasmit(boolean active) {
        for (SendStream sendStream : this.sendStreams) {
            try {
                if (active) {
                    sendStream.start();
                    LOGGER.fine("START");
                    continue;
                }
                sendStream.stop();
                LOGGER.fine("STOP");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "exception", e);
            }
        }
    }

    Integer getStateLock() {
        return this.stateLock;
    }

    void setFailed() {
        this.failed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean waitForState(Processor p, int state) {
        p.addControllerListener((ControllerListener)new StateListener());
        this.failed = false;
        if (state == 180) {
            p.configure();
        } else if (state == 300) {
            p.realize();
        }
        while (p.getState() < state && !this.failed) {
            Integer n = this.getStateLock();
            synchronized (n) {
                try {
                    this.getStateLock().wait();
                }
                catch (InterruptedException ie) {
                    return false;
                }
            }
        }
        return !this.failed;
    }

    public static void main(String[] args) {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            AudioChannel audioChannel0 = new AudioChannel(new MediaLocator("javasound://8000"), localhost.getHostAddress(), localhost.getHostAddress(), 7002, 7020, (Format)new AudioFormat("gsm/rtp"), null);
            AudioChannel audioChannel1 = new AudioChannel(new MediaLocator("javasound://8000"), localhost.getHostAddress(), localhost.getHostAddress(), 7020, 7002, (Format)new AudioFormat("gsm/rtp"), null);
            audioChannel0.start();
            audioChannel1.start();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "exception", e);
            }
            audioChannel0.setTrasmit(false);
            audioChannel1.setTrasmit(false);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "exception", e);
            }
            audioChannel0.setTrasmit(true);
            audioChannel1.setTrasmit(true);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "exception", e);
            }
            audioChannel0.stop();
            audioChannel1.stop();
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.WARNING, "exception", e);
        }
    }

    class StateListener
    implements ControllerListener {
        StateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent) {
                AudioChannel.this.setFailed();
            }
            if (ce != null) {
                Integer n = AudioChannel.this.getStateLock();
                synchronized (n) {
                    AudioChannel.this.getStateLock().notifyAll();
                }
            }
        }
    }
}

