/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.nat;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smackx.jingleold.nat.ResultListener;
import org.jivesoftware.smackx.jingleold.nat.TestResult;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;

public final class ICECandidate
extends TransportCandidate
implements Comparable<ICECandidate> {
    private static final Logger LOGGER = Logger.getLogger(ICECandidate.class.getName());
    private String id;
    private String username;
    private int preference;
    private TransportCandidate.Protocol proto;
    private TransportCandidate.Channel channel;
    private int network;
    private Type type;

    public ICECandidate() {
    }

    public ICECandidate(String ip, int generation, int network, String password, int port, String username, int preference, Type type) {
        super(ip, port, generation);
        this.proto = TransportCandidate.Protocol.UDP;
        this.channel = TransportCandidate.Channel.MYRTPVOICE;
        this.network = network;
        this.password = password;
        this.username = username;
        this.preference = preference;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransportCandidate.Protocol getProto() {
        return this.proto;
    }

    public void setProto(TransportCandidate.Protocol proto) {
        this.proto = proto;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int network) {
        this.network = network;
    }

    public String getUsername() {
        return this.username;
    }

    public TransportCandidate.Channel getChannel() {
        return this.channel;
    }

    public void setChannel(TransportCandidate.Channel channel) {
        this.channel = channel;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getPreference() {
        return this.preference;
    }

    public void setPreference(int preference) {
        this.preference = preference;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void check(final List<TransportCandidate> localCandidates) {
        final ICECandidate checkingCandidate = this;
        Thread checkThread = new Thread(new Runnable(){

            @Override
            public void run() {
                TransportCandidate.CandidateEcho echo;
                final TestResult result = new TestResult();
                if (ICECandidate.this.getType().equals((Object)Type.relay)) {
                    ICECandidate.this.triggerCandidateChecked(false);
                    return;
                }
                ResultListener resultListener = new ResultListener(){

                    @Override
                    public void testFinished(TestResult testResult, TransportCandidate candidate) {
                        if (testResult.isReachable() && checkingCandidate.equals(candidate)) {
                            result.setResult(true);
                            LOGGER.fine("Candidate reachable: " + candidate.getIp() + ":" + candidate.getPort() + " from " + ICECandidate.this.getIp() + ":" + ICECandidate.this.getPort());
                        }
                    }
                };
                for (TransportCandidate candidate : localCandidates) {
                    ICECandidate iceCandidate;
                    echo = candidate.getCandidateEcho();
                    if (echo == null || !(candidate instanceof ICECandidate) || !(iceCandidate = (ICECandidate)candidate).getType().equals((Object)ICECandidate.this.getType())) continue;
                    try {
                        echo.addResultListener(resultListener);
                        InetAddress address = InetAddress.getByName(ICECandidate.this.getIp());
                        echo.testASync(checkingCandidate, ICECandidate.this.getPassword());
                    }
                    catch (UnknownHostException e) {
                        LOGGER.log(Level.WARNING, "exception", e);
                    }
                }
                for (int i = 0; i < 10 && !result.isReachable(); ++i) {
                    try {
                        LOGGER.severe("ICE Candidate retry #" + i);
                        Thread.sleep(400L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.WARNING, "exception", e);
                    }
                }
                for (TransportCandidate candidate : localCandidates) {
                    echo = candidate.getCandidateEcho();
                    if (echo == null) continue;
                    echo.removeResultListener(resultListener);
                }
                ICECandidate.this.triggerCandidateChecked(result.isReachable());
            }
        }, "Transport candidate check");
        checkThread.setName("Transport candidate test");
        checkThread.start();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICECandidate other = (ICECandidate)obj;
        if (this.getChannel() == null ? other.getChannel() != null : !this.getChannel().equals(other.getChannel())) {
            return false;
        }
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        if (this.getNetwork() != other.getNetwork()) {
            return false;
        }
        if (this.getPassword() == null ? other.getPassword() != null : !this.getPassword().equals(other.password)) {
            return false;
        }
        if (this.getPreference() != other.getPreference()) {
            return false;
        }
        if (this.getProto() == null ? other.getProto() != null : !this.getProto().equals(other.getProto())) {
            return false;
        }
        if (this.getUsername() == null ? other.getUsername() != null : !this.getUsername().equals(other.getUsername())) {
            return false;
        }
        if (this.getIp() == null ? other.getIp() != null : !this.getIp().equals(other.getIp())) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        return !(this.getType() == null ? other.getType() != null : !this.getType().equals((Object)other.getType()));
    }

    public int hashCode() {
        int res = 37;
        res = 37 * res + (this.getChannel() == null ? 0 : this.getChannel().hashCode());
        res = 37 * res + (this.getId() == null ? 0 : this.getId().hashCode());
        res = 37 * res + this.getNetwork();
        res = 37 * res + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        res = 37 * res + this.getPreference();
        res = 37 * res + (this.getProto() == null ? 0 : this.getProto().hashCode());
        res = 37 * res + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        res = 37 * res + (this.getIp() == null ? 0 : this.getIp().hashCode());
        res = 37 * res + this.getPort();
        res = 37 * res + (this.getType() == null ? 0 : this.getType().hashCode());
        return res;
    }

    @Override
    public boolean isNull() {
        if (super.isNull()) {
            return true;
        }
        if (this.getProto().isNull()) {
            return true;
        }
        return this.getChannel().isNull();
    }

    @Override
    public int compareTo(ICECandidate arg) {
        if (this.getPreference() < arg.getPreference()) {
            return -1;
        }
        if (this.getPreference() > arg.getPreference()) {
            return 1;
        }
        return 0;
    }

    public static enum Type {
        relay,
        srflx,
        prflx,
        local,
        host;

    }
}

