/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.media;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.media.MediaReceivedListener;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;

public abstract class JingleMediaSession {
    private PayloadType payloadType;
    private TransportCandidate local;
    private TransportCandidate remote;
    private String mediaLocator;
    private List<MediaReceivedListener> mediaReceivedListeners = new ArrayList<MediaReceivedListener>();
    private JingleSession jingleSession;

    public JingleMediaSession(PayloadType payloadType, TransportCandidate remote, TransportCandidate local, String mediaLocator, JingleSession jingleSession) {
        this.local = local;
        this.remote = remote;
        this.payloadType = payloadType;
        this.mediaLocator = mediaLocator;
        this.jingleSession = jingleSession;
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public TransportCandidate getLocal() {
        return this.local;
    }

    public TransportCandidate getRemote() {
        return this.remote;
    }

    public String getMediaLocator() {
        return this.mediaLocator;
    }

    public void setMediaLocator(String mediaLocator) {
        this.mediaLocator = mediaLocator;
    }

    public void addMediaReceivedListener(MediaReceivedListener mediaReceivedListener) {
        this.mediaReceivedListeners.add(mediaReceivedListener);
    }

    public void removeMediaReceivedListener(MediaReceivedListener mediaReceivedListener) {
        this.mediaReceivedListeners.remove(mediaReceivedListener);
    }

    public void removeAllMediaReceivedListener() {
        this.mediaReceivedListeners.clear();
    }

    public abstract void initialize();

    public abstract void startTransmit();

    public abstract void startReceive();

    public abstract void setTransmit(boolean var1);

    public abstract void stopTransmit();

    public abstract void stopReceive();

    public void mediaReceived(String participant) {
        for (MediaReceivedListener mediaReceivedListener : this.mediaReceivedListeners) {
            mediaReceivedListener.mediaReceived(participant);
        }
    }

    public JingleSession getJingleSession() {
        return this.jingleSession;
    }
}

