/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.mediaimpl.jspeex;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.NoProcessorException;
import javax.media.format.UnsupportedFormatException;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import mil.jfcom.cie.media.session.MediaSession;
import mil.jfcom.cie.media.session.MediaSessionListener;
import mil.jfcom.cie.media.session.StreamPlayer;
import mil.jfcom.cie.media.srtp.packetizer.SpeexFormat;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.media.JingleMediaSession;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;

public class AudioMediaSession
extends JingleMediaSession
implements MediaSessionListener {
    private static final Logger LOGGER = Logger.getLogger(AudioMediaSession.class.getName());
    private MediaSession mediaSession;

    public static MediaSession createSession(String localhost, int localPort, String remoteHost, int remotePort, MediaSessionListener eventHandler, int quality, boolean secure, boolean micOn) throws NoProcessorException, UnsupportedFormatException, IOException, GeneralSecurityException {
        SpeexFormat.setFramesPerPacket((int)1);
        byte[] masterKey = new byte[]{-31, -7, 122, 13, 62, 1, -117, -32, -42, 79, -93, 44, 6, -34, 65, 57};
        byte[] masterSalt = new byte[]{14, -58, 117, -83, 73, -118, -2, -21, -74, -106, 11, 58, -85, -26};
        DatagramSocket[] localPorts = MediaSession.getLocalPorts((InetAddress)InetAddress.getByName(localhost), (int)localPort);
        MediaSession session = MediaSession.createInstance((String)remoteHost, (int)remotePort, (DatagramSocket[])localPorts, (int)quality, (boolean)secure, (byte[])masterKey, (byte[])masterSalt);
        session.setListener(eventHandler);
        session.setSourceDescription(new SourceDescription[]{new SourceDescription(2, "Superman", 1, false), new SourceDescription(3, "cdcie.tester@je.jfcom.mil", 1, false), new SourceDescription(5, InetAddress.getByName(localhost) + " Port " + session.getLocalDataPort(), 1, false), new SourceDescription(6, "JFCOM CDCIE Audio Chat", 1, false)});
        return session;
    }

    public AudioMediaSession(PayloadType payloadType, TransportCandidate remote, TransportCandidate local, String locator, JingleSession jingleSession) {
        super(payloadType, remote, local, locator == null ? "dsound://" : locator, jingleSession);
        this.initialize();
    }

    @Override
    public void initialize() {
        int remotePort;
        int localPort;
        String localIp;
        String ip;
        if (this.getLocal().getSymmetric() != null) {
            ip = this.getLocal().getIp();
            localIp = this.getLocal().getLocalIp();
            localPort = this.getFreePort();
            remotePort = this.getLocal().getSymmetric().getPort();
            LOGGER.fine(this.getLocal().getConnection() + " " + ip + ": " + localPort + "->" + remotePort);
        } else {
            ip = this.getRemote().getIp();
            localIp = this.getLocal().getLocalIp();
            localPort = this.getLocal().getPort();
            remotePort = this.getRemote().getPort();
        }
        try {
            this.mediaSession = AudioMediaSession.createSession(localIp, localPort, ip, remotePort, this, 2, false, true);
        }
        catch (NoProcessorException e) {
            LOGGER.log(Level.WARNING, "exception", e);
        }
        catch (UnsupportedFormatException e) {
            LOGGER.log(Level.WARNING, "exception", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "exception", e);
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.WARNING, "exception", e);
        }
    }

    @Deprecated
    public void startTrasmit() {
        this.startTransmit();
    }

    @Override
    public void startTransmit() {
        try {
            LOGGER.fine("start");
            this.mediaSession.start(true);
            this.mediaReceived("");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "exception", e);
        }
    }

    @Deprecated
    public void setTrasmit(boolean active) {
        this.setTransmit(active);
    }

    @Override
    public void setTransmit(boolean active) {
    }

    @Override
    public void startReceive() {
    }

    @Deprecated
    public void stopTrasmit() {
        this.stopTransmit();
    }

    @Override
    public void stopTransmit() {
        if (this.mediaSession != null) {
            this.mediaSession.close();
        }
    }

    @Override
    public void stopReceive() {
    }

    public void newStreamIdentified(StreamPlayer streamPlayer) {
    }

    public void senderReportReceived(SenderReport report) {
    }

    public void streamClosed(StreamPlayer stream, boolean timeout) {
    }

    protected int getFreePort() {
        int freePort = 0;
        for (int i = 0; i < 10; ++i) {
            freePort = (int)(10000L + Math.round(Math.random() * 10000.0));
            freePort = freePort % 2 == 0 ? freePort : freePort + 1;
            try {
                ServerSocket ss = new ServerSocket(freePort);
                freePort = ss.getLocalPort();
                ss.close();
                return freePort;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "exception", e);
                continue;
            }
        }
        try {
            ServerSocket ss = new ServerSocket(0);
            freePort = ss.getLocalPort();
            ss.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "exception", e);
        }
        return freePort;
    }
}

