/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jingleold.JingleActionEnum;
import org.jivesoftware.smackx.jingleold.packet.Jingle;
import org.jivesoftware.smackx.jingleold.packet.JingleContent;
import org.jivesoftware.smackx.jingleold.packet.JingleContentInfo;
import org.jivesoftware.smackx.jingleold.packet.JingleDescription;
import org.jivesoftware.smackx.jingleold.packet.JingleTransport;
import org.jivesoftware.smackx.jingleold.provider.JingleContentInfoProvider;
import org.jivesoftware.smackx.jingleold.provider.JingleContentProvider;
import org.jivesoftware.smackx.jingleold.provider.JingleDescriptionProvider;
import org.jivesoftware.smackx.jingleold.provider.JingleTransportProvider;
import org.jxmpp.jid.Jid;

public class JingleProvider
extends IqProvider<Jingle> {
    public Jingle parse(XmlPullParser parser, int intialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws IOException, XmlPullParserException, SmackParsingException {
        Jingle jingle = new Jingle();
        boolean done = false;
        JingleContent currentContent = null;
        JingleContentProvider jcp = new JingleContentProvider();
        JingleDescriptionProvider.Audio jdpAudio = new JingleDescriptionProvider.Audio();
        JingleTransportProvider.RawUdp jtpRawUdp = new JingleTransportProvider.RawUdp();
        JingleTransportProvider.Ice jtpIce = new JingleTransportProvider.Ice();
        JingleContentInfoProvider.Audio jmipAudio = new JingleContentInfoProvider.Audio();
        String sid = parser.getAttributeValue("", "sid");
        JingleActionEnum action = JingleActionEnum.getAction(parser.getAttributeValue("", "action"));
        Jid initiator = ParserUtils.getJidAttribute((XmlPullParser)parser, (String)"initiator");
        Jid responder = ParserUtils.getJidAttribute((XmlPullParser)parser, (String)"responder");
        jingle.setSid(sid);
        jingle.setAction(action);
        jingle.setInitiator(initiator);
        jingle.setResponder(responder);
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                String elementName = parser.getName();
                String namespace = parser.getNamespace();
                if (elementName.equals("content")) {
                    currentContent = (JingleContent)jcp.parse(parser);
                    jingle.addContent(currentContent);
                    continue;
                }
                if (elementName.equals("description") && namespace.equals("urn:xmpp:tmp:jingle:apps:rtp")) {
                    currentContent.setDescription((JingleDescription)jdpAudio.parse(parser));
                    continue;
                }
                if (elementName.equals("transport")) {
                    if (namespace.equals("http://www.xmpp.org/extensions/xep-0177.html#ns")) {
                        currentContent.addJingleTransport((JingleTransport)jtpRawUdp.parse(parser));
                        continue;
                    }
                    if (namespace.equals("urn:xmpp:tmp:jingle:transports:ice-udp")) {
                        currentContent.addJingleTransport((JingleTransport)jtpIce.parse(parser));
                        continue;
                    }
                    throw new IOException("Unknown transport namespace \"" + namespace + "\" in Jingle packet.");
                }
                if (namespace.equals("urn:xmpp:tmp:jingle:apps:rtp")) {
                    jingle.setContentInfo((JingleContentInfo)jmipAudio.parse(parser));
                    continue;
                }
                throw new IOException("Unknown combination of namespace \"" + namespace + "\" and element name \"" + elementName + "\" in Jingle packet.");
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("jingle")) continue;
            done = true;
        }
        return jingle;
    }
}

