/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingleold.ContentNegotiator;
import org.jivesoftware.smackx.jingleold.JingleActionEnum;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.JingleSessionState;
import org.jivesoftware.smackx.jingleold.JingleSessionStatePending;
import org.jivesoftware.smackx.jingleold.media.JingleMediaManager;
import org.jivesoftware.smackx.jingleold.media.MediaNegotiator;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingleold.nat.TransportNegotiator;
import org.jivesoftware.smackx.jingleold.nat.TransportResolver;
import org.jivesoftware.smackx.jingleold.packet.Jingle;
import org.jivesoftware.smackx.jingleold.packet.JingleContent;
import org.jivesoftware.smackx.jingleold.packet.JingleDescription;
import org.jivesoftware.smackx.jingleold.packet.JingleError;
import org.jivesoftware.smackx.jingleold.packet.JingleTransport;

public class JingleSessionStateUnknown
extends JingleSessionState {
    private static final Logger LOGGER = Logger.getLogger(JingleSessionStateUnknown.class.getName());
    private static JingleSessionStateUnknown INSTANCE = null;

    protected JingleSessionStateUnknown() {
    }

    public static synchronized JingleSessionState getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JingleSessionStateUnknown();
        }
        return INSTANCE;
    }

    @Override
    public void enter() {
    }

    @Override
    public void exit() {
    }

    @Override
    public IQ processJingle(JingleSession session, Jingle jingle, JingleActionEnum action) throws SmackException, InterruptedException {
        IQ response;
        switch (action) {
            case SESSION_INITIATE: {
                response = JingleSessionStateUnknown.receiveSessionInitiateAction(session, jingle);
                break;
            }
            case SESSION_TERMINATE: {
                response = JingleSessionStateUnknown.receiveSessionTerminateAction(session, jingle);
                break;
            }
            default: {
                response = session.createJingleError(jingle, JingleError.MALFORMED_STANZA);
            }
        }
        return response;
    }

    private static IQ receiveSessionInitiateAction(JingleSession session, Jingle inJingle) throws SmackException, InterruptedException {
        IQ response;
        boolean shouldAck = true;
        if (!shouldAck) {
            response = session.createJingleError(inJingle, JingleError.NEGOTIATION_ERROR);
        } else {
            response = session.createAck(inJingle);
            session.setSessionState(JingleSessionStatePending.getInstance());
            for (JingleContent jingleContent : inJingle.getContentsList()) {
                ContentNegotiator contentNeg = new ContentNegotiator(session, jingleContent.getCreator(), jingleContent.getName());
                JingleDescription jingleDescription = jingleContent.getDescription();
                JingleMediaManager chosenMediaManager = session.getMediaManagers().get(0);
                for (JingleMediaManager mediaManager : session.getMediaManagers()) {
                    boolean matches = true;
                    for (PayloadType mediaPayloadType : mediaManager.getPayloads()) {
                        for (PayloadType descPayloadType2 : jingleDescription.getPayloadTypesList()) {
                            if (mediaPayloadType.getId() == descPayloadType2.getId()) continue;
                            matches = false;
                        }
                        if (!matches) continue;
                        chosenMediaManager = mediaManager;
                    }
                }
                contentNeg.setMediaNegotiator(new MediaNegotiator(session, chosenMediaManager, jingleDescription.getPayloadTypesList(), contentNeg));
                for (JingleTransport jingleTransport : jingleContent.getJingleTransportsList()) {
                    for (JingleMediaManager mediaManager : session.getMediaManagers()) {
                        JingleTransportManager transportManager = mediaManager.getTransportManager();
                        TransportResolver resolver = null;
                        try {
                            resolver = transportManager.getResolver(session);
                        }
                        catch (XMPPException e) {
                            LOGGER.log(Level.WARNING, "exception", e);
                        }
                        if (resolver.getType().equals((Object)TransportResolver.Type.rawupd)) {
                            contentNeg.setTransportNegotiator(new TransportNegotiator.RawUdp(session, resolver, contentNeg));
                        }
                        if (!resolver.getType().equals((Object)TransportResolver.Type.ice)) continue;
                        contentNeg.setTransportNegotiator(new TransportNegotiator.Ice(session, resolver, contentNeg));
                    }
                }
                session.addContentNegotiator(contentNeg);
            }
            session.setupListeners();
        }
        return response;
    }

    private static IQ receiveSessionTerminateAction(JingleSession session, Jingle jingle) {
        IQ response = session.createAck(jingle);
        try {
            session.terminate("Closed remotely");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "exception", e);
        }
        return response;
    }
}

