/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.media;

public class PayloadType {
    public static final String NODENAME = "payload-type";
    public static int MAX_FIXED_PT = 95;
    public static int INVALID_PT = 65535;
    private int id;
    private String name;
    private int channels;

    public PayloadType(int id, String name, int channels) {
        this.id = id;
        this.name = name;
        this.channels = channels;
    }

    public PayloadType() {
        this(INVALID_PT, null, 1);
    }

    public PayloadType(int id, String name) {
        this(id, name, 1);
    }

    public PayloadType(PayloadType pt) {
        this(pt.getId(), pt.getName(), pt.getChannels());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public boolean isNull() {
        if (this.getId() == INVALID_PT) {
            return true;
        }
        return this.getName() == null;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.getChannels();
        result = 31 * result + this.getId();
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayloadType)) {
            return false;
        }
        PayloadType other = (PayloadType)obj;
        if (this.getChannels() != other.getChannels()) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return this.getId() <= MAX_FIXED_PT || !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    public static String getElementName() {
        return NODENAME;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append('<').append(PayloadType.getElementName()).append(' ');
        if (this.getId() != INVALID_PT) {
            buf.append(" id=\"").append(this.getId()).append('\"');
        }
        if (this.getName() != null) {
            buf.append(" name=\"").append(this.getName()).append('\"');
        }
        if (this.getChannels() != 0) {
            buf.append(" channels=\"").append(this.getChannels()).append('\"');
        }
        if (this.getChildAttributes() != null) {
            buf.append(this.getChildAttributes());
        }
        buf.append("/>");
        return buf.toString();
    }

    protected String getChildAttributes() {
        StringBuilder buf = new StringBuilder();
        if (this instanceof Audio) {
            Audio pta = (Audio)this;
            buf.append(" clockrate=\"").append(pta.getClockRate()).append("\" ");
        }
        return buf.toString();
    }

    public static final class Audio
    extends PayloadType {
        private int clockRate;

        public Audio(int id, String name, int channels, int rate) {
            super(id, name, channels);
            this.clockRate = rate;
        }

        public Audio(int id, String name, int rate) {
            super(id, name);
            this.clockRate = rate;
        }

        public Audio() {
            this.clockRate = 0;
        }

        public Audio(int id, String name) {
            super(id, name);
            this.clockRate = 0;
        }

        public Audio(PayloadType pt) {
            super(pt);
            this.clockRate = 0;
        }

        public Audio(Audio pt) {
            super(pt);
            this.clockRate = pt.getClockRate();
        }

        public int getClockRate() {
            return this.clockRate;
        }

        public void setClockRate(int rate) {
            this.clockRate = rate;
        }

        @Override
        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + this.getClockRate();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Audio other = (Audio)obj;
            return this.getClockRate() == other.getClockRate();
        }
    }
}

