/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.mediaimpl.jmf;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.MediaLocator;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.media.JingleMediaSession;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.mediaimpl.jmf.AudioChannel;
import org.jivesoftware.smackx.jingleold.mediaimpl.jmf.AudioFormatUtils;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;

public class AudioMediaSession
extends JingleMediaSession {
    private static final Logger LOGGER = Logger.getLogger(AudioMediaSession.class.getName());
    private AudioChannel audioChannel;

    public AudioMediaSession(PayloadType payloadType, TransportCandidate remote, TransportCandidate local, String locator, JingleSession jingleSession) {
        super(payloadType, remote, local, locator == null ? "dsound://" : locator, jingleSession);
        this.initialize();
    }

    @Override
    public void initialize() {
        int remotePort;
        int localPort;
        String localIp;
        String ip;
        if (this.getLocal().getSymmetric() != null) {
            ip = this.getLocal().getIp();
            localIp = this.getLocal().getLocalIp();
            localPort = this.getFreePort();
            remotePort = this.getLocal().getSymmetric().getPort();
            LOGGER.fine(String.valueOf(this.getLocal().getConnection()) + " " + ip + ": " + localPort + "->" + remotePort);
        } else {
            ip = this.getRemote().getIp();
            localIp = this.getLocal().getLocalIp();
            localPort = this.getLocal().getPort();
            remotePort = this.getRemote().getPort();
        }
        this.audioChannel = new AudioChannel(new MediaLocator(this.getMediaLocator()), localIp, ip, localPort, remotePort, (Format)AudioFormatUtils.getAudioFormat(this.getPayloadType()), this);
    }

    @Deprecated
    public void startTrasmit() {
        this.startTransmit();
    }

    @Override
    public void startTransmit() {
        this.audioChannel.start();
    }

    @Deprecated
    public void setTrasmit(boolean active) {
        this.setTransmit(active);
    }

    @Override
    public void setTransmit(boolean active) {
        this.audioChannel.setTrasmit(active);
    }

    @Override
    public void startReceive() {
    }

    @Deprecated
    public void stopTrasmit() {
        this.stopTransmit();
    }

    @Override
    public void stopTransmit() {
        if (this.audioChannel != null) {
            this.audioChannel.stop();
        }
    }

    @Override
    public void stopReceive() {
    }

    protected int getFreePort() {
        int freePort = 0;
        for (int i = 0; i < 10; ++i) {
            freePort = (int)(10000L + Math.round(Math.random() * 10000.0));
            freePort = freePort % 2 == 0 ? freePort : freePort + 1;
            try {
                ServerSocket ss = new ServerSocket(freePort);
                freePort = ss.getLocalPort();
                ss.close();
                return freePort;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "exception", e);
                continue;
            }
        }
        try {
            ServerSocket ss = new ServerSocket(0);
            freePort = ss.getLocalPort();
            ss.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "exception", e);
        }
        return freePort;
    }
}

