/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.packet.JingleDescription;

public abstract class JingleDescriptionProvider
extends ExtensionElementProvider<JingleDescription> {
    protected PayloadType parsePayload(XmlPullParser parser) {
        int ptId = Integer.parseInt(parser.getAttributeValue("", "id"));
        String ptName = parser.getAttributeValue("", "name");
        int ptChannels = Integer.parseInt(parser.getAttributeValue("", "channels"));
        return new PayloadType(ptId, ptName, ptChannels);
    }

    public JingleDescription parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        JingleDescription desc = this.getInstance();
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                String name = parser.getName();
                if (name.equals("payload-type")) {
                    desc.addPayloadType(this.parsePayload(parser));
                    continue;
                }
                throw new IOException("Unknow element \"" + name + "\" in content.");
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
        }
        return desc;
    }

    protected abstract JingleDescription getInstance();

    public static class Audio
    extends JingleDescriptionProvider {
        @Override
        public PayloadType parsePayload(XmlPullParser parser) {
            PayloadType pte = super.parsePayload(parser);
            PayloadType.Audio pt = new PayloadType.Audio(pte);
            int ptClockRate = Integer.parseInt(parser.getAttributeValue("", "clockrate"));
            pt.setClockRate(ptClockRate);
            return pt;
        }

        @Override
        protected JingleDescription getInstance() {
            return new JingleDescription.Audio();
        }
    }
}

