/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.mediaimpl.jmf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smackx.jingleold.JingleSession;
import org.jivesoftware.smackx.jingleold.media.JingleMediaManager;
import org.jivesoftware.smackx.jingleold.media.JingleMediaSession;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.mediaimpl.JMFInit;
import org.jivesoftware.smackx.jingleold.mediaimpl.jmf.AudioMediaSession;
import org.jivesoftware.smackx.jingleold.nat.JingleTransportManager;
import org.jivesoftware.smackx.jingleold.nat.TransportCandidate;

public class JmfMediaManager
extends JingleMediaManager {
    private static final Logger LOGGER = Logger.getLogger(JmfMediaManager.class.getName());
    public static final String MEDIA_NAME = "JMF";
    private List<PayloadType> payloads = new ArrayList<PayloadType>();
    private String mediaLocator = null;

    public JmfMediaManager(JingleTransportManager transportManager) {
        super(transportManager);
        this.setupPayloads();
    }

    public JmfMediaManager(String mediaLocator, JingleTransportManager transportManager) {
        super(transportManager);
        this.mediaLocator = mediaLocator;
        this.setupPayloads();
    }

    @Override
    public JingleMediaSession createMediaSession(PayloadType payloadType, TransportCandidate remote, TransportCandidate local, JingleSession jingleSession) {
        return new AudioMediaSession(payloadType, remote, local, this.mediaLocator, jingleSession);
    }

    private void setupPayloads() {
        this.payloads.add(new PayloadType.Audio(3, "gsm"));
        this.payloads.add(new PayloadType.Audio(4, "g723"));
        this.payloads.add(new PayloadType.Audio(0, "PCMU", 16000));
    }

    @Override
    public List<PayloadType> getPayloads() {
        return this.payloads;
    }

    public String getMediaLocator() {
        return this.mediaLocator;
    }

    public void setMediaLocator(String mediaLocator) {
        this.mediaLocator = mediaLocator;
    }

    public static void setupJMF() {
        File jmfProperties;
        String homeDir = System.getProperty("user.home");
        File jmfDir = new File(homeDir, ".jmf");
        Object classpath = System.getProperty("java.class.path");
        classpath = (String)classpath + System.getProperty("path.separator") + jmfDir.getAbsolutePath();
        System.setProperty("java.class.path", (String)classpath);
        if (!jmfDir.exists()) {
            jmfDir.mkdir();
        }
        if (!(jmfProperties = new File(jmfDir, "jmf.properties")).exists()) {
            try {
                jmfProperties.createNewFile();
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Failed to create jmf.properties", ex);
            }
        }
        JmfMediaManager.runLinuxPreInstall();
        new JMFInit(null, false);
    }

    private static void runLinuxPreInstall() {
    }

    @Override
    public String getName() {
        return MEDIA_NAME;
    }
}

